/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service;

import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.domain.Exercicio;
import br.com.elotech.portaltransparencia.contabportal.domain.ExercicioPK;
import br.com.elotech.portaltransparencia.contabportal.domain.QExercicio;
import br.com.elotech.portaltransparencia.contabportal.repository.ExercicioRepository;
import br.com.elotech.portaltransparencia.contabportal.service.EntidadeContabilidadeService;
import br.com.elotech.portaltransparencia.contabportal.service.ExercicioService;
import br.com.elotech.portaltransparencia.utils.ExercicioParamsUtils;
import com.google.common.collect.Lists;
import com.querydsl.core.types.Predicate;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Sort;

public class ExercicioSustentacaoService
implements ExercicioService {
    private final ExercicioRepository exercicioRepository;
    private final EntidadeContabilidadeService entidadeService;
    private final ExercicioParamsUtils exercicioUtils;

    public ExercicioSustentacaoService(ExercicioRepository exercicioRepository, EntidadeContabilidadeService entidadeService, ExercicioParamsUtils exercicioUtils) {
        this.exercicioRepository = exercicioRepository;
        this.entidadeService = entidadeService;
        this.exercicioUtils = exercicioUtils;
    }

    public List<Exercicio> getExercicios(Long idEntidade) {
        Entidade entidade = this.entidadeService.getEntidadeSelecionada(idEntidade);
        Long anoInicial = this.exercicioUtils.getAnoInicial(idEntidade);
        Long anoFinal = this.exercicioUtils.getAnoFinal(idEntidade);
        Iterable exerciciosIterable = this.exercicioRepository.findAll((Predicate)QExercicio.exercicio.id().entidade().eq((Object)entidade).and((Predicate)QExercicio.exercicio.id().exercicio.between((Number)anoInicial, (Number)anoFinal)), this.sortByIdDesc());
        return Lists.newArrayList((Iterable)exerciciosIterable);
    }

    public List<Exercicio> getExerciciosByAno(Long idEntidade, Long ano) {
        Entidade entidade = this.entidadeService.getEntidadeSelecionada(idEntidade);
        Long anoInicial = 0L;
        Long anoFinal = 0L;
        if (ano > 0L) {
            anoInicial = ano;
            anoFinal = ano;
        } else {
            anoInicial = this.exercicioUtils.getAnoInicial(idEntidade);
            anoFinal = this.exercicioUtils.getAnoFinal(idEntidade);
        }
        Iterable exerciciosIterable = this.exercicioRepository.findAll((Predicate)QExercicio.exercicio.id().entidade().eq((Object)entidade).and((Predicate)QExercicio.exercicio.id().exercicio.between((Number)anoInicial, (Number)anoFinal)), this.sortByIdDesc());
        return Lists.newArrayList((Iterable)exerciciosIterable);
    }

    private Sort sortByIdDesc() {
        return Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id.exercicio"});
    }

    public Optional<Exercicio> findExercicioPadrao() {
        Optional entidadePrincipal = this.entidadeService.getEntidadePrincipal();
        return this.getExercicios(entidadePrincipal.orElse(new Entidade()).getId()).stream().findFirst();
    }

    public Exercicio findOne(ExercicioPK pk) {
        return (Exercicio)this.exercicioRepository.findOne((Object)pk);
    }

    public Long findModeloDespesa(Long entidade, Long exercicio) {
        ExercicioPK exercicioPK = new ExercicioPK(Entidade.of((Long)entidade), exercicio);
        return ((Exercicio)this.exercicioRepository.findOne((Object)exercicioPK)).getModeloDespesa().getId();
    }
}

