/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service;

import br.com.elotech.portaltransparencia.contabportal.domain.ConfiguracaoInterface;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.domain.Exercicio;
import br.com.elotech.portaltransparencia.contabportal.domain.ExercicioPK;
import br.com.elotech.portaltransparencia.contabportal.service.ConfiguracaoService;
import br.com.elotech.portaltransparencia.contabportal.service.EntidadeContabilidadeService;
import br.com.elotech.portaltransparencia.contabportal.service.ExercicioService;
import br.com.elotech.portaltransparencia.utils.ExercicioParamsUtils;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import lombok.Generated;

public class ExercicioOxyService
implements ExercicioService {
    private final EntidadeContabilidadeService entidadeContabilidadeService;
    private final ExercicioParamsUtils exercicioUtils;
    private final ConfiguracaoService configuracaoService;

    public List<Exercicio> getExercicios(Long idEntidade) {
        Entidade entidadeSelecionada = Optional.ofNullable(this.entidadeContabilidadeService.findOne(idEntidade)).orElseThrow(() -> new IllegalArgumentException("Entidade selecionada n\u00e3o existe"));
        ConfiguracaoInterface configuracao = this.configuracaoService.getConfiguracao();
        Long anoInicial = this.getAnoDiferenteZero(configuracao.getAnoInicial(), this.exercicioUtils.getAnoInicial(idEntidade));
        Long anoFinal = this.getAnoDiferenteZero(configuracao.getAnoFinal(), this.exercicioUtils.getAnoFinal(idEntidade));
        return LongStream.rangeClosed(anoInicial, anoFinal).mapToObj(e -> Exercicio.fromExercicioContabilidade((Entidade)entidadeSelecionada, (long)e)).sorted(Comparator.comparing(Exercicio::getExercicio).reversed()).collect(Collectors.toList());
    }

    public Optional<Exercicio> findExercicioPadrao() {
        Entidade entidadePrincipal;
        List exercicios;
        Optional entidadePrincipalOptional = this.entidadeContabilidadeService.getEntidadePrincipal();
        if (entidadePrincipalOptional.isPresent() && !(exercicios = this.getExercicios((entidadePrincipal = (Entidade)entidadePrincipalOptional.get()).getId())).isEmpty()) {
            return Optional.ofNullable(exercicios.stream().filter(e -> LocalDate.now().getYear() == e.getExercicio().intValue()).findFirst().orElseGet(() -> (Exercicio)exercicios.get(0)));
        }
        return Optional.empty();
    }

    public Exercicio findOne(ExercicioPK pk) {
        return null;
    }

    public Long findModeloDespesa(Long entidade, Long exercicio) {
        return null;
    }

    private Long getAnoDiferenteZero(Long ano, Long anoEntidade) {
        if (Objects.isNull(ano) || ano.equals(0L)) {
            return anoEntidade;
        }
        return ano;
    }

    public List<Exercicio> getExerciciosByAno(Long idEntidade, Long ano) {
        return this.getExercicios(idEntidade);
    }

    @Generated
    public ExercicioOxyService(EntidadeContabilidadeService entidadeContabilidadeService, ExercicioParamsUtils exercicioUtils, ConfiguracaoService configuracaoService) {
        this.entidadeContabilidadeService = entidadeContabilidadeService;
        this.exercicioUtils = exercicioUtils;
        this.configuracaoService = configuracaoService;
    }
}

