/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource;

import br.com.elotech.portaltransparencia.contabportal.domain.TotalAcesso;
import br.com.elotech.portaltransparencia.contabportal.service.TotalAcessoService;
import java.time.LocalDate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/", "/admin"})
public class TotalAcessoResource {
    private final TotalAcessoService totalAcessoService;

    @Autowired
    public TotalAcessoResource(TotalAcessoService totalAcessoService) {
        this.totalAcessoService = totalAcessoService;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/totalacesso"})
    public ResponseEntity<TotalAcesso> getTotalAcesso() {
        return ResponseEntity.ok((Object)this.totalAcessoService.getTotalAcesso());
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/totalacessos-diario-oficial"})
    public ResponseEntity<TotalAcesso> calculateTotalAcessoDiarioOficial() {
        return ResponseEntity.ok((Object)this.totalAcessoService.calculateTotalAcessoDiarioOficial());
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/relatorio-acessos"})
    public ResponseEntity<Page<TotalAcesso>> getRelatorioAcessos(@RequestParam(value="dataInicial") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate dataInicial, @RequestParam(value="dataFinal") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate dataFinal, Pageable pageable) {
        return ResponseEntity.ok((Object)this.totalAcessoService.getRelatorioAcessos(dataInicial, dataFinal, pageable));
    }
}

