/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource;

import br.com.elotech.portaltransparencia.contabportal.domain.dto.ReceitaDTO;
import br.com.elotech.portaltransparencia.contabportal.resource.params.FindReceitaParams;
import br.com.elotech.portaltransparencia.contabportal.service.ConfiguracaoService;
import br.com.elotech.portaltransparencia.contabportal.service.ReceitaXDespesaService;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/receitaxdespesa"})
public class ReceitaXDespesaResource {
    private final ReceitaXDespesaService service;
    private final ConfiguracaoService configuracaoService;

    public ReceitaXDespesaResource(ReceitaXDespesaService service, ConfiguracaoService configuracaoService) {
        this.service = service;
        this.configuracaoService = configuracaoService;
    }

    @GetMapping(value={"/arrecadacao-despesa"})
    public ResponseEntity<List<ReceitaDTO>> findReceitasEmpenhosPorMes(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, Boolean fundeb) {
        FindReceitaParams params = new FindReceitaParams();
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        params.setFundeb(fundeb);
        Optional configuracao = this.configuracaoService.getConfiguracaoOptional();
        configuracao.ifPresent(item -> params.setNumeroDias(item.getNumeroDias()));
        return ResponseEntity.ok((Object)this.service.findReceitasEmpenhadosPorMes(params));
    }

    @GetMapping(value={"/empenhado-anual"})
    public ResponseEntity<BigDecimal> getValorEmpenhadoAnual(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, Boolean fundeb) {
        FindReceitaParams params = new FindReceitaParams();
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        params.setFundeb(fundeb);
        return ResponseEntity.ok((Object)Optional.ofNullable(this.service.getValorEmpenhadoAnual(params)).orElse(BigDecimal.ZERO));
    }
}

