/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource;

import br.com.elotech.core.config.ElotechProperties;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.NotaExtraorcamentariaDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.NotaExtraorcamentariaItemDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.EntidadeContabilidadeRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.NotaExtraorcamentariaParams;
import br.com.elotech.portaltransparencia.contabportal.service.NotaExtraorcamentariaService;
import br.com.elotech.reportexport.exporter.BaseExport;
import br.com.elotech.reportexport.exporter.ReportParam;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/api/nota-extraorcamentaria"})
public class NotaExtraorcamentariaResource {
    private final NotaExtraorcamentariaService service;
    private final BaseExport baseExport;
    private final ElotechProperties elotechProperties;
    private final EntidadeContabilidadeRepository entidadeRepository;

    @Autowired
    public NotaExtraorcamentariaResource(NotaExtraorcamentariaService service, BaseExport baseExport, ElotechProperties elotechProperties, EntidadeContabilidadeRepository entidadeRepository) {
        this.service = service;
        this.baseExport = baseExport;
        this.elotechProperties = elotechProperties;
        this.entidadeRepository = entidadeRepository;
    }

    @GetMapping
    public ResponseEntity<Page<NotaExtraorcamentariaDTO>> findNotasExtraorcamentarias(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, NotaExtraorcamentariaParams params, Pageable pageable) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.service.findNotasExtraorcamentarias(params, pageable));
    }

    @GetMapping(value={"/detalhes"})
    public ResponseEntity<NotaExtraorcamentariaDTO> findNotaExtraorcamentaria(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, NotaExtraorcamentariaParams params) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.service.findNotaExtraorcamentaria(params));
    }

    @GetMapping(value={"/itens"})
    public List<NotaExtraorcamentariaItemDTO> findNotaExtraorcamentariaItens(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, NotaExtraorcamentariaParams params) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        return this.service.findNotaExtraorcamentariaItens(params);
    }

    @GetMapping(value={"/report"})
    public ModelAndView exportListLicitacoes(HttpServletRequest request, HttpServletResponse response, NotaExtraorcamentariaParams params, Pageable pageable) throws Throwable {
        PageRequest pageRequest = PageRequest.of((int)0, (int)this.elotechProperties.getReport().getMaximoRegistros(), (Sort)pageable.getSort());
        Page page = this.service.findNotasExtraorcamentarias(params, (Pageable)pageRequest);
        Entidade entidade = (Entidade)this.entidadeRepository.findOne((Object)params.getEntidade());
        ReportParam reportParam = new ReportParam();
        reportParam.setNomeEntidade(entidade.getNome());
        reportParam.setReportTitle("Listagem das Notas Extraor\u00e7ament\u00e1ria");
        reportParam.setClazzDTO(NotaExtraorcamentariaDTO.class);
        reportParam.setHeaderFields("N\u00ba Nota,Data,Credor,Valor");
        reportParam.setFields("noNotaExercicio,data,cnpjNomeFornecedor,valor");
        float[] fieldsPerc = new float[]{0.8f, 0.8f, 2.0f, 0.8f};
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        int[] fieldTab = new int[]{15, 15, 500, 30};
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setPage(page);
        reportParam.setFontSize(8.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(params.getExportType());
        return this.baseExport.toExport(reportParam);
    }
}

