/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource;

import br.com.elotech.portaltransparencia.contabportal.domain.dto.ReceitaDTO;
import br.com.elotech.portaltransparencia.contabportal.resource.params.FindReceitaParams;
import br.com.elotech.portaltransparencia.contabportal.service.ConfiguracaoService;
import br.com.elotech.portaltransparencia.contabportal.service.DashboardService;
import br.com.elotech.portaltransparencia.contabportal.service.EntidadeContabilidadeService;
import java.util.List;
import java.util.Optional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dashboard"})
public class DashboardResource {
    private final DashboardService service;
    private final ConfiguracaoService configuracaoService;
    private final EntidadeContabilidadeService entidadeService;

    public DashboardResource(DashboardService service, ConfiguracaoService configuracaoService, EntidadeContabilidadeService entidadeService) {
        this.service = service;
        this.configuracaoService = configuracaoService;
        this.entidadeService = entidadeService;
    }

    @GetMapping(value={"/arrecadacao-despesa"})
    public ResponseEntity<List<ReceitaDTO>> findReceitasEmpenhosPorMes(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio) {
        FindReceitaParams params = new FindReceitaParams();
        params.setEntidade(this.entidadeService.getEntidadeSelecionada(entidade).getId());
        params.setExercicio(exercicio);
        Optional configuracao = this.configuracaoService.getConfiguracaoOptional();
        configuracao.ifPresent(item -> params.setNumeroDias(item.getNumeroDias()));
        return ResponseEntity.ok((Object)this.service.findReceitasEmpenhadosPorMes(params));
    }

    @GetMapping(value={"/receita"})
    public ResponseEntity<?> getReceitaValorAtualizado(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio) {
        FindReceitaParams params = new FindReceitaParams();
        params.setEntidade(this.entidadeService.getEntidadeSelecionada(entidade).getId());
        params.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.service.getReceitaValorAtualizado(params));
    }

    @GetMapping(value={"/despesa"})
    public ResponseEntity<?> getDespesaValorAtualizado(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio) {
        FindReceitaParams params = new FindReceitaParams();
        params.setEntidade(this.entidadeService.getEntidadeSelecionada(entidade).getId());
        params.setExercicio(exercicio);
        Optional configuracao = this.configuracaoService.getConfiguracaoOptional();
        configuracao.ifPresent(item -> params.setNumeroDias(item.getNumeroDias()));
        return ResponseEntity.ok((Object)this.service.getDespesaValorAtualizado(params));
    }

    @GetMapping(value={"/pessoal"})
    public ResponseEntity<?> findGastosPessoal(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio) {
        FindReceitaParams params = new FindReceitaParams();
        params.setEntidade(this.entidadeService.getEntidadeSelecionada(entidade).getId());
        params.setExercicio(exercicio);
        Optional configuracao = this.configuracaoService.getConfiguracaoOptional();
        configuracao.ifPresent(item -> params.setNumeroDias(item.getNumeroDias()));
        return ResponseEntity.ok((Object)this.service.findGastosPessoal(params));
    }

    @GetMapping(value={"/educacao"})
    public ResponseEntity<?> findGastosEducacao(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio) {
        FindReceitaParams params = new FindReceitaParams();
        params.setEntidade(this.entidadeService.getEntidadeSelecionada(entidade).getId());
        params.setExercicio(exercicio);
        Optional configuracao = this.configuracaoService.getConfiguracaoOptional();
        configuracao.ifPresent(item -> params.setNumeroDias(item.getNumeroDias()));
        return ResponseEntity.ok((Object)this.service.findGastosEducacao(params));
    }

    @GetMapping(value={"/saude"})
    public ResponseEntity<?> findGastosSaude(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio) {
        FindReceitaParams params = new FindReceitaParams();
        params.setEntidade(this.entidadeService.getEntidadeSelecionada(entidade).getId());
        params.setExercicio(exercicio);
        Optional configuracao = this.configuracaoService.getConfiguracaoOptional();
        configuracao.ifPresent(item -> params.setNumeroDias(item.getNumeroDias()));
        return ResponseEntity.ok((Object)this.service.findGastosSaude(params));
    }

    @GetMapping(value={"/receita-dashboard"})
    public ResponseEntity<List<ReceitaDTO>> findReceitasDashBoardPorMes(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio) {
        FindReceitaParams params = new FindReceitaParams();
        params.setEntidade(this.entidadeService.getEntidadeSelecionada(entidade).getId());
        params.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.service.findReceitasDashBoardPorMes(params));
    }
}

