/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.enumerable.common.SimNao;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.admportal.domain.Parametros;
import br.com.elotech.portaltransparencia.admportal.service.PortalParametroService;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.Parametro;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ReceitaDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.enums.ParametroEnum;
import br.com.elotech.portaltransparencia.contabportal.repository.ReceitaXDespesaRepository;
import br.com.elotech.portaltransparencia.contabportal.repository.impl.EntidadeContabilidadeRepositoryImpl;
import br.com.elotech.portaltransparencia.contabportal.repository.impl.ParametroRepositoryImpl;
import br.com.elotech.portaltransparencia.contabportal.resource.params.FindReceitaParams;
import br.com.elotech.portaltransparencia.contabportal.service.EntidadeContabilidadeService;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class ReceitaXDespesaRepositoryImpl
implements ReceitaXDespesaRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReceitaXDespesaRepositoryImpl.class);
    private static final String RECEITAS_EMPENHADOS_MES = "db/sql/contab/receitas_empenhados_mes_covid.sql";
    private static final String RECEITAS_EMPENHADOS_MES_FUNDEB = "db/sql/contab/receitas_empenhados_mes_fundeb.sql";
    private static final String RECEITAS_EMPENHADOS_MES_ENTIDADES_DIFERENTES = "db/sql/contab/receitas_empenhados_mes_covid_entidades_diferentes.sql";
    private static final String EMPENHADO_ANUAL = "db/sql/contab/empenhado_anual_covid.sql";
    private static final String EMPENHADO_ANUAL_FUNDEB = "db/sql/contab/empenhado_anual_fundeb.sql";
    private final DatasourceWrapper datasourceWrapper;
    private final EntidadeContabilidadeRepositoryImpl entidadeContabilidade;
    private final EntidadeContabilidadeService entidadeService;
    private final PortalParametroService portalParametroService;
    private final ParametroRepositoryImpl parametroContabilRepository;

    @Autowired
    public ReceitaXDespesaRepositoryImpl(DatasourceWrapper datasourceWrapper, EntidadeContabilidadeRepositoryImpl entidadeContabilidade, PortalParametroService portalParametroService, EntidadeContabilidadeService entidadeService, ParametroRepositoryImpl parametroContabilRepository) {
        this.datasourceWrapper = datasourceWrapper;
        this.entidadeContabilidade = entidadeContabilidade;
        this.portalParametroService = portalParametroService;
        this.entidadeService = entidadeService;
        this.parametroContabilRepository = parametroContabilRepository;
    }

    public List<ReceitaDTO> findReceitasEmpenhadosPorMes(FindReceitaParams params) {
        String sql = "";
        sql = params.getFundeb() != false ? FileUtils.readResourceAsString((String)RECEITAS_EMPENHADOS_MES_FUNDEB) : FileUtils.readResourceAsString((String)RECEITAS_EMPENHADOS_MES);
        sql = sql.concat(" AND EX.ENTIDADE " + this.entidadeService.resolveWhereSQL(params.getEntidade()) + "\r\n ORDER BY EX.MES ");
        if (SimNao.toBoolean((String)this.portalParametroService.getPortalParametroValor(params.getEntidade(), params.getExercicio(), Parametros.PARAM_RECEITAS_ENTIDADES_DIFERENTES)).booleanValue()) {
            sql = FileUtils.readResourceAsString((String)RECEITAS_EMPENHADOS_MES_ENTIDADES_DIFERENTES);
        }
        if (params.getFundeb().booleanValue()) {
            Object filter = "";
            Parametro paramNivel = this.parametroContabilRepository.findByEntidadeExercicioModuloAndCodigo(params.getEntidade(), params.getExercicio(), ModuloEnum.MODULO_SISCOP.getValue(), ParametroEnum.PARAM_NIVEL_FONTERECURSO_FUNDEB.getCodigo());
            String campo = switch (paramNivel.getValor()) {
                case "1" -> "codigo";
                case "2" -> "codigofontepadraotce";
                case "3" -> "codigoorigem";
                case "4" -> "codigoaplicacao";
                case "5" -> "codigodesdobramento";
                case "6" -> "identificadoruso";
                case "7" -> "codigogrupo";
                case "8" -> "codigodestinacao";
                case "9" -> "codigodetalhamento";
                default -> "codigo";
            };
            Parametro paramValor = this.parametroContabilRepository.findByEntidadeExercicioModuloAndCodigo(params.getEntidade(), params.getExercicio(), ModuloEnum.MODULO_SISCOP.getValue(), ParametroEnum.PARAM_VALOR_FONTERECURSO_FUNDEB.getCodigo());
            filter = (String)filter + " AND FRP." + campo + " in (" + paramValor.getValor().replace(";", ",") + ")";
            sql = sql.replace("$[FILTRO]", (CharSequence)filter);
        }
        this.consoleLogger(params, sql);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(this.entidadeContabilidade.getTamanhoReceita(this.entidadeService.getEntidadeSelecionada(params.getEntidade()).getId(), params.getExercicio()).intValue()), (RowMapper)new ElotechBeanPropertyRowMapper(ReceitaDTO.class));
    }

    private void consoleLogger(FindReceitaParams params, String sql) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(sql);
            LOGGER.debug(params.toString());
        }
    }

    public BigDecimal getValorEmpenhadoAnual(FindReceitaParams params) {
        String sql = "";
        sql = params.getFundeb() != false ? FileUtils.readResourceAsString((String)EMPENHADO_ANUAL_FUNDEB) : FileUtils.readResourceAsString((String)EMPENHADO_ANUAL);
        if (!SimNao.toBoolean((String)this.portalParametroService.getPortalParametroValor(params.getEntidade(), params.getExercicio(), Parametros.PARAM_DESPESAS_ENTIDADES_DIFERENTES)).booleanValue()) {
            sql = sql.concat(" AND E.ENTIDADE " + this.entidadeService.resolveWhereSQL(params.getEntidade()) + " AND E.EXERCICIO = " + params.getExercicio());
        }
        if (params.getFundeb().booleanValue()) {
            Object filter = "";
            Parametro paramNivel = this.parametroContabilRepository.findByEntidadeExercicioModuloAndCodigo(params.getEntidade(), params.getExercicio(), ModuloEnum.MODULO_SISCOP.getValue(), ParametroEnum.PARAM_NIVEL_FONTERECURSO_FUNDEB.getCodigo());
            String campo = switch (paramNivel.getValor()) {
                case "1" -> "codigo";
                case "2" -> "codigofontepadraotce";
                case "3" -> "codigoorigem";
                case "4" -> "codigoaplicacao";
                case "5" -> "codigodesdobramento";
                case "6" -> "identificadoruso";
                case "7" -> "codigogrupo";
                case "8" -> "codigodestinacao";
                case "9" -> "codigodetalhamento";
                default -> "codigo";
            };
            Parametro paramValor = this.parametroContabilRepository.findByEntidadeExercicioModuloAndCodigo(params.getEntidade(), params.getExercicio(), ModuloEnum.MODULO_SISCOP.getValue(), ParametroEnum.PARAM_VALOR_FONTERECURSO_FUNDEB.getCodigo());
            filter = (String)filter + " AND FRP." + campo + " in (" + paramValor.getValor().replace(";", ",") + ")";
            sql = sql.replace("$[FILTRO]", (CharSequence)filter);
        }
        this.consoleLogger(params, sql);
        return (BigDecimal)this.datasourceWrapper.getJdbcTemplate().queryForObject(sql, (SqlParameterSource)params.toJdbcParameter(this.entidadeContabilidade.getTamanhoReceita(this.entidadeService.getEntidadeSelecionada(params.getEntidade()).getId(), params.getExercicio()).intValue()), BigDecimal.class);
    }
}

