/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.enumerable.common.SimNao;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.admportal.domain.Parametros;
import br.com.elotech.portaltransparencia.admportal.service.PortalParametroService;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ArquivoDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.LegislativoLeiRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class LegislativoLeiRepositoryImpl
implements LegislativoLeiRepository {
    private static final String LG_LEIS = "db/sql/contab/leis_arquivo.sql";
    private static final String LG_IMAGEM = "db/sql/contab/lg_imagemlei.sql";
    private static final String LG_ARQUIVO = "db/sql/contab/lg_arquivolei.sql";
    private static final String ARQUIVO = "ARQUIVOLEI";
    private static final String IMAGEM = "IMAGEMLEI";
    public static final String SCHEMA_SISCOP = "schema_siscop";
    private final DatasourceWrapper datasourceWrapper;
    private final PortalParametroService portalParametroService;

    @Autowired
    public LegislativoLeiRepositoryImpl(DatasourceWrapper datasourceWrapper, PortalParametroService portalParametroService) {
        this.datasourceWrapper = datasourceWrapper;
        this.portalParametroService = portalParametroService;
    }

    public ArquivoDTO findOne(Long id, Long idArquivo, Long ano, String tabela) {
        StringBuilder query;
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("IDLEIATO", (Object)id, 2);
        params.addValue("ANO", (Object)ano, 2);
        Boolean schemaImagem = SimNao.toBoolean((String)this.portalParametroService.getPortalParametroValor(Parametros.NAO_DEPENDE_ENTIDADE, Parametros.NAO_DEPENDE_EXERCICIO, Parametros.PARAM_USA_LEGISLATIVO));
        if (ARQUIVO.equalsIgnoreCase(tabela) && schemaImagem.booleanValue()) {
            query = new StringBuilder(FileUtils.readResourceAsString((String)LG_ARQUIVO));
            params.addValue("IDARQUIVO", (Object)idArquivo, 2);
        } else if (IMAGEM.equalsIgnoreCase(tabela) && schemaImagem.booleanValue()) {
            query = new StringBuilder(FileUtils.readResourceAsString((String)LG_IMAGEM));
            params.addValue("IDARQUIVO", (Object)idArquivo, 2);
        } else {
            query = new StringBuilder(FileUtils.readResourceAsString((String)LG_LEIS));
        }
        return this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(ArquivoDTO.class)).stream().findFirst().orElse(null);
    }
}

