/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository.impl;

import br.com.elotech.almoxarifado.client.ItemEstoqueClient;
import br.com.elotech.almoxarifado.client.ORCUnidadeClient;
import br.com.elotech.core.utils.EloPage;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindExercicioParams;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ConsumoPorCentroCustroDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ItemEstoqueDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.OrgaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.UltimaAtualizacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.ItemEstoqueRepository;
import br.com.elotech.portaltransparencia.web.rest.params.ConsumoPorCentroCustoParams;
import br.com.elotech.portaltransparencia.web.rest.params.ItemEstoqueParams;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class ItemEstoqueOxyRepositoryImpl
implements ItemEstoqueRepository {
    private final ItemEstoqueClient itemEstoqueClient;
    private final ORCUnidadeClient orcUnidadeClient;

    public ItemEstoqueOxyRepositoryImpl(ItemEstoqueClient itemEstoqueClient, ORCUnidadeClient orcUnidadeClient) {
        this.itemEstoqueClient = itemEstoqueClient;
        this.orcUnidadeClient = orcUnidadeClient;
    }

    public Page<ItemEstoqueDTO> findItemEstoque(ItemEstoqueParams params, Pageable pageable) {
        EloPage itemEstoque = this.itemEstoqueClient.findItemEstoque(params.toOxyAdmEntity(), pageable);
        List itensEstoque = itemEstoque.getContent().stream().map(ItemEstoqueDTO::oxyEntityToPortalEntity).collect(Collectors.toList());
        return new PageImpl(itensEstoque, pageable, itemEstoque.getTotalElements());
    }

    public List<OrgaoDTO> findOrgao(FindExercicioParams params) {
        String search = "unidadeSuperiorId==null and (inativo==false or inativo==null)";
        return this.orcUnidadeClient.findAll(search).stream().map(OrgaoDTO::fromOxy).collect(Collectors.toList());
    }

    public List<UltimaAtualizacaoDTO> findUltimaAtualizacao(FindExercicioParams params) {
        return this.itemEstoqueClient.findUltimaAtualizacao(params.toOxyAdmEntity()).stream().map(UltimaAtualizacaoDTO::oxyEntityToPortalEntity).collect(Collectors.toList());
    }

    public Page<ConsumoPorCentroCustroDTO> findItensConsumo(ConsumoPorCentroCustoParams params, Pageable pageable) {
        EloPage itensConsumoPage = this.itemEstoqueClient.findItensConsumo(params.toOxyAdmEntity(), pageable);
        List itensConsumidos = itensConsumoPage.getContent().stream().map(ConsumoPorCentroCustroDTO::oxyEntityToPortalEntity).collect(Collectors.toList());
        return new PageImpl(itensConsumidos, pageable, itensConsumoPage.getTotalElements());
    }

    public BigDecimal findTotalConsumido(ConsumoPorCentroCustoParams params) {
        return this.itemEstoqueClient.findTotalConsumido(params.toOxyAdmEntity());
    }
}

