/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository;

import br.com.caelum.stella.type.Estado;
import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ComprasDiretaFornecedorDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.EntidadeContabilidadeRepository;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import br.com.elotech.portaltransparencia.web.rest.params.ComprasDiretaParams;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class ComprasDiretaRepository {
    private static final String COMPRAS_DIRETA_FORNECEDOR = "db/sql/contab/comprasDireta.sql";
    private final DatasourceWrapper datasourceWrapper;
    private final EntidadeContabilidadeRepository entidadeRepository;

    @Autowired
    public ComprasDiretaRepository(DatasourceWrapper datasourceWrapper, EntidadeContabilidadeRepository entidadeRepository) {
        this.datasourceWrapper = datasourceWrapper;
        this.entidadeRepository = entidadeRepository;
    }

    private Long getCount(String sql, MapSqlParameterSource params) {
        StringBuilder sqlCount = new StringBuilder();
        sqlCount.append("SELECT COUNT(*) AS TOTAL");
        sqlCount.append(" FROM (");
        sqlCount.append(sql);
        sqlCount.append(") X");
        return (Long)this.datasourceWrapper.getJdbcTemplate().queryForObject(sqlCount.toString(), (SqlParameterSource)params, Long.class);
    }

    public Page<ComprasDiretaFornecedorDTO> findFornecedores(Pageable pageable, ComprasDiretaParams params) {
        String sql = FileUtils.readResourceAsString((String)COMPRAS_DIRETA_FORNECEDOR);
        sql = sql.replace("$[FILTRO]", params.montaFiltro());
        sql = sql.replace("$[TIPO_COMPRAS_DIRETAS]", this.filtroComprasDiretasPorEstado(params.getEntidade()));
        MapSqlParameterSource jdbcParameters = params.toJdbcParameter();
        String queryPaginado = SqlUtils.aplicaPaginacao((Pageable)pageable, (String)sql, (String)this.datasourceWrapper.getPlatform());
        List list = this.datasourceWrapper.getJdbcTemplate().query(queryPaginado, (SqlParameterSource)jdbcParameters, (RowMapper)new ElotechBeanPropertyRowMapper(ComprasDiretaFornecedorDTO.class));
        return new PageImpl(list, pageable, this.getCount(sql, jdbcParameters).longValue());
    }

    private String filtroComprasDiretasPorEstado(Long entidade) {
        String uf = this.entidadeRepository.getUf(entidade);
        if (Estado.RO.name().equalsIgnoreCase(uf)) {
            return "\n E.TIPOLICITACAO IN ('01', '06', '09') ";
        }
        StringBuilder comprasDiretas = new StringBuilder("\n E.TIPOLICITACAO = '00' ");
        comprasDiretas.append("\n AND SUBSTR(E.PROGRAMATICA,23,2) IN ('30','32','33','35','36','37','39','51','52','61','62')");
        return comprasDiretas.toString();
    }

    public ComprasDiretaFornecedorDTO findFornecedoresTotais(ComprasDiretaParams params) {
        String sql = FileUtils.readResourceAsString((String)COMPRAS_DIRETA_FORNECEDOR);
        String filtro = params.montaFiltro();
        sql = sql.replace("$[TIPO_COMPRAS_DIRETAS]", this.filtroComprasDiretasPorEstado(params.getEntidade()));
        sql = sql.replace("$[FILTRO]", filtro);
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT SUM(X.EMPENHADO) AS EMPENHADO,");
        sb.append("       SUM(X.ANULADO) AS ANULADO,");
        sb.append("       SUM(X.LIQUIDADO) AS LIQUIDADO,");
        sb.append("       SUM(X.RETIDO) AS RETIDO,");
        sb.append("       SUM(X.PAGO) AS PAGO,");
        sb.append("       SUM(X.APAGAR) AS APAGAR");
        sb.append(" FROM (       ");
        sb.append(sql);
        sb.append(" ) X");
        List list = this.datasourceWrapper.getJdbcTemplate().query(sb.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(ComprasDiretaFornecedorDTO.class));
        return (ComprasDiretaFornecedorDTO)list.get(0);
    }
}

