/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.domain.dto;

import br.com.elotech.contabilidade.client.dto.EmpenhoItemDTO;
import br.com.elotech.core.utils.NumberUtils;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoItensPercDTO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public class EmpenhoItensDTO {
    private Long entidade;
    private Long empenho;
    private Long exercicio;
    private String unidadeOrcamentaria;
    private Long sequencia;
    private String especificacao;
    private BigDecimal quantidade;
    private String unidade;
    private BigDecimal valorUnitario;
    private BigDecimal valorTotal;
    private Long anoNad;
    private Long noNad;
    private Long ordemNadItemPerc;
    private List<EmpenhoItensPercDTO> itensPerc;

    public EmpenhoItensDTO(EmpenhoItemDTO itemEmpenhoOxy) {
        this.sequencia = itemEmpenhoOxy.getSequencia();
        this.especificacao = itemEmpenhoOxy.getItem().getDescricao();
        this.quantidade = itemEmpenhoOxy.getQuantidade();
        this.valorTotal = itemEmpenhoOxy.getSubTotal();
        this.valorUnitario = itemEmpenhoOxy.getValorUnitario();
        this.itensPerc = new ArrayList();
        Optional.ofNullable(itemEmpenhoOxy.getItem().getUnidadeMedida()).ifPresent(um -> {
            this.unidade = um.getDescricao();
        });
    }

    public Long getEntidade() {
        return this.entidade;
    }

    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    public Long getEmpenho() {
        return this.empenho;
    }

    public void setEmpenho(Long empenho) {
        this.empenho = empenho;
    }

    public Long getExercicio() {
        return this.exercicio;
    }

    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    public String getUnidadeOrcamentaria() {
        return this.unidadeOrcamentaria;
    }

    public void setUnidadeOrcamentaria(String unidadeOrcamentaria) {
        this.unidadeOrcamentaria = unidadeOrcamentaria;
    }

    public Long getSequencia() {
        return this.sequencia;
    }

    public void setSequencia(Long sequencia) {
        this.sequencia = sequencia;
    }

    public String getEspecificacao() {
        return this.especificacao;
    }

    public void setEspecificacao(String especificacao) {
        this.especificacao = especificacao;
    }

    public BigDecimal getQuantidade() {
        return NumberUtils.formatBigDecimal((BigDecimal)this.quantidade, (Integer)4);
    }

    public void setQuantidade(BigDecimal quantidade) {
        this.quantidade = quantidade;
    }

    public String getUnidade() {
        return this.unidade;
    }

    public void setUnidade(String unidade) {
        this.unidade = unidade;
    }

    public BigDecimal getValorUnitario() {
        return NumberUtils.formatBigDecimal((BigDecimal)this.valorUnitario, (Integer)4);
    }

    public void setValorUnitario(BigDecimal valorUnitario) {
        this.valorUnitario = valorUnitario;
    }

    public BigDecimal getValorTotal() {
        return NumberUtils.formatBigDecimalRound((BigDecimal)this.valorTotal);
    }

    public void setValorTotal(BigDecimal valorTotal) {
        this.valorTotal = valorTotal;
    }

    public Long getAnoNad() {
        return this.anoNad;
    }

    public void setAnoNad(Long anoNad) {
        this.anoNad = anoNad;
    }

    public Long getNoNad() {
        return this.noNad;
    }

    public void setNoNad(Long noNad) {
        this.noNad = noNad;
    }

    public Long getOrdemNadItemPerc() {
        return this.ordemNadItemPerc;
    }

    public void setOrdemNadItemPerc(Long ordemNadItemPerc) {
        this.ordemNadItemPerc = ordemNadItemPerc;
    }

    public List<EmpenhoItensPercDTO> getItensPerc() {
        return this.itensPerc;
    }

    public void setItensPerc(List<EmpenhoItensPercDTO> itensPerc) {
        this.itensPerc = itensPerc;
    }

    @Generated
    public EmpenhoItensDTO() {
    }
}

