/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.config;

import br.com.elotech.core.config.DBConfigProperties;
import br.com.elotech.portaltransparencia.config.CustomJdbcTemplate;
import br.com.elotech.portaltransparencia.config.CustomNamedParameterJdbcTemplate;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Component;

@Component
public class DatasourceWrapperImpl
implements DatasourceWrapper {
    private final DataSource dataSource;
    private final DBConfigProperties dbConfigProperties;
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    private final JdbcTemplate jdbcTemplate;
    private static final String REGEX_SCHEMA_AISE = "${db.aise.schema}";
    private static final String REGEX_SCHEMA_CONTABILIDADE = "${db.contabilidade.schema}";
    private static final String REGEX_SCHEMA_COMPRAS = "${db.compras.schema}";
    private static final String REGEX_SCHEMA_PROTOCOLO = "${db.protocolo.schema}";
    private static final String REGEX_SCHEMA_SMT = "${db.smt.schema}";

    public DatasourceWrapperImpl(DataSource dataSource, DBConfigProperties dbConfigProperties) {
        this.dataSource = dataSource;
        this.dbConfigProperties = dbConfigProperties;
        this.namedParameterJdbcTemplate = new CustomNamedParameterJdbcTemplate(dataSource, Map.ofEntries(Map.entry(REGEX_SCHEMA_AISE, dbConfigProperties.getAise().getSchema()), Map.entry(REGEX_SCHEMA_CONTABILIDADE, dbConfigProperties.getContabilidade().getSchema()), Map.entry(REGEX_SCHEMA_COMPRAS, dbConfigProperties.getCompras().getSchema()), Map.entry(REGEX_SCHEMA_PROTOCOLO, dbConfigProperties.getProtocolo().getSchema()), Map.entry(REGEX_SCHEMA_SMT, dbConfigProperties.getSmt().getSchema())));
        this.jdbcTemplate = new CustomJdbcTemplate(dataSource, Map.ofEntries(Map.entry(REGEX_SCHEMA_AISE, dbConfigProperties.getAise().getSchema()), Map.entry(REGEX_SCHEMA_CONTABILIDADE, dbConfigProperties.getContabilidade().getSchema()), Map.entry(REGEX_SCHEMA_COMPRAS, dbConfigProperties.getCompras().getSchema()), Map.entry(REGEX_SCHEMA_PROTOCOLO, dbConfigProperties.getProtocolo().getSchema()), Map.entry(REGEX_SCHEMA_SMT, dbConfigProperties.getSmt().getSchema())));
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public String getPlatform() {
        return this.dbConfigProperties.getAise().getPlatform();
    }

    public NamedParameterJdbcTemplate getJdbcTemplate() {
        return this.namedParameterJdbcTemplate;
    }

    public JdbcTemplate getSimpleJdbcTemplate() {
        return this.jdbcTemplate;
    }
}

