/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.comprasportal.service.impl;

import br.com.elotech.adm.compras.client.HomologacaoClient;
import br.com.elotech.portaltransparencia.arquivoportal.repository.EloArquivoRepository;
import br.com.elotech.portaltransparencia.arquivoportal.service.ArquivoService;
import br.com.elotech.portaltransparencia.comprasportal.domain.HomologacaoArquivo;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.HomologacaoLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.repository.HomologacaoArquivoRepository;
import br.com.elotech.portaltransparencia.comprasportal.repository.HomologacaoRepository;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindHomologacaoParams;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindLicitacaoParams;
import br.com.elotech.portaltransparencia.comprasportal.service.HomologacaoService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class HomologacaoServiceImpl
implements HomologacaoService {
    private final HomologacaoRepository homologacaoRepository;
    private final HomologacaoArquivoRepository homologacaoArquivoRepository;
    private final EloArquivoRepository eloArquivoRepository;
    private final ArquivoService arquivoService;
    private final HomologacaoClient homologacaoClient;
    private final Boolean isIntegradoOxy;

    @Autowired
    public HomologacaoServiceImpl(@Value(value="${elotech.integradooxy:false}") Boolean isIntegradoOxy, HomologacaoRepository homologacaoRepository, HomologacaoArquivoRepository homologacaoArquivoRepository, EloArquivoRepository eloArquivoRepository, ArquivoService arquivoService, HomologacaoClient homologacaoClient) {
        this.homologacaoRepository = homologacaoRepository;
        this.homologacaoArquivoRepository = homologacaoArquivoRepository;
        this.eloArquivoRepository = eloArquivoRepository;
        this.arquivoService = arquivoService;
        this.homologacaoClient = homologacaoClient;
        this.isIntegradoOxy = isIntegradoOxy;
    }

    public List<HomologacaoLicitacaoDTO> findHomologacoes(FindLicitacaoParams params) {
        return this.homologacaoRepository.findHomologacoes(params, this.arquivoService.getNomeSchemaEloArquivo());
    }

    public HomologacaoLicitacaoDTO findHomologacao(FindHomologacaoParams params) {
        return this.homologacaoRepository.findHomologacao(params);
    }

    public List<HomologacaoArquivo> findArquivos(FindHomologacaoParams params) {
        List homologacaoArquivos;
        if (!params.getTipoLicitacao().isPresent() && !params.getLicitacao().isPresent()) {
            return new ArrayList<HomologacaoArquivo>();
        }
        if (this.isIntegradoOxy.booleanValue()) {
            homologacaoArquivos = this.homologacaoClient.findHomologacaoArquivos(params.toComprasOxyParams()).stream().map(HomologacaoArquivo::fromHomologacaoArquivoOxy).collect(Collectors.toList());
        } else {
            homologacaoArquivos = this.homologacaoArquivoRepository.findByEntidadeAndExercicioAndExercicioLicitacaoAndTipoLicitacaoAndLicitacaoAndPessoa((Long)params.getEntidade().get(), (Long)params.getExercicio().get(), (Long)params.getExercicioLicitacao().get(), (Long)params.getTipoLicitacao().get(), (Long)params.getLicitacao().get(), (Long)params.getPessoa().get());
            homologacaoArquivos.stream().filter(HomologacaoArquivo::possuiEloArquivo).map(HomologacaoArquivo::getArquivoCompras).forEach(a -> a.setTamanhoArquivo(this.eloArquivoRepository.getTamanhoArquivo(a.getArquivo().getId())));
        }
        return homologacaoArquivos;
    }
}

