/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.comprasportal.resource;

import br.com.elotech.portaltransparencia.comprasportal.domain.AdjudicacaoArquivo;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.AdjudicacaoLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindAdjudicacaoParams;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindLicitacaoParams;
import br.com.elotech.portaltransparencia.comprasportal.service.AdjudicacaoService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/adjudicacoes"})
public class AdjudicacaoResource {
    private final AdjudicacaoService adjudicacaoService;

    @Autowired
    public AdjudicacaoResource(AdjudicacaoService adjudicacaoService) {
        this.adjudicacaoService = adjudicacaoService;
    }

    @GetMapping(params={"entidade", "exercicio", "tipoLicitacao", "licitacao"})
    public ResponseEntity<List<AdjudicacaoLicitacaoDTO>> findAdjudicacoes(FindLicitacaoParams params) {
        return ResponseEntity.ok((Object)this.adjudicacaoService.findAdjudicacoes(params));
    }

    @GetMapping(value={"/detalhes"}, params={"entidade", "exercicio", "exercicioLicitacao", "tipoLicitacao", "licitacao", "pessoa"})
    public ResponseEntity<AdjudicacaoLicitacaoDTO> findAdjudicacao(FindAdjudicacaoParams params) {
        return ResponseEntity.ok((Object)this.adjudicacaoService.findAdjudicacao(params));
    }

    @GetMapping(value={"/arquivos"}, params={"entidade", "exercicio", "exercicioLicitacao", "tipoLicitacao", "licitacao", "pessoa"})
    public ResponseEntity<List<AdjudicacaoArquivo>> findArquivos(FindAdjudicacaoParams params) {
        List listMidia = this.adjudicacaoService.findArquivos(params);
        return ResponseEntity.ok((Object)listMidia);
    }
}

