/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.comprasportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.PcaDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.PcaItemDTO;
import br.com.elotech.portaltransparencia.comprasportal.repository.PcaRepository;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindPcaParams;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class PcaRepositoryImpl
implements PcaRepository {
    private static final String PCA = "db/sql/compras/pca.sql";
    private static final String PCA_ITENS = "db/sql/compras/pcaitens.sql";
    private final DatasourceWrapper datasourceWrapper;

    @Autowired
    public PcaRepositoryImpl(DatasourceWrapper datasourceWrapper) {
        this.datasourceWrapper = datasourceWrapper;
    }

    public Page<PcaDTO> findAll(FindPcaParams params, Pageable pageable) {
        Object sql = FileUtils.readResourceAsString((String)PCA);
        sql = (String)sql + params.montaWhere();
        Long qtdPca = this.getQuantidadePca((String)sql, params.toJdbcParameter());
        sql = SqlUtils.aplicaOrdenacao((Pageable)pageable, (String)sql, (String)"ORDER BY P.EXERCICIO DESC, P.PLANOCONTRATACAO DESC");
        sql = SqlUtils.aplicaPaginacao((Pageable)pageable, (String)sql, (String)this.datasourceWrapper.getPlatform());
        List pca = this.datasourceWrapper.getJdbcTemplate().query((String)sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(PcaDTO.class));
        return new PageImpl(pca, pageable, qtdPca.longValue());
    }

    public PcaDTO findPca(FindPcaParams params) {
        Object sql = FileUtils.readResourceAsString((String)PCA);
        sql = (String)sql + params.montaWhere();
        try {
            PcaDTO pca = (PcaDTO)this.datasourceWrapper.getJdbcTemplate().queryForObject((String)sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(PcaDTO.class));
            Object sqlItens = FileUtils.readResourceAsString((String)PCA_ITENS);
            sqlItens = (String)sqlItens + params.montaWhere();
            MapSqlParameterSource paramsItens = new MapSqlParameterSource();
            paramsItens.addValue("entidade", (Object)pca.getEntidade(), 2);
            paramsItens.addValue("exercicio", (Object)pca.getExercicio(), 2);
            paramsItens.addValue("planoContratacao", (Object)pca.getPlanoContratacao(), 2);
            pca.setItens(this.datasourceWrapper.getJdbcTemplate().query((String)sqlItens, (SqlParameterSource)paramsItens, (RowMapper)new ElotechBeanPropertyRowMapper(PcaItemDTO.class)));
            return pca;
        }
        catch (EmptyResultDataAccessException e) {
            return new PcaDTO();
        }
    }

    public Page<PcaItemDTO> findPcaItens(FindPcaParams params, Pageable pageable) {
        Object sql = FileUtils.readResourceAsString((String)PCA_ITENS);
        sql = (String)sql + params.montaWhere();
        Long qtdPca = this.getQuantidadePca((String)sql, params.toJdbcParameter());
        sql = SqlUtils.aplicaOrdenacao((Pageable)pageable, (String)sql, (String)"ORDER BY I.PLANOCONTRATACAO, I.NUMEROITEM");
        List pca = this.datasourceWrapper.getJdbcTemplate().query((String)sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(PcaItemDTO.class));
        return new PageImpl(pca, pageable, qtdPca.longValue());
    }

    private Long getQuantidadePca(String query, MapSqlParameterSource params) {
        String queryCount = " SELECT COUNT(*) FROM ( " + query + " ) COUNT ";
        return (Long)this.datasourceWrapper.getJdbcTemplate().queryForObject(queryCount, (SqlParameterSource)params, Long.class);
    }
}

