/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.comprasportal.domain.dto;

import br.com.elotech.core.json.EloFilterable;
import br.com.elotech.core.utils.NumberUtils;
import br.com.elotech.oxy.adm.compras.client.portal.LicitacaoPortalDTO;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;

public class LicitacaoDTO
implements EloFilterable {
    private UUID idOxy;
    private Long entidade;
    private String nomeEntidade;
    private Long exercicio;
    private Long tipoLicitacao;
    private Long licitacao;
    private String displayLicitacao;
    private String descricao;
    private Long numeroLicitacao;
    private LocalDate dataPublicacao;
    private LocalDate dataAbertura;
    private String horarioAbertura;
    private String visualizaPortal;
    private String tipoCancelamento;
    private String natureza;
    private String objeto;
    private Long protocolo;
    private Long anoProtocolo;
    private String displayProtocolo;
    private BigDecimal valorMaximo;
    private BigDecimal totalVencido;
    private String hasRecurso;
    private String observacao;
    private String isCovid;
    private String formaApuracao;
    private String tipoParticipacao;
    private Long numeroInfOriginal;
    private Long anoInfOriginal;
    private LocalDate dataInfOriginal;
    private Long modalidadeInfOriginal;
    private String entidadeInfOriginal;
    private LocalDate dataPubInfOriginal;
    private String obsInfOriginal;
    private String aplicaLei14133;
    private Long tcemtTipoProcLicit;
    private String idTipoCompra;
    private String descTipoCompra;
    private LocalDate dataInicialProposta;
    private String horaInicialProposta;
    private LocalDate dataFinalProposta;
    private String horaFinalProposta;
    private String displayProcessoAdm;
    private UUID processoAdmId;
    private String orcamentoSigiloso;
    private String ataDeAdesao;
    private String fundamentoLegal;
    private String numeroLei;
    private String anoLei;
    private String artigoLei;
    private String incisoLei;

    public BigDecimal getValorMaximo() {
        return NumberUtils.formatBigDecimal((BigDecimal)this.valorMaximo);
    }

    public BigDecimal getTotalVencido() {
        return NumberUtils.formatBigDecimal((BigDecimal)this.totalVencido);
    }

    public Boolean getMostraLeiEdital() {
        return this.visualizaPortal != null && !this.visualizaPortal.contains("E");
    }

    public Boolean getMostraLeiAta() {
        return this.visualizaPortal != null && !this.visualizaPortal.contains("A");
    }

    public Boolean getMostraLeiContrato() {
        return this.visualizaPortal != null && !this.visualizaPortal.contains("C");
    }

    public static LicitacaoDTO fromLicitacaoOxy(LicitacaoPortalDTO dto) {
        LicitacaoDTO licitacao = new LicitacaoDTO();
        licitacao.setIdOxy(dto.getId());
        licitacao.setEntidade(dto.getEntidade());
        licitacao.setNomeEntidade(dto.getNomeEntidade());
        licitacao.setExercicio(dto.getExercicio());
        licitacao.setTipoLicitacao(dto.getTipoLicitacao());
        licitacao.setLicitacao(dto.getLicitacao());
        licitacao.setDisplayLicitacao(dto.getDisplayLicitacao());
        licitacao.setDescricao(dto.getDescricao());
        licitacao.setNumeroLicitacao(dto.getNumeroLicitacao());
        licitacao.setDataPublicacao(dto.getDataPublicacao());
        licitacao.setDataAbertura(dto.getDataAbertura());
        licitacao.setHorarioAbertura(dto.getHorarioAbertura());
        licitacao.setVisualizaPortal(dto.getVisualizaPortal());
        licitacao.setTipoCancelamento(dto.getTipoCancelamento());
        licitacao.setNatureza(dto.getNatureza());
        licitacao.setObjeto(dto.getObjeto());
        licitacao.setProtocolo(dto.getProtocolo());
        licitacao.setAnoProtocolo(dto.getAnoProtocolo());
        licitacao.setDisplayProtocolo(dto.getDisplayProtocolo());
        licitacao.setValorMaximo(dto.getValorMaximo());
        licitacao.setTotalVencido(dto.getTotalVencido());
        licitacao.setHasRecurso(dto.getHasRecurso());
        licitacao.setObservacao(dto.getObservacao());
        licitacao.setIsCovid(dto.getIsCovid());
        licitacao.setFormaApuracao(dto.getFormaApuracao());
        licitacao.setTipoParticipacao(dto.getTipoParticipacao());
        licitacao.setAplicaLei14133(dto.getAplicaLei14133());
        licitacao.setIdTipoCompra(null);
        licitacao.setDescTipoCompra(null);
        licitacao.setDataInicialProposta(null);
        licitacao.setDataFinalProposta(null);
        licitacao.setHoraFinalProposta(null);
        licitacao.setHoraInicialProposta(null);
        licitacao.setDisplayProcessoAdm(dto.getDisplayProtocolo());
        licitacao.setProcessoAdmId(dto.getProcessoAdmId());
        licitacao.setOrcamentoSigiloso(dto.getOrcamentoSigiloso());
        licitacao.setAtaDeAdesao(dto.getAtaAdesao());
        licitacao.setFundamentoLegal(dto.getFundamentoLegal());
        licitacao.setNumeroLei(dto.getNumeroLei());
        licitacao.setAnoLei(dto.getAnoLei());
        licitacao.setArtigoLei(dto.getArtigoLei());
        licitacao.setIncisoLei(dto.getIncisoLei());
        if (Objects.isNull(dto.getTotalVencido())) {
            licitacao.setTotalVencido(BigDecimal.ZERO);
        }
        return licitacao;
    }

    @Generated
    public String toString() {
        return "LicitacaoDTO(idOxy=" + String.valueOf(this.getIdOxy()) + ", entidade=" + this.getEntidade() + ", nomeEntidade=" + this.getNomeEntidade() + ", exercicio=" + this.getExercicio() + ", tipoLicitacao=" + this.getTipoLicitacao() + ", licitacao=" + this.getLicitacao() + ", displayLicitacao=" + this.getDisplayLicitacao() + ", descricao=" + this.getDescricao() + ", numeroLicitacao=" + this.getNumeroLicitacao() + ", dataPublicacao=" + String.valueOf(this.getDataPublicacao()) + ", dataAbertura=" + String.valueOf(this.getDataAbertura()) + ", horarioAbertura=" + this.getHorarioAbertura() + ", visualizaPortal=" + this.getVisualizaPortal() + ", tipoCancelamento=" + this.getTipoCancelamento() + ", natureza=" + this.getNatureza() + ", objeto=" + this.getObjeto() + ", protocolo=" + this.getProtocolo() + ", anoProtocolo=" + this.getAnoProtocolo() + ", displayProtocolo=" + this.getDisplayProtocolo() + ", valorMaximo=" + String.valueOf(this.getValorMaximo()) + ", totalVencido=" + String.valueOf(this.getTotalVencido()) + ", hasRecurso=" + this.getHasRecurso() + ", observacao=" + this.getObservacao() + ", isCovid=" + this.getIsCovid() + ", formaApuracao=" + this.getFormaApuracao() + ", tipoParticipacao=" + this.getTipoParticipacao() + ", numeroInfOriginal=" + this.getNumeroInfOriginal() + ", anoInfOriginal=" + this.getAnoInfOriginal() + ", dataInfOriginal=" + String.valueOf(this.getDataInfOriginal()) + ", modalidadeInfOriginal=" + this.getModalidadeInfOriginal() + ", entidadeInfOriginal=" + this.getEntidadeInfOriginal() + ", dataPubInfOriginal=" + String.valueOf(this.getDataPubInfOriginal()) + ", obsInfOriginal=" + this.getObsInfOriginal() + ", aplicaLei14133=" + this.getAplicaLei14133() + ", tcemtTipoProcLicit=" + this.getTcemtTipoProcLicit() + ", idTipoCompra=" + this.getIdTipoCompra() + ", descTipoCompra=" + this.getDescTipoCompra() + ", dataInicialProposta=" + String.valueOf(this.getDataInicialProposta()) + ", horaInicialProposta=" + this.getHoraInicialProposta() + ", dataFinalProposta=" + String.valueOf(this.getDataFinalProposta()) + ", horaFinalProposta=" + this.getHoraFinalProposta() + ", displayProcessoAdm=" + this.getDisplayProcessoAdm() + ", processoAdmId=" + String.valueOf(this.getProcessoAdmId()) + ", orcamentoSigiloso=" + this.getOrcamentoSigiloso() + ", ataDeAdesao=" + this.getAtaDeAdesao() + ", fundamentoLegal=" + this.getFundamentoLegal() + ", numeroLei=" + this.getNumeroLei() + ", anoLei=" + this.getAnoLei() + ", artigoLei=" + this.getArtigoLei() + ", incisoLei=" + this.getIncisoLei() + ")";
    }

    @Generated
    public LicitacaoDTO() {
    }

    @Generated
    public UUID getIdOxy() {
        return this.idOxy;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public String getNomeEntidade() {
        return this.nomeEntidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getTipoLicitacao() {
        return this.tipoLicitacao;
    }

    @Generated
    public Long getLicitacao() {
        return this.licitacao;
    }

    @Generated
    public String getDisplayLicitacao() {
        return this.displayLicitacao;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public Long getNumeroLicitacao() {
        return this.numeroLicitacao;
    }

    @Generated
    public LocalDate getDataPublicacao() {
        return this.dataPublicacao;
    }

    @Generated
    public LocalDate getDataAbertura() {
        return this.dataAbertura;
    }

    @Generated
    public String getHorarioAbertura() {
        return this.horarioAbertura;
    }

    @Generated
    public String getVisualizaPortal() {
        return this.visualizaPortal;
    }

    @Generated
    public String getTipoCancelamento() {
        return this.tipoCancelamento;
    }

    @Generated
    public String getNatureza() {
        return this.natureza;
    }

    @Generated
    public String getObjeto() {
        return this.objeto;
    }

    @Generated
    public Long getProtocolo() {
        return this.protocolo;
    }

    @Generated
    public Long getAnoProtocolo() {
        return this.anoProtocolo;
    }

    @Generated
    public String getDisplayProtocolo() {
        return this.displayProtocolo;
    }

    @Generated
    public String getHasRecurso() {
        return this.hasRecurso;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public String getIsCovid() {
        return this.isCovid;
    }

    @Generated
    public String getFormaApuracao() {
        return this.formaApuracao;
    }

    @Generated
    public String getTipoParticipacao() {
        return this.tipoParticipacao;
    }

    @Generated
    public Long getNumeroInfOriginal() {
        return this.numeroInfOriginal;
    }

    @Generated
    public Long getAnoInfOriginal() {
        return this.anoInfOriginal;
    }

    @Generated
    public LocalDate getDataInfOriginal() {
        return this.dataInfOriginal;
    }

    @Generated
    public Long getModalidadeInfOriginal() {
        return this.modalidadeInfOriginal;
    }

    @Generated
    public String getEntidadeInfOriginal() {
        return this.entidadeInfOriginal;
    }

    @Generated
    public LocalDate getDataPubInfOriginal() {
        return this.dataPubInfOriginal;
    }

    @Generated
    public String getObsInfOriginal() {
        return this.obsInfOriginal;
    }

    @Generated
    public String getAplicaLei14133() {
        return this.aplicaLei14133;
    }

    @Generated
    public Long getTcemtTipoProcLicit() {
        return this.tcemtTipoProcLicit;
    }

    @Generated
    public String getIdTipoCompra() {
        return this.idTipoCompra;
    }

    @Generated
    public String getDescTipoCompra() {
        return this.descTipoCompra;
    }

    @Generated
    public LocalDate getDataInicialProposta() {
        return this.dataInicialProposta;
    }

    @Generated
    public String getHoraInicialProposta() {
        return this.horaInicialProposta;
    }

    @Generated
    public LocalDate getDataFinalProposta() {
        return this.dataFinalProposta;
    }

    @Generated
    public String getHoraFinalProposta() {
        return this.horaFinalProposta;
    }

    @Generated
    public String getDisplayProcessoAdm() {
        return this.displayProcessoAdm;
    }

    @Generated
    public UUID getProcessoAdmId() {
        return this.processoAdmId;
    }

    @Generated
    public String getOrcamentoSigiloso() {
        return this.orcamentoSigiloso;
    }

    @Generated
    public String getAtaDeAdesao() {
        return this.ataDeAdesao;
    }

    @Generated
    public String getFundamentoLegal() {
        return this.fundamentoLegal;
    }

    @Generated
    public String getNumeroLei() {
        return this.numeroLei;
    }

    @Generated
    public String getAnoLei() {
        return this.anoLei;
    }

    @Generated
    public String getArtigoLei() {
        return this.artigoLei;
    }

    @Generated
    public String getIncisoLei() {
        return this.incisoLei;
    }

    @Generated
    public void setIdOxy(UUID idOxy) {
        this.idOxy = idOxy;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setNomeEntidade(String nomeEntidade) {
        this.nomeEntidade = nomeEntidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setTipoLicitacao(Long tipoLicitacao) {
        this.tipoLicitacao = tipoLicitacao;
    }

    @Generated
    public void setLicitacao(Long licitacao) {
        this.licitacao = licitacao;
    }

    @Generated
    public void setDisplayLicitacao(String displayLicitacao) {
        this.displayLicitacao = displayLicitacao;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setNumeroLicitacao(Long numeroLicitacao) {
        this.numeroLicitacao = numeroLicitacao;
    }

    @Generated
    public void setDataPublicacao(LocalDate dataPublicacao) {
        this.dataPublicacao = dataPublicacao;
    }

    @Generated
    public void setDataAbertura(LocalDate dataAbertura) {
        this.dataAbertura = dataAbertura;
    }

    @Generated
    public void setHorarioAbertura(String horarioAbertura) {
        this.horarioAbertura = horarioAbertura;
    }

    @Generated
    public void setVisualizaPortal(String visualizaPortal) {
        this.visualizaPortal = visualizaPortal;
    }

    @Generated
    public void setTipoCancelamento(String tipoCancelamento) {
        this.tipoCancelamento = tipoCancelamento;
    }

    @Generated
    public void setNatureza(String natureza) {
        this.natureza = natureza;
    }

    @Generated
    public void setObjeto(String objeto) {
        this.objeto = objeto;
    }

    @Generated
    public void setProtocolo(Long protocolo) {
        this.protocolo = protocolo;
    }

    @Generated
    public void setAnoProtocolo(Long anoProtocolo) {
        this.anoProtocolo = anoProtocolo;
    }

    @Generated
    public void setDisplayProtocolo(String displayProtocolo) {
        this.displayProtocolo = displayProtocolo;
    }

    @Generated
    public void setValorMaximo(BigDecimal valorMaximo) {
        this.valorMaximo = valorMaximo;
    }

    @Generated
    public void setTotalVencido(BigDecimal totalVencido) {
        this.totalVencido = totalVencido;
    }

    @Generated
    public void setHasRecurso(String hasRecurso) {
        this.hasRecurso = hasRecurso;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setIsCovid(String isCovid) {
        this.isCovid = isCovid;
    }

    @Generated
    public void setFormaApuracao(String formaApuracao) {
        this.formaApuracao = formaApuracao;
    }

    @Generated
    public void setTipoParticipacao(String tipoParticipacao) {
        this.tipoParticipacao = tipoParticipacao;
    }

    @Generated
    public void setNumeroInfOriginal(Long numeroInfOriginal) {
        this.numeroInfOriginal = numeroInfOriginal;
    }

    @Generated
    public void setAnoInfOriginal(Long anoInfOriginal) {
        this.anoInfOriginal = anoInfOriginal;
    }

    @Generated
    public void setDataInfOriginal(LocalDate dataInfOriginal) {
        this.dataInfOriginal = dataInfOriginal;
    }

    @Generated
    public void setModalidadeInfOriginal(Long modalidadeInfOriginal) {
        this.modalidadeInfOriginal = modalidadeInfOriginal;
    }

    @Generated
    public void setEntidadeInfOriginal(String entidadeInfOriginal) {
        this.entidadeInfOriginal = entidadeInfOriginal;
    }

    @Generated
    public void setDataPubInfOriginal(LocalDate dataPubInfOriginal) {
        this.dataPubInfOriginal = dataPubInfOriginal;
    }

    @Generated
    public void setObsInfOriginal(String obsInfOriginal) {
        this.obsInfOriginal = obsInfOriginal;
    }

    @Generated
    public void setAplicaLei14133(String aplicaLei14133) {
        this.aplicaLei14133 = aplicaLei14133;
    }

    @Generated
    public void setTcemtTipoProcLicit(Long tcemtTipoProcLicit) {
        this.tcemtTipoProcLicit = tcemtTipoProcLicit;
    }

    @Generated
    public void setIdTipoCompra(String idTipoCompra) {
        this.idTipoCompra = idTipoCompra;
    }

    @Generated
    public void setDescTipoCompra(String descTipoCompra) {
        this.descTipoCompra = descTipoCompra;
    }

    @Generated
    public void setDataInicialProposta(LocalDate dataInicialProposta) {
        this.dataInicialProposta = dataInicialProposta;
    }

    @Generated
    public void setHoraInicialProposta(String horaInicialProposta) {
        this.horaInicialProposta = horaInicialProposta;
    }

    @Generated
    public void setDataFinalProposta(LocalDate dataFinalProposta) {
        this.dataFinalProposta = dataFinalProposta;
    }

    @Generated
    public void setHoraFinalProposta(String horaFinalProposta) {
        this.horaFinalProposta = horaFinalProposta;
    }

    @Generated
    public void setDisplayProcessoAdm(String displayProcessoAdm) {
        this.displayProcessoAdm = displayProcessoAdm;
    }

    @Generated
    public void setProcessoAdmId(UUID processoAdmId) {
        this.processoAdmId = processoAdmId;
    }

    @Generated
    public void setOrcamentoSigiloso(String orcamentoSigiloso) {
        this.orcamentoSigiloso = orcamentoSigiloso;
    }

    @Generated
    public void setAtaDeAdesao(String ataDeAdesao) {
        this.ataDeAdesao = ataDeAdesao;
    }

    @Generated
    public void setFundamentoLegal(String fundamentoLegal) {
        this.fundamentoLegal = fundamentoLegal;
    }

    @Generated
    public void setNumeroLei(String numeroLei) {
        this.numeroLei = numeroLei;
    }

    @Generated
    public void setAnoLei(String anoLei) {
        this.anoLei = anoLei;
    }

    @Generated
    public void setArtigoLei(String artigoLei) {
        this.artigoLei = artigoLei;
    }

    @Generated
    public void setIncisoLei(String incisoLei) {
        this.incisoLei = incisoLei;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LicitacaoDTO)) {
            return false;
        }
        LicitacaoDTO other = (LicitacaoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$tipoLicitacao = this.getTipoLicitacao();
        Long other$tipoLicitacao = other.getTipoLicitacao();
        if (this$tipoLicitacao == null ? other$tipoLicitacao != null : !((Object)this$tipoLicitacao).equals(other$tipoLicitacao)) {
            return false;
        }
        Long this$licitacao = this.getLicitacao();
        Long other$licitacao = other.getLicitacao();
        if (this$licitacao == null ? other$licitacao != null : !((Object)this$licitacao).equals(other$licitacao)) {
            return false;
        }
        Long this$numeroLicitacao = this.getNumeroLicitacao();
        Long other$numeroLicitacao = other.getNumeroLicitacao();
        if (this$numeroLicitacao == null ? other$numeroLicitacao != null : !((Object)this$numeroLicitacao).equals(other$numeroLicitacao)) {
            return false;
        }
        Long this$protocolo = this.getProtocolo();
        Long other$protocolo = other.getProtocolo();
        if (this$protocolo == null ? other$protocolo != null : !((Object)this$protocolo).equals(other$protocolo)) {
            return false;
        }
        Long this$anoProtocolo = this.getAnoProtocolo();
        Long other$anoProtocolo = other.getAnoProtocolo();
        if (this$anoProtocolo == null ? other$anoProtocolo != null : !((Object)this$anoProtocolo).equals(other$anoProtocolo)) {
            return false;
        }
        Long this$numeroInfOriginal = this.getNumeroInfOriginal();
        Long other$numeroInfOriginal = other.getNumeroInfOriginal();
        if (this$numeroInfOriginal == null ? other$numeroInfOriginal != null : !((Object)this$numeroInfOriginal).equals(other$numeroInfOriginal)) {
            return false;
        }
        Long this$anoInfOriginal = this.getAnoInfOriginal();
        Long other$anoInfOriginal = other.getAnoInfOriginal();
        if (this$anoInfOriginal == null ? other$anoInfOriginal != null : !((Object)this$anoInfOriginal).equals(other$anoInfOriginal)) {
            return false;
        }
        Long this$modalidadeInfOriginal = this.getModalidadeInfOriginal();
        Long other$modalidadeInfOriginal = other.getModalidadeInfOriginal();
        if (this$modalidadeInfOriginal == null ? other$modalidadeInfOriginal != null : !((Object)this$modalidadeInfOriginal).equals(other$modalidadeInfOriginal)) {
            return false;
        }
        Long this$tcemtTipoProcLicit = this.getTcemtTipoProcLicit();
        Long other$tcemtTipoProcLicit = other.getTcemtTipoProcLicit();
        if (this$tcemtTipoProcLicit == null ? other$tcemtTipoProcLicit != null : !((Object)this$tcemtTipoProcLicit).equals(other$tcemtTipoProcLicit)) {
            return false;
        }
        UUID this$idOxy = this.getIdOxy();
        UUID other$idOxy = other.getIdOxy();
        if (this$idOxy == null ? other$idOxy != null : !((Object)this$idOxy).equals(other$idOxy)) {
            return false;
        }
        String this$nomeEntidade = this.getNomeEntidade();
        String other$nomeEntidade = other.getNomeEntidade();
        if (this$nomeEntidade == null ? other$nomeEntidade != null : !this$nomeEntidade.equals(other$nomeEntidade)) {
            return false;
        }
        String this$displayLicitacao = this.getDisplayLicitacao();
        String other$displayLicitacao = other.getDisplayLicitacao();
        if (this$displayLicitacao == null ? other$displayLicitacao != null : !this$displayLicitacao.equals(other$displayLicitacao)) {
            return false;
        }
        String this$descricao = this.getDescricao();
        String other$descricao = other.getDescricao();
        if (this$descricao == null ? other$descricao != null : !this$descricao.equals(other$descricao)) {
            return false;
        }
        LocalDate this$dataPublicacao = this.getDataPublicacao();
        LocalDate other$dataPublicacao = other.getDataPublicacao();
        if (this$dataPublicacao == null ? other$dataPublicacao != null : !((Object)this$dataPublicacao).equals(other$dataPublicacao)) {
            return false;
        }
        LocalDate this$dataAbertura = this.getDataAbertura();
        LocalDate other$dataAbertura = other.getDataAbertura();
        if (this$dataAbertura == null ? other$dataAbertura != null : !((Object)this$dataAbertura).equals(other$dataAbertura)) {
            return false;
        }
        String this$horarioAbertura = this.getHorarioAbertura();
        String other$horarioAbertura = other.getHorarioAbertura();
        if (this$horarioAbertura == null ? other$horarioAbertura != null : !this$horarioAbertura.equals(other$horarioAbertura)) {
            return false;
        }
        String this$visualizaPortal = this.getVisualizaPortal();
        String other$visualizaPortal = other.getVisualizaPortal();
        if (this$visualizaPortal == null ? other$visualizaPortal != null : !this$visualizaPortal.equals(other$visualizaPortal)) {
            return false;
        }
        String this$tipoCancelamento = this.getTipoCancelamento();
        String other$tipoCancelamento = other.getTipoCancelamento();
        if (this$tipoCancelamento == null ? other$tipoCancelamento != null : !this$tipoCancelamento.equals(other$tipoCancelamento)) {
            return false;
        }
        String this$natureza = this.getNatureza();
        String other$natureza = other.getNatureza();
        if (this$natureza == null ? other$natureza != null : !this$natureza.equals(other$natureza)) {
            return false;
        }
        String this$objeto = this.getObjeto();
        String other$objeto = other.getObjeto();
        if (this$objeto == null ? other$objeto != null : !this$objeto.equals(other$objeto)) {
            return false;
        }
        String this$displayProtocolo = this.getDisplayProtocolo();
        String other$displayProtocolo = other.getDisplayProtocolo();
        if (this$displayProtocolo == null ? other$displayProtocolo != null : !this$displayProtocolo.equals(other$displayProtocolo)) {
            return false;
        }
        BigDecimal this$valorMaximo = this.getValorMaximo();
        BigDecimal other$valorMaximo = other.getValorMaximo();
        if (this$valorMaximo == null ? other$valorMaximo != null : !((Object)this$valorMaximo).equals(other$valorMaximo)) {
            return false;
        }
        BigDecimal this$totalVencido = this.getTotalVencido();
        BigDecimal other$totalVencido = other.getTotalVencido();
        if (this$totalVencido == null ? other$totalVencido != null : !((Object)this$totalVencido).equals(other$totalVencido)) {
            return false;
        }
        String this$hasRecurso = this.getHasRecurso();
        String other$hasRecurso = other.getHasRecurso();
        if (this$hasRecurso == null ? other$hasRecurso != null : !this$hasRecurso.equals(other$hasRecurso)) {
            return false;
        }
        String this$observacao = this.getObservacao();
        String other$observacao = other.getObservacao();
        if (this$observacao == null ? other$observacao != null : !this$observacao.equals(other$observacao)) {
            return false;
        }
        String this$isCovid = this.getIsCovid();
        String other$isCovid = other.getIsCovid();
        if (this$isCovid == null ? other$isCovid != null : !this$isCovid.equals(other$isCovid)) {
            return false;
        }
        String this$formaApuracao = this.getFormaApuracao();
        String other$formaApuracao = other.getFormaApuracao();
        if (this$formaApuracao == null ? other$formaApuracao != null : !this$formaApuracao.equals(other$formaApuracao)) {
            return false;
        }
        String this$tipoParticipacao = this.getTipoParticipacao();
        String other$tipoParticipacao = other.getTipoParticipacao();
        if (this$tipoParticipacao == null ? other$tipoParticipacao != null : !this$tipoParticipacao.equals(other$tipoParticipacao)) {
            return false;
        }
        LocalDate this$dataInfOriginal = this.getDataInfOriginal();
        LocalDate other$dataInfOriginal = other.getDataInfOriginal();
        if (this$dataInfOriginal == null ? other$dataInfOriginal != null : !((Object)this$dataInfOriginal).equals(other$dataInfOriginal)) {
            return false;
        }
        String this$entidadeInfOriginal = this.getEntidadeInfOriginal();
        String other$entidadeInfOriginal = other.getEntidadeInfOriginal();
        if (this$entidadeInfOriginal == null ? other$entidadeInfOriginal != null : !this$entidadeInfOriginal.equals(other$entidadeInfOriginal)) {
            return false;
        }
        LocalDate this$dataPubInfOriginal = this.getDataPubInfOriginal();
        LocalDate other$dataPubInfOriginal = other.getDataPubInfOriginal();
        if (this$dataPubInfOriginal == null ? other$dataPubInfOriginal != null : !((Object)this$dataPubInfOriginal).equals(other$dataPubInfOriginal)) {
            return false;
        }
        String this$obsInfOriginal = this.getObsInfOriginal();
        String other$obsInfOriginal = other.getObsInfOriginal();
        if (this$obsInfOriginal == null ? other$obsInfOriginal != null : !this$obsInfOriginal.equals(other$obsInfOriginal)) {
            return false;
        }
        String this$aplicaLei14133 = this.getAplicaLei14133();
        String other$aplicaLei14133 = other.getAplicaLei14133();
        if (this$aplicaLei14133 == null ? other$aplicaLei14133 != null : !this$aplicaLei14133.equals(other$aplicaLei14133)) {
            return false;
        }
        String this$idTipoCompra = this.getIdTipoCompra();
        String other$idTipoCompra = other.getIdTipoCompra();
        if (this$idTipoCompra == null ? other$idTipoCompra != null : !this$idTipoCompra.equals(other$idTipoCompra)) {
            return false;
        }
        String this$descTipoCompra = this.getDescTipoCompra();
        String other$descTipoCompra = other.getDescTipoCompra();
        if (this$descTipoCompra == null ? other$descTipoCompra != null : !this$descTipoCompra.equals(other$descTipoCompra)) {
            return false;
        }
        LocalDate this$dataInicialProposta = this.getDataInicialProposta();
        LocalDate other$dataInicialProposta = other.getDataInicialProposta();
        if (this$dataInicialProposta == null ? other$dataInicialProposta != null : !((Object)this$dataInicialProposta).equals(other$dataInicialProposta)) {
            return false;
        }
        String this$horaInicialProposta = this.getHoraInicialProposta();
        String other$horaInicialProposta = other.getHoraInicialProposta();
        if (this$horaInicialProposta == null ? other$horaInicialProposta != null : !this$horaInicialProposta.equals(other$horaInicialProposta)) {
            return false;
        }
        LocalDate this$dataFinalProposta = this.getDataFinalProposta();
        LocalDate other$dataFinalProposta = other.getDataFinalProposta();
        if (this$dataFinalProposta == null ? other$dataFinalProposta != null : !((Object)this$dataFinalProposta).equals(other$dataFinalProposta)) {
            return false;
        }
        String this$horaFinalProposta = this.getHoraFinalProposta();
        String other$horaFinalProposta = other.getHoraFinalProposta();
        if (this$horaFinalProposta == null ? other$horaFinalProposta != null : !this$horaFinalProposta.equals(other$horaFinalProposta)) {
            return false;
        }
        String this$displayProcessoAdm = this.getDisplayProcessoAdm();
        String other$displayProcessoAdm = other.getDisplayProcessoAdm();
        if (this$displayProcessoAdm == null ? other$displayProcessoAdm != null : !this$displayProcessoAdm.equals(other$displayProcessoAdm)) {
            return false;
        }
        UUID this$processoAdmId = this.getProcessoAdmId();
        UUID other$processoAdmId = other.getProcessoAdmId();
        if (this$processoAdmId == null ? other$processoAdmId != null : !((Object)this$processoAdmId).equals(other$processoAdmId)) {
            return false;
        }
        String this$orcamentoSigiloso = this.getOrcamentoSigiloso();
        String other$orcamentoSigiloso = other.getOrcamentoSigiloso();
        if (this$orcamentoSigiloso == null ? other$orcamentoSigiloso != null : !this$orcamentoSigiloso.equals(other$orcamentoSigiloso)) {
            return false;
        }
        String this$ataDeAdesao = this.getAtaDeAdesao();
        String other$ataDeAdesao = other.getAtaDeAdesao();
        if (this$ataDeAdesao == null ? other$ataDeAdesao != null : !this$ataDeAdesao.equals(other$ataDeAdesao)) {
            return false;
        }
        String this$fundamentoLegal = this.getFundamentoLegal();
        String other$fundamentoLegal = other.getFundamentoLegal();
        if (this$fundamentoLegal == null ? other$fundamentoLegal != null : !this$fundamentoLegal.equals(other$fundamentoLegal)) {
            return false;
        }
        String this$numeroLei = this.getNumeroLei();
        String other$numeroLei = other.getNumeroLei();
        if (this$numeroLei == null ? other$numeroLei != null : !this$numeroLei.equals(other$numeroLei)) {
            return false;
        }
        String this$anoLei = this.getAnoLei();
        String other$anoLei = other.getAnoLei();
        if (this$anoLei == null ? other$anoLei != null : !this$anoLei.equals(other$anoLei)) {
            return false;
        }
        String this$artigoLei = this.getArtigoLei();
        String other$artigoLei = other.getArtigoLei();
        if (this$artigoLei == null ? other$artigoLei != null : !this$artigoLei.equals(other$artigoLei)) {
            return false;
        }
        String this$incisoLei = this.getIncisoLei();
        String other$incisoLei = other.getIncisoLei();
        return !(this$incisoLei == null ? other$incisoLei != null : !this$incisoLei.equals(other$incisoLei));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LicitacaoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $tipoLicitacao = this.getTipoLicitacao();
        result = result * 59 + ($tipoLicitacao == null ? 43 : ((Object)$tipoLicitacao).hashCode());
        Long $licitacao = this.getLicitacao();
        result = result * 59 + ($licitacao == null ? 43 : ((Object)$licitacao).hashCode());
        Long $numeroLicitacao = this.getNumeroLicitacao();
        result = result * 59 + ($numeroLicitacao == null ? 43 : ((Object)$numeroLicitacao).hashCode());
        Long $protocolo = this.getProtocolo();
        result = result * 59 + ($protocolo == null ? 43 : ((Object)$protocolo).hashCode());
        Long $anoProtocolo = this.getAnoProtocolo();
        result = result * 59 + ($anoProtocolo == null ? 43 : ((Object)$anoProtocolo).hashCode());
        Long $numeroInfOriginal = this.getNumeroInfOriginal();
        result = result * 59 + ($numeroInfOriginal == null ? 43 : ((Object)$numeroInfOriginal).hashCode());
        Long $anoInfOriginal = this.getAnoInfOriginal();
        result = result * 59 + ($anoInfOriginal == null ? 43 : ((Object)$anoInfOriginal).hashCode());
        Long $modalidadeInfOriginal = this.getModalidadeInfOriginal();
        result = result * 59 + ($modalidadeInfOriginal == null ? 43 : ((Object)$modalidadeInfOriginal).hashCode());
        Long $tcemtTipoProcLicit = this.getTcemtTipoProcLicit();
        result = result * 59 + ($tcemtTipoProcLicit == null ? 43 : ((Object)$tcemtTipoProcLicit).hashCode());
        UUID $idOxy = this.getIdOxy();
        result = result * 59 + ($idOxy == null ? 43 : ((Object)$idOxy).hashCode());
        String $nomeEntidade = this.getNomeEntidade();
        result = result * 59 + ($nomeEntidade == null ? 43 : $nomeEntidade.hashCode());
        String $displayLicitacao = this.getDisplayLicitacao();
        result = result * 59 + ($displayLicitacao == null ? 43 : $displayLicitacao.hashCode());
        String $descricao = this.getDescricao();
        result = result * 59 + ($descricao == null ? 43 : $descricao.hashCode());
        LocalDate $dataPublicacao = this.getDataPublicacao();
        result = result * 59 + ($dataPublicacao == null ? 43 : ((Object)$dataPublicacao).hashCode());
        LocalDate $dataAbertura = this.getDataAbertura();
        result = result * 59 + ($dataAbertura == null ? 43 : ((Object)$dataAbertura).hashCode());
        String $horarioAbertura = this.getHorarioAbertura();
        result = result * 59 + ($horarioAbertura == null ? 43 : $horarioAbertura.hashCode());
        String $visualizaPortal = this.getVisualizaPortal();
        result = result * 59 + ($visualizaPortal == null ? 43 : $visualizaPortal.hashCode());
        String $tipoCancelamento = this.getTipoCancelamento();
        result = result * 59 + ($tipoCancelamento == null ? 43 : $tipoCancelamento.hashCode());
        String $natureza = this.getNatureza();
        result = result * 59 + ($natureza == null ? 43 : $natureza.hashCode());
        String $objeto = this.getObjeto();
        result = result * 59 + ($objeto == null ? 43 : $objeto.hashCode());
        String $displayProtocolo = this.getDisplayProtocolo();
        result = result * 59 + ($displayProtocolo == null ? 43 : $displayProtocolo.hashCode());
        BigDecimal $valorMaximo = this.getValorMaximo();
        result = result * 59 + ($valorMaximo == null ? 43 : ((Object)$valorMaximo).hashCode());
        BigDecimal $totalVencido = this.getTotalVencido();
        result = result * 59 + ($totalVencido == null ? 43 : ((Object)$totalVencido).hashCode());
        String $hasRecurso = this.getHasRecurso();
        result = result * 59 + ($hasRecurso == null ? 43 : $hasRecurso.hashCode());
        String $observacao = this.getObservacao();
        result = result * 59 + ($observacao == null ? 43 : $observacao.hashCode());
        String $isCovid = this.getIsCovid();
        result = result * 59 + ($isCovid == null ? 43 : $isCovid.hashCode());
        String $formaApuracao = this.getFormaApuracao();
        result = result * 59 + ($formaApuracao == null ? 43 : $formaApuracao.hashCode());
        String $tipoParticipacao = this.getTipoParticipacao();
        result = result * 59 + ($tipoParticipacao == null ? 43 : $tipoParticipacao.hashCode());
        LocalDate $dataInfOriginal = this.getDataInfOriginal();
        result = result * 59 + ($dataInfOriginal == null ? 43 : ((Object)$dataInfOriginal).hashCode());
        String $entidadeInfOriginal = this.getEntidadeInfOriginal();
        result = result * 59 + ($entidadeInfOriginal == null ? 43 : $entidadeInfOriginal.hashCode());
        LocalDate $dataPubInfOriginal = this.getDataPubInfOriginal();
        result = result * 59 + ($dataPubInfOriginal == null ? 43 : ((Object)$dataPubInfOriginal).hashCode());
        String $obsInfOriginal = this.getObsInfOriginal();
        result = result * 59 + ($obsInfOriginal == null ? 43 : $obsInfOriginal.hashCode());
        String $aplicaLei14133 = this.getAplicaLei14133();
        result = result * 59 + ($aplicaLei14133 == null ? 43 : $aplicaLei14133.hashCode());
        String $idTipoCompra = this.getIdTipoCompra();
        result = result * 59 + ($idTipoCompra == null ? 43 : $idTipoCompra.hashCode());
        String $descTipoCompra = this.getDescTipoCompra();
        result = result * 59 + ($descTipoCompra == null ? 43 : $descTipoCompra.hashCode());
        LocalDate $dataInicialProposta = this.getDataInicialProposta();
        result = result * 59 + ($dataInicialProposta == null ? 43 : ((Object)$dataInicialProposta).hashCode());
        String $horaInicialProposta = this.getHoraInicialProposta();
        result = result * 59 + ($horaInicialProposta == null ? 43 : $horaInicialProposta.hashCode());
        LocalDate $dataFinalProposta = this.getDataFinalProposta();
        result = result * 59 + ($dataFinalProposta == null ? 43 : ((Object)$dataFinalProposta).hashCode());
        String $horaFinalProposta = this.getHoraFinalProposta();
        result = result * 59 + ($horaFinalProposta == null ? 43 : $horaFinalProposta.hashCode());
        String $displayProcessoAdm = this.getDisplayProcessoAdm();
        result = result * 59 + ($displayProcessoAdm == null ? 43 : $displayProcessoAdm.hashCode());
        UUID $processoAdmId = this.getProcessoAdmId();
        result = result * 59 + ($processoAdmId == null ? 43 : ((Object)$processoAdmId).hashCode());
        String $orcamentoSigiloso = this.getOrcamentoSigiloso();
        result = result * 59 + ($orcamentoSigiloso == null ? 43 : $orcamentoSigiloso.hashCode());
        String $ataDeAdesao = this.getAtaDeAdesao();
        result = result * 59 + ($ataDeAdesao == null ? 43 : $ataDeAdesao.hashCode());
        String $fundamentoLegal = this.getFundamentoLegal();
        result = result * 59 + ($fundamentoLegal == null ? 43 : $fundamentoLegal.hashCode());
        String $numeroLei = this.getNumeroLei();
        result = result * 59 + ($numeroLei == null ? 43 : $numeroLei.hashCode());
        String $anoLei = this.getAnoLei();
        result = result * 59 + ($anoLei == null ? 43 : $anoLei.hashCode());
        String $artigoLei = this.getArtigoLei();
        result = result * 59 + ($artigoLei == null ? 43 : $artigoLei.hashCode());
        String $incisoLei = this.getIncisoLei();
        result = result * 59 + ($incisoLei == null ? 43 : $incisoLei.hashCode());
        return result;
    }
}

