/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.service;

import br.com.elotech.core.utils.EloPage;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.service.EntidadeContabilidadeService;
import br.com.elotech.portaltransparencia.utils.MaskFormatterUtils;
import br.com.elotech.reportexport.exporter.BaseExport;
import br.com.elotech.reportexport.exporter.ReportParam;
import br.com.elotech.tributos.client.feign.MovimentacaoTributoFeignClient;
import br.com.elotech.tributos.dto.ClassificacaoReceitaResponseDTO;
import br.com.elotech.tributos.dto.MovimentacaoTributoDTO;
import br.com.elotech.tributos.dto.ResumoMovimentacaoTributoDTO;
import br.com.elotech.tributos.dto.TotalResumoMovimentacaoTributoDTO;
import br.com.elotech.tributos.params.MovimentacaoTributoParams;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.ModelAndView;

@Service
public class MovimentacaoTributoService {
    private final MovimentacaoTributoFeignClient movimentacaoTributoFeignClient;
    private final EntidadeContabilidadeService entidadeContabilidadeService;
    private final BaseExport baseExport;

    public EloPage<MovimentacaoTributoDTO> findMovimentacoes(MovimentacaoTributoParams params, Pageable pageable) {
        EloPage page = this.movimentacaoTributoFeignClient.findMovimentacoes(params, pageable);
        page.getContent().forEach(arg_0 -> this.makeChangesOnMovimentacaoTributoDTO(arg_0));
        return page;
    }

    public List<ClassificacaoReceitaResponseDTO> findClassificacoes() {
        return this.movimentacaoTributoFeignClient.getClassificacoes();
    }

    public EloPage<ResumoMovimentacaoTributoDTO> findResumo(MovimentacaoTributoParams params, Pageable pageable) {
        return this.movimentacaoTributoFeignClient.getResumoCancelamentos(params, pageable);
    }

    public TotalResumoMovimentacaoTributoDTO findTotalResumo(MovimentacaoTributoParams params) {
        return this.movimentacaoTributoFeignClient.getTotalCancelamentos(params);
    }

    public ModelAndView findMovimentacoesExport(HttpServletRequest request, HttpServletResponse response, MovimentacaoTributoParams params, Long entidade, String exportType, Pageable pageable) throws Throwable {
        EloPage eloPage = this.findMovimentacoes(params, pageable);
        PageImpl page = new PageImpl(eloPage.getContent(), pageable, (long)eloPage.getTotalPages());
        Entidade entidadeObj = this.entidadeContabilidadeService.getEntidadeSelecionada(entidade);
        ReportParam reportParam = new ReportParam();
        reportParam.setNomeEntidade(entidadeObj.getNome());
        reportParam.setReportTitle("Ren\u00fancia de Receitas - " + params.getTipoMovimentacaoTributo().getDescricao());
        reportParam.setClazzDTO(MovimentacaoTributoDTO.class);
        reportParam.setHeaderFields("Data,CPF/CNPJ,Contribuinte,Esp\u00e9cie,Produto,Valor");
        reportParam.setFields("dataSituacao,cpfCnpj,contribuinte,especie,justificativa,valor");
        float[] fieldsPerc = new float[]{1.0f, 1.2f, 1.8f, 1.4f, 2.6f, 0.8f};
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        int[] fieldTab = new int[]{100, 10, 50, 20, 20, 100};
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setPage((Page)page);
        reportParam.setFontSize(6.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(exportType);
        return this.baseExport.toExport(reportParam);
    }

    private void makeChangesOnMovimentacaoTributoDTO(MovimentacaoTributoDTO movimentacaoTributoDTO) {
        movimentacaoTributoDTO.setCpfCnpj(MaskFormatterUtils.configMaskCnpjCpf((String)movimentacaoTributoDTO.getCpfCnpj()));
    }

    @Generated
    public MovimentacaoTributoService(MovimentacaoTributoFeignClient movimentacaoTributoFeignClient, EntidadeContabilidadeService entidadeContabilidadeService, BaseExport baseExport) {
        this.movimentacaoTributoFeignClient = movimentacaoTributoFeignClient;
        this.entidadeContabilidadeService = entidadeContabilidadeService;
        this.baseExport = baseExport;
    }
}

