/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.resource;

import br.com.elotech.core.utils.EloPage;
import br.com.elotech.portaltransparencia.aiseportal.service.MovimentacaoTributoService;
import br.com.elotech.tributos.dto.ClassificacaoReceitaResponseDTO;
import br.com.elotech.tributos.dto.MovimentacaoTributoDTO;
import br.com.elotech.tributos.dto.ResumoMovimentacaoTributoDTO;
import br.com.elotech.tributos.dto.TotalResumoMovimentacaoTributoDTO;
import br.com.elotech.tributos.params.MovimentacaoTributoParams;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import lombok.Generated;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/api/movimentacao-tributo"})
public class MovimentacaoTributoResource {
    private final MovimentacaoTributoService movimentacaoTributoService;

    @GetMapping
    public ResponseEntity<EloPage<MovimentacaoTributoDTO>> findMovimentacoes(@Valid MovimentacaoTributoParams params, Pageable pageable) {
        return ResponseEntity.ok((Object)this.movimentacaoTributoService.findMovimentacoes(params, pageable));
    }

    @GetMapping(value={"/classificacoes"})
    public ResponseEntity<List<ClassificacaoReceitaResponseDTO>> findClassificacoes() {
        return ResponseEntity.ok((Object)this.movimentacaoTributoService.findClassificacoes());
    }

    @GetMapping(value={"/resumo"})
    public ResponseEntity<EloPage<ResumoMovimentacaoTributoDTO>> findResumo(@Valid MovimentacaoTributoParams params, Pageable pageable) {
        return ResponseEntity.ok((Object)this.movimentacaoTributoService.findResumo(params, pageable));
    }

    @GetMapping(value={"/total-resumo"})
    public ResponseEntity<TotalResumoMovimentacaoTributoDTO> findTotal(@Valid MovimentacaoTributoParams params) {
        return ResponseEntity.ok((Object)this.movimentacaoTributoService.findTotalResumo(params));
    }

    @GetMapping(value={"/report"})
    public ModelAndView findMovimentacoesExport(HttpServletRequest request, HttpServletResponse response, @Valid MovimentacaoTributoParams params, Long entidade, String exportType, Pageable pageable) throws Throwable {
        return this.movimentacaoTributoService.findMovimentacoesExport(request, response, params, entidade, exportType, pageable);
    }

    @Generated
    public MovimentacaoTributoResource(MovimentacaoTributoService movimentacaoTributoService) {
        this.movimentacaoTributoService = movimentacaoTributoService;
    }
}

