/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.EstagiarioDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorDadosFinanceirosDTO;
import br.com.elotech.portaltransparencia.aiseportal.repository.EstagiarioRepository;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.AiseParams;
import br.com.elotech.portaltransparencia.aiseportal.service.EntidadeAiseService;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import br.com.elotech.portaltransparencia.web.rest.params.ServidorParams;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class EstagiarioRepositoryImpl
implements EstagiarioRepository {
    private static final String ESTAGIARIOS_SQL = "db/sql/aise/estagiarios.sql";
    private static final String ESTAGIARIOS_DADOS_FINANCEIROS_SQL = "db/sql/aise/estagiario-dados-financeiro.sql";
    private final EntidadeAiseService entidadeAiseService;
    private static final Logger LOGGER = LoggerFactory.getLogger(EstagiarioRepositoryImpl.class);
    private final DatasourceWrapper datasourceWrapper;

    public EstagiarioRepositoryImpl(DatasourceWrapper datasourceWrapper, EntidadeAiseService entidadeAiseService) {
        this.datasourceWrapper = datasourceWrapper;
        this.entidadeAiseService = entidadeAiseService;
    }

    public Page<EstagiarioDTO> loadEstagiarios(ServidorParams params, Pageable pageable) {
        this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)ESTAGIARIOS_SQL));
        sql.append(this.getSqlComplementar(params));
        String query = SqlUtils.aplicaOrdenacao((Pageable)pageable, (String)sql.toString(), (String)"ORDER BY NOME");
        query = SqlUtils.aplicaPaginacao((Pageable)pageable, (String)query, (String)this.datasourceWrapper.getPlatform());
        MapSqlParameterSource parameter = params.toJdbcParameter();
        LOGGER.debug(sql.toString());
        LOGGER.debug(params.toString());
        List estagiarios = this.datasourceWrapper.getJdbcTemplate().query(query, (SqlParameterSource)parameter, (RowMapper)new ElotechBeanPropertyRowMapper(EstagiarioDTO.class));
        return new PageImpl(estagiarios, pageable, this.getQuantidadeServidores(sql.toString(), parameter).longValue());
    }

    public List<ServidorDadosFinanceirosDTO> loadDadosFinanceiros(ServidorParams params) {
        this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
        String query = FileUtils.readResourceAsString((String)ESTAGIARIOS_DADOS_FINANCEIROS_SQL);
        MapSqlParameterSource parameter = params.toJdbcParameter();
        LOGGER.debug(query);
        LOGGER.debug(params.toString());
        return this.datasourceWrapper.getJdbcTemplate().query(query, (SqlParameterSource)parameter, (RowMapper)new ElotechBeanPropertyRowMapper(ServidorDadosFinanceirosDTO.class));
    }

    public Optional<EstagiarioDTO> loadEstagiario(ServidorParams params) {
        this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)ESTAGIARIOS_SQL));
        sql.append(" AND RES.ESTAGIARIO = :codigo ");
        List servidores = this.datasourceWrapper.getJdbcTemplate().query(sql.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(EstagiarioDTO.class));
        return servidores.stream().findFirst();
    }

    private Long getQuantidadeServidores(String query, MapSqlParameterSource parameter) {
        StringBuilder queryCount = new StringBuilder("SELECT COUNT(*) FROM (");
        queryCount.append(query);
        queryCount.append(") COUNT");
        return (Long)this.datasourceWrapper.getJdbcTemplate().queryForObject(queryCount.toString(), (SqlParameterSource)parameter, Long.class);
    }

    private String getSqlComplementar(ServidorParams params) {
        StringBuilder sqlComplementar = new StringBuilder();
        if (Objects.nonNull(params.getEstagioVigente()) && params.getEstagioVigente().booleanValue() && params.anoAtual(params.getExercicio())) {
            sqlComplementar.append(" AND (RES.DATARESCISAO IS NULL OR RES.DATARESCISAO >= :dataAtual) ");
        }
        sqlComplementar.append(SqlUtils.andLike((String)"${db.aise.schema}", (String)"PES.NOME", (String)params.getNomeServidor()));
        sqlComplementar.append(SqlUtils.andLike((String)"${db.aise.schema}", (String)"RCG.DESCRICAO", (String)params.getCargo()));
        sqlComplementar.append(SqlUtils.andLike((String)"${db.aise.schema}", (String)"LOT.DESCRICAO", (String)params.getLotacao()));
        return sqlComplementar.toString();
    }
}

