/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.AfastamentoDTO;
import br.com.elotech.portaltransparencia.aiseportal.repository.AfastamentoRepository;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.AfastamentoParams;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.AiseParams;
import br.com.elotech.portaltransparencia.aiseportal.service.EntidadeAiseService;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class AfastamentoRepositoryImpl
implements AfastamentoRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(AfastamentoRepositoryImpl.class);
    private final EntidadeAiseService entidadeAiseService;
    private static final String AFASTAMENTOS = "db/sql/aise/afastamentos.sql";
    private final DatasourceWrapper datasourceWrapper;

    @Autowired
    public AfastamentoRepositoryImpl(DatasourceWrapper datasourceWrapper, EntidadeAiseService entidadeAiseService) {
        this.datasourceWrapper = datasourceWrapper;
        this.entidadeAiseService = entidadeAiseService;
    }

    public Page<AfastamentoDTO> findAfastamentos(AfastamentoParams params, Pageable pageable) {
        this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)AFASTAMENTOS));
        StringBuilder filtro = new StringBuilder();
        if (params.getAfastamentoVigente() == null || params.getAfastamentoVigente().booleanValue()) {
            filtro.append(" AND F.SITUACAO <> 3");
            filtro.append(" AND ((MA.DATAINICIAL <= :dataAtual)");
            filtro.append(" AND ((MA.DATAFINAL >= :dataAtual) OR (MA.DATAFINAL IS NULL)))");
        }
        this.addFilterNome(filtro, params.getNome());
        this.addFilterDataInicial(filtro, params.getDataInicial());
        this.addFilterDataFinal(filtro, params.getDataFinal());
        this.addFilterTipoAfastamento(filtro, params.getTipoAfastamento());
        sql.append((CharSequence)filtro);
        String query = SqlUtils.aplicaOrdenacao((Pageable)pageable, (String)sql.toString(), (String)"ORDER BY NOME");
        query = SqlUtils.aplicaPaginacao((Pageable)pageable, (String)query, (String)this.datasourceWrapper.getPlatform());
        MapSqlParameterSource parameter = params.toJdbcParameter();
        List afastamentos = this.datasourceWrapper.getJdbcTemplate().query(query, (SqlParameterSource)parameter, (RowMapper)new ElotechBeanPropertyRowMapper(AfastamentoDTO.class));
        return new PageImpl(afastamentos, pageable, this.getQuantidadeAfastamentos(sql.toString(), parameter).longValue());
    }

    private void addFilterNome(StringBuilder sql, String valor) {
        if (Objects.nonNull(valor)) {
            sql.append(SqlUtils.andLike((String)"${db.aise.schema}", (String)"P.NOME", (String)valor));
        }
    }

    private void addFilterDataInicial(StringBuilder sql, LocalDate valor) {
        if (Objects.nonNull(valor)) {
            sql.append(" AND (MA.DATAINICIAL >= :dataInicial)");
        }
    }

    private void addFilterDataFinal(StringBuilder sql, LocalDate valor) {
        if (Objects.nonNull(valor)) {
            sql.append(" AND ((MA.DATAFINAL <= :dataFinal)");
            sql.append(" OR (MA.DATAFINAL IS NULL))");
        }
    }

    private void addFilterTipoAfastamento(StringBuilder sql, Long valor) {
        if (Objects.nonNull(valor)) {
            sql.append(" AND MP.TIPOMOVIMENTACAO = :tipoAfastamento");
        }
    }

    private Long getQuantidadeAfastamentos(String sql, MapSqlParameterSource parameter) {
        StringBuilder queryCount = new StringBuilder("SELECT COUNT(*) FROM (");
        queryCount.append(sql);
        queryCount.append(") COUNT");
        return (Long)this.datasourceWrapper.getJdbcTemplate().queryForObject(queryCount.toString(), (SqlParameterSource)parameter, Long.class);
    }
}

