/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.domain.dto.converter;

import br.com.elotech.folhapagamento.client.domain.PortalTransparenciaDadosServidorDTO;
import br.com.elotech.folhapagamento.client.domain.PortalTransparenciaServidoresDTO;
import br.com.elotech.folhapagamento.client.domain.enums.TipoSituacaoFuncional;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.EstagiarioDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.PensionistaDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.converter.ServidorDadosFinanceiroDTOConverter;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;

public final class ServidorDTOConverter {
    private ServidorDTOConverter() {
    }

    public static ServidorDTO portalTransparenciaServidoresDTOToServidorDTO(PortalTransparenciaServidoresDTO portalTransparenciaServidoresDTO) {
        ServidorDTO servidorDTO = new ServidorDTO();
        servidorDTO.setMatricula(portalTransparenciaServidoresDTO.getMatricula());
        servidorDTO.setNome(portalTransparenciaServidoresDTO.getNome());
        servidorDTO.setDescricaoCargo(portalTransparenciaServidoresDTO.getDescricaoCargo());
        servidorDTO.setDescricaoClasse(portalTransparenciaServidoresDTO.getDescricaoClasse());
        servidorDTO.setDescricaoNatureza(portalTransparenciaServidoresDTO.getDescricaoEnumClasseDefinicao());
        servidorDTO.setDescricaoLotacao(portalTransparenciaServidoresDTO.getDescricaoLotacao());
        Object situacaoFuncionario = portalTransparenciaServidoresDTO.getSituacao().getValue();
        if (TipoSituacaoFuncional.AFASTADO.equals((Object)portalTransparenciaServidoresDTO.getSituacao()) && StringUtils.isNotBlank((String)portalTransparenciaServidoresDTO.getDescricaoAfastamento())) {
            situacaoFuncionario = (String)situacaoFuncionario + " - " + portalTransparenciaServidoresDTO.getDescricaoAfastamento();
        }
        servidorDTO.setSituacao((String)situacaoFuncionario);
        servidorDTO.setVinculo(portalTransparenciaServidoresDTO.getVinculo().getValue());
        servidorDTO.setDataAdmissao(portalTransparenciaServidoresDTO.getDataAdmissao());
        servidorDTO.setDataFimContrato(portalTransparenciaServidoresDTO.getDataFimContrato());
        return servidorDTO;
    }

    public static ServidorDTO portalTransparenciaDadosServidorDTOToServidorDTO(PortalTransparenciaDadosServidorDTO portalTransparenciaDadosServidorDTO) {
        ServidorDTO servidorDTO = new ServidorDTO();
        servidorDTO.setEntidade(portalTransparenciaDadosServidorDTO.getEntidade());
        servidorDTO.setExercicio(portalTransparenciaDadosServidorDTO.getExercicio());
        servidorDTO.setMatricula(portalTransparenciaDadosServidorDTO.getMatricula());
        servidorDTO.setNome(portalTransparenciaDadosServidorDTO.getNome());
        servidorDTO.setCargo(portalTransparenciaDadosServidorDTO.getCargo());
        servidorDTO.setHorasSemanais(portalTransparenciaDadosServidorDTO.getHorasSemanais());
        servidorDTO.setNomeacao(portalTransparenciaDadosServidorDTO.getNomeacao());
        servidorDTO.setDescricaoCargo(portalTransparenciaDadosServidorDTO.getDescricaoCargo());
        servidorDTO.setDescricaoLotacao(portalTransparenciaDadosServidorDTO.getDescricaoLotacao());
        servidorDTO.setClasse(portalTransparenciaDadosServidorDTO.getClasse());
        servidorDTO.setVinculo(portalTransparenciaDadosServidorDTO.getVinculo());
        servidorDTO.setDescricaoClasse(portalTransparenciaDadosServidorDTO.getDescricaoClasse());
        servidorDTO.setDescricaoNatureza(portalTransparenciaDadosServidorDTO.splitDescricaoNatureza());
        servidorDTO.setFaixa(portalTransparenciaDadosServidorDTO.getFaixa());
        servidorDTO.setSituacao(portalTransparenciaDadosServidorDTO.getSituacao());
        servidorDTO.setCedido(portalTransparenciaDadosServidorDTO.getCedido());
        servidorDTO.setCedidoPara(portalTransparenciaDadosServidorDTO.getCedidoPara());
        servidorDTO.setDataAdmissao(portalTransparenciaDadosServidorDTO.getDataAdmissao());
        servidorDTO.setDataDemissao(portalTransparenciaDadosServidorDTO.getDataDemissao());
        servidorDTO.setLocalTrabalho(portalTransparenciaDadosServidorDTO.getLocalTrabalho());
        servidorDTO.setHorarioEntrada(portalTransparenciaDadosServidorDTO.getHorarioEntrada());
        servidorDTO.setHorarioSaidaIntervalo(portalTransparenciaDadosServidorDTO.getHorarioSaidaIntervalo());
        servidorDTO.setHorarioEntradaIntervalo(portalTransparenciaDadosServidorDTO.getHorarioEntradaIntervalo());
        servidorDTO.setHorarioSaida(portalTransparenciaDadosServidorDTO.getHorarioSaida());
        servidorDTO.setHorarioEspecial(portalTransparenciaDadosServidorDTO.getHorarioEspecial());
        servidorDTO.setHorarioTrabalho(portalTransparenciaDadosServidorDTO.getHorarioTrabalho());
        servidorDTO.setFormaInvestidura(portalTransparenciaDadosServidorDTO.getFormaInvestidura());
        servidorDTO.setAnotacoes(portalTransparenciaDadosServidorDTO.getAnotacoes());
        servidorDTO.setExibeCargaHoraria(portalTransparenciaDadosServidorDTO.getExibeCargaHoraria());
        servidorDTO.setDadosFinanceiros(portalTransparenciaDadosServidorDTO.getDadosFinanceiros().stream().map(ServidorDadosFinanceiroDTOConverter::toServidorDadosFinanceirosDTO).collect(Collectors.toList()));
        servidorDTO.setSalarioBase(portalTransparenciaDadosServidorDTO.getSalarioBase());
        servidorDTO.setTipoAposentadoria(portalTransparenciaDadosServidorDTO.getTipoAposentadoria());
        servidorDTO.setCbo(portalTransparenciaDadosServidorDTO.getCbo());
        servidorDTO.setDescricaoAtividades(portalTransparenciaDadosServidorDTO.getDescricaoAtividades());
        servidorDTO.setTipoRemuneracao(portalTransparenciaDadosServidorDTO.getTipoRemuneracao());
        return servidorDTO;
    }

    public static ServidorDTO EstagiarioDTOToServidorDTO(EstagiarioDTO estagiarioDTO) {
        ServidorDTO servidorDTO = new ServidorDTO();
        servidorDTO.setMatricula(estagiarioDTO.getMatricula());
        servidorDTO.setNome(estagiarioDTO.getNome());
        servidorDTO.setDescricaoCargo(estagiarioDTO.getDescricaoCargo());
        servidorDTO.setDescricaoClasse(estagiarioDTO.getDescricaoClasse());
        servidorDTO.setDescricaoLotacao(estagiarioDTO.getDescricaoLotacao());
        servidorDTO.setDataAdmissao(estagiarioDTO.getDataAdmissao());
        servidorDTO.setDataFimContrato(estagiarioDTO.getDataFimContrato());
        return servidorDTO;
    }

    public static ServidorDTO pensionistaToServidor(PensionistaDTO pensionistaDTO) {
        ServidorDTO servidorDTO = new ServidorDTO();
        BeanUtils.copyProperties((Object)pensionistaDTO, (Object)servidorDTO);
        return servidorDTO;
    }
}

