/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia;

import br.com.elotech.core.config.ElotechApplication;
import br.com.elotech.portaltransparencia.aiseportal.ws.config.ServidorProperties;
import br.com.elotech.portaltransparencia.config.DatabaseLoader;
import com.github.springtestdbunit.bean.DatabaseConfigBean;
import feign.Logger;
import java.net.UnknownHostException;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.security.servlet.SecurityAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Profile;

@SpringBootApplication(exclude={SecurityAutoConfiguration.class})
@EnableConfigurationProperties(value={ServidorProperties.class})
public class PortalTransparenciaApplication {
    public static void main(String[] args) throws UnknownHostException {
        ElotechApplication.run(PortalTransparenciaApplication.class, (String[])args);
    }

    @Bean
    @Profile(value={"dev"})
    public DatabaseLoader databaseLoader(DataSource dataSource) {
        DatabaseConfigBean databaseConfigBean = new DatabaseConfigBean();
        databaseConfigBean.setQualifiedTableNames(Boolean.TRUE);
        return new DatabaseLoader(dataSource, databaseConfigBean);
    }

    @Bean
    public Logger.Level feignLoggerLevel() {
        return Logger.Level.FULL;
    }
}

