SELECT row_number() OVER (ORDER BY XX.FONTERECURSO, XX.DATA, XX.EMPENHO, XX.NOLIQUIDACAO, XX.EXERCICIO) AS ORDEMFONTERECURSO, XX.*
  FROM (
SELECT DISTINCT
       FR.FONTERECURSO||' - '||FR.DESCRICAO AS FONTERECURSO,
       P.DATA,
       L.EXERCICIO AS EXERCICIOLIQUIDACAO,
       L.NOLIQUIDACAO,
       LIQ.DATA AS DATALIQUIDACAO,
       LIQ.DATAVENCIMENTO,
       E.ENTIDADE,
       E.EXERCICIO,
       E.EMPENHO,
       E.EMPENHO||'/'||E.EXERCICIO AS EMPENHOEXERCICIO,
       TL.DESCRICAO AS TIPOLICITACAO,
       E.NOLICITACAO||'/'||E.ANOLICITACAO AS LICITACAO,
       CASE WHEN F.TIPOPESSOA = 'F' THEN '****' || SUBSTR(F.CNPJ, 5, 3) || '****' || ' - ' || (${db.contabilidade.schema}.BUSCARAZAOSOCIALFORNECEDOR(F.FORNECEDOR, P.DATA))
            ELSE SUBSTR(F.CNPJ,1,2) || '.' || SUBSTR(F.CNPJ,3,3) || '.' || SUBSTR(F.CNPJ,6,3) || '/' || SUBSTR(F.CNPJ,9,4) || '-' || SUBSTR(F.CNPJ,13,2) || ' - ' || (${db.contabilidade.schema}.BUSCARAZAOSOCIALFORNECEDOR(F.FORNECEDOR, P.DATA))
       END AS FORNECEDOR,
       L.VALOR,
       L.VALOR AS SALDO,
       E.NOPROCESSO||'/'||E.ANOPROCESSO AS PROCESSO,       
	   CASE WHEN E.TIPOCONTRATOAPICE = 'CP' THEN 'fornecimentoBens'
	        WHEN E.TIPOCONTRATOAPICE = 'LC' THEN 'locacoes'
			WHEN E.TIPOCONTRATOAPICE = 'PS' THEN 'prestacaoServicos'
       	    WHEN E.TIPOCONTRATOAPICE = 'OE' THEN 'obras'
       	    ELSE 'outros'
       END AS TIPOCONTRATO,
	   CASE WHEN IC.TIPOCONTRATOCONTABIL = '04' THEN 'fornecimentoBens'
	        ELSE 'outros'
	   END AS TIPOCONTRATOCONTABIL,
       
	   COALESCE(CP.OBSERVACAO,'') AS OBSERVACAO,
       L.VALOR + COALESCE((SELECT  SUM(RETLIQ.VALOR)
                             FROM ${db.contabilidade.schema}.RETENCOESLIQUIDACAO RETLIQ
                             JOIN ${db.contabilidade.schema}.PARAMETROS PARAM
                               ON  PARAM.ENTIDADE   = RETLIQ.ENTIDADE
                              AND  PARAM. EXERCICIO = RETLIQ.EXERCICIO
                              AND  PARAM.MODULO     = '3'
                              AND  PARAM.CODIGO     = 18
                              AND  PARAM.VALOR      = 'L'
                            WHERE  RETLIQ.ENTIDADE         = L.ENTIDADE
                            AND    RETLIQ.EXERCICIO        = L.EXERCICIO
                            AND    RETLIQ.NOLIQUIDACAO     = L.NOLIQUIDACAO
                            AND    RETLIQ.TIPODOCORIGEM    = 'E'
                            AND    RETLIQ.ANODOCORIGEM     = L.ANODOCORIGEM
                            AND    RETLIQ.NODOCORIGEM      = L.NODOCORIGEM
                            AND    RETLIQ.UNIDADEDOCORIGEM = L.UNIDADEDOCORIGEM),0) + COALESCE((SELECT  SUM(RETPAG.VALOR)
                                                                                                  FROM ${db.contabilidade.schema}.ORDEMPAGAMENTO_RETENCAO RETPAG
                                                                                                  JOIN ${db.contabilidade.schema}.PARAMETROS PARAM
                                                                                                    ON   PARAM.ENTIDADE   = RETPAG.ENTIDADE
                                                                                                   AND   PARAM. EXERCICIO = RETPAG.EXERCICIO
                                                                                                   AND   PARAM.MODULO     = '3'
                                                                                                   AND   PARAM.CODIGO     = 18
                                                                                                   AND   PARAM.VALOR      = 'P'
                                                                                                 WHERE  RETPAG.ENTIDADE   = L.ENTIDADE
                                                                                                 AND    RETPAG.EXERCICIO  = L.EXERCICIO
                                                                                                 AND    RETPAG.NOORDEM    = L.NOORDEM
                                                                                                 AND    RETPAG.SEQUENCIA  = L.SEQUENCIA ),0)  AS VALORPARAMETRO
  FROM ${db.contabilidade.schema}.ORDEMPAGAMENTO_LIQUIDACAO L
 INNER JOIN ${db.contabilidade.schema}.PAGAMENTO P
    ON L.ENTIDADE = P.ENTIDADE
   AND L.EXERCICIO = P.ANOORDEMPAGAMENTO
   AND L.NOORDEM = P.NOORDEMPAGAMENTO
   AND P.ESTORNO = 'N'
  LEFT OUTER JOIN ${db.contabilidade.schema}.EMPENHO E
    ON L.ENTIDADE = E.ENTIDADE
   AND L.ANODOCORIGEM = E.EXERCICIO
   AND L.NODOCORIGEM = E.EMPENHO
   AND L.UNIDADEDOCORIGEM = E.UNIDADEORCAMENTARIA
   AND E.CONTABILIZADO = 'S'
  LEFT OUTER JOIN ${db.contabilidade.schema}.FONTERECURSO FR
    ON E.FONTERECURSO = FR.FONTERECURSO     
  LEFT JOIN ${db.contabilidade.schema}.FONTERECURSOPADRAO FRP
    ON FR.CODIGOFONTEPADRAO = FRP.CODIGO
  LEFT OUTER JOIN ${db.contabilidade.schema}.TIPOSLICITACAO TL
    ON E.TIPOLICITACAO = TL.TIPOLICITACAO
  LEFT OUTER JOIN ${db.contabilidade.schema}.FORNECEDOR F
    ON E.FORNECEDOR = F.FORNECEDOR
  LEFT JOIN ${db.contabilidade.schema}.LIQUIDACAO LIQ
    ON LIQ.ENTIDADE         = L.ENTIDADE
   AND LIQ.EXERCICIO        = L.EXERCICIOLIQ
   AND LIQ.TIPODOCORIGEM    = L.TIPODOCORIGEM
   AND LIQ.ANODOCORIGEM     = L.ANODOCORIGEM
   AND LIQ.NODOCORIGEM      = L.NODOCORIGEM
   AND LIQ.UNIDADEDOCORIGEM = L.UNIDADEDOCORIGEM
   AND LIQ.NOLIQUIDACAO     = L.NOLIQUIDACAO
  LEFT JOIN ${db.contabilidade.schema}.INTEGRACAOCLCONTRATO IC
    ON IC.ENTIDADE = E.ENTIDADE
   AND IC.ID       = E.IDCONTRATO
  LEFT OUTER JOIN ${db.contabilidade.schema}.ITEMCENTRALPAGAMENTOS ICP
    ON ICP.ENTIDADE            = L.ENTIDADE
   AND ICP.ANOORDEM            = L.EXERCICIO
   AND ICP.NOORDEM             = L.NOORDEM
   AND ICP.ANODOCORIGEM        = L.ANODOCORIGEM
   AND ICP.NRDOCORIGEM         = L.NODOCORIGEM
   AND ICP.EXERCICIOLIQUIDACAO = L.EXERCICIOLIQ
   AND ICP.NRLIQUIDACAO        = L.NOLIQUIDACAO
  LEFT JOIN ${db.contabilidade.schema}.CENTRALPAGAMENTOS CP
    ON CP.ENTIDADE   = ICP.ENTIDADE
   AND CP.EXERCICIO  = ICP.EXERCICIO
   AND CP.LANCAMENTO = ICP.LANCAMENTO
       $[FILTRO]) XX $[WHERE]
