/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.protocportal.service.impl;

import br.com.elotech.portaltransparencia.exception.ParametroMalConfiguradoException;
import br.com.elotech.portaltransparencia.protocportal.domain.PROTOCParametro;
import br.com.elotech.portaltransparencia.protocportal.repository.ParametrosRepository;
import br.com.elotech.portaltransparencia.protocportal.service.EntidadeProtocoloService;
import br.com.elotech.portaltransparencia.protocportal.service.ParametroService;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ParametroServiceImpl
implements ParametroService {
    private final ParametrosRepository parametroRepository;
    private final EntidadeProtocoloService entidadeProtocoloService;

    public ParametroServiceImpl(ParametrosRepository parametroRepository, EntidadeProtocoloService entidadeProtocoloService) {
        this.parametroRepository = parametroRepository;
        this.entidadeProtocoloService = entidadeProtocoloService;
    }

    private Optional<PROTOCParametro> findParamByIdCodigo(Long entidade, Long codigo) {
        return this.parametroRepository.findFirstByIdEntidadeIdAndIdCodigoOrderByIdExercicioDesc(entidade, codigo);
    }

    public Optional<PROTOCParametro> findParametroByEntidadeExercicioCodigo(Long entidade, Long exercicio, Long codigo) {
        return this.findParamByIdCodigo(entidade, codigo);
    }

    public String findTipoProcessoProtocoloOrThrow(Long entidade, Long exercicio) {
        Long entidadeProtocolo = this.entidadeProtocoloService.getEntidadeProtocolo(entidade).orElse(entidade);
        Optional parametroTipoProcesso = this.findParamByIdCodigo(entidadeProtocolo, Long.valueOf(83L)).map(PROTOCParametro::getValor).orElseThrow(() -> new ParametroMalConfiguradoException(entidadeProtocolo, Long.valueOf(83L)));
        if (parametroTipoProcesso.isPresent() && StringUtils.isNotBlank((CharSequence)((CharSequence)parametroTipoProcesso.get()))) {
            return (String)parametroTipoProcesso.get();
        }
        throw new ParametroMalConfiguradoException(String.format("O valor do par\u00e2metro %d n\u00e3o est\u00e1 configurado corretamente para a entidade %d", 83L, entidadeProtocolo));
    }

    public String findParametroPorEntidadeEExercicio(Long entidade, Long codigo) {
        return this.findParamByIdCodigo(entidade, codigo).orElse(new PROTOCParametro()).getValor().orElse(null);
    }
}

