/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository.impl;

import br.com.elotech.contabilidade.client.RealizacaoReceitaFeignClient;
import br.com.elotech.contabilidade.client.ReceitaFeignClient;
import br.com.elotech.core.utils.DateUtils;
import br.com.elotech.core.utils.EloPage;
import br.com.elotech.orcamento.client.PPAFeignClient;
import br.com.elotech.orcamento.client.dto.ReceitaPadraoTCEDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.RealizacaoReceitaDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ReceitaDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ReceitaFiltroDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.ReceitaRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.FindReceitaParams;
import br.com.elotech.portaltransparencia.dto.ReceitaSaldoLoadedDTO;
import br.com.elotech.portaltransparencia.utils.PrecisionUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.Month;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class ReceitaOxyRepositoryImpl
implements ReceitaRepository {
    private static final String CODIGO = "codigo";
    private static final String DESCRICAO = "descricao";
    private static final String FONTE_RECURSO = "fonteRecurso";
    private static final String RECEITA = "receita";
    private static final String RECEITA_BASE = "receita.receitaBase";
    private static final String PR = "PR";
    private static final Long TIPO_OPERACAO_RECEITA = 1L;
    private static final HashMap<String, BiFunction<Sort.Order, String, Sort.Order>> ORDERS = new HashMap();
    private static final HashMap<String, BiFunction<String, String, String>> FILTERS = new HashMap();
    private final PPAFeignClient ppaFeignClient;
    private final ReceitaFeignClient receitaFeignClient;
    private final RealizacaoReceitaFeignClient realizacaoReceitaFeignClient;

    public Page<ReceitaDTO> findReceitasCovid(FindReceitaParams params, Pageable pageable) {
        LocalDate dataInicial = params.getDataInicial().orElse(DateUtils.firstDayOfMonth((int)Month.JANUARY.getValue(), (int)params.getExercicio().intValue()));
        LocalDate dataFinal = params.getDataFinal().orElse(DateUtils.lastDayOfMonth((int)Month.DECEMBER.getValue(), (int)params.getExercicio().intValue()));
        Pageable buildSort = this.buildSort(pageable);
        String buildSearch = this.buildSearch(params);
        EloPage receitas = this.receitaFeignClient.findAllReceitaFonteCovid(dataInicial, dataFinal, buildSearch, buildSort);
        return new PageImpl(receitas.getContent().stream().map(ReceitaDTO::ofReceitaFonteOxy).collect(Collectors.toList()), pageable, receitas.getTotalElements());
    }

    public List<ReceitaDTO> findReceitas(FindReceitaParams params) {
        return this.createReceitaByNivel(params, this.sumValores());
    }

    public List<ReceitaDTO> findReceitasDetalhada(FindReceitaParams params) {
        return this.createReceitaByNivel(params, this.sumValoresDetalhado());
    }

    public List<ReceitaDTO> findReceitasPorFonteRecurso(FindReceitaParams params) {
        List saldos = this.receitaFeignClient.findAllReceitaSaldoLoaded(params.getEntidade(), params.getExercicio(), List.of());
        ArrayList receitasDTO = new ArrayList();
        saldos.forEach(saldo -> {
            ReceitaDTO receita = receitasDTO.stream().filter(r -> r.getReceita().equals(saldo.getFonteRecurso().getCodigo())).findFirst().orElseGet(() -> {
                ReceitaDTO newDTO = new ReceitaDTO();
                newDTO.setReceita(saldo.getFonteRecurso().getCodigo());
                newDTO.setDescricao(saldo.getFonteRecurso().getDescricao());
                receitasDTO.add(newDTO);
                return newDTO;
            });
            this.sumValores().apply(saldo, receita);
        });
        return receitasDTO.stream().sorted(Comparator.comparing(ReceitaDTO::getReceita)).collect(Collectors.toList());
    }

    public List<ReceitaDTO> findDetalheReceitasPorFonteRecurso(FindReceitaParams params) {
        List saldos = this.receitaFeignClient.findAllReceitaSaldoLoaded(params.getEntidade(), params.getExercicio(), List.of());
        ArrayList receitasDTO = new ArrayList();
        saldos.stream().filter(s -> s.getFonteRecurso().getCodigo().equals(((Long)params.getFonteRecurso().get()).toString())).forEach(saldo -> {
            ReceitaDTO receita = receitasDTO.stream().filter(r -> r.getReceita().equals(saldo.getReceita().getFormattedCodigoWithoutZeros())).findFirst().orElseGet(() -> {
                ReceitaDTO newDTO = new ReceitaDTO();
                newDTO.setReceita(saldo.getReceita().getFormattedCodigoWithoutZeros());
                newDTO.setDescricao(saldo.getReceita().getDescricao());
                receitasDTO.add(newDTO);
                return newDTO;
            });
            this.sumValores().apply(saldo, receita);
        });
        return receitasDTO.stream().sorted(Comparator.comparing(ReceitaDTO::getReceita)).collect(Collectors.toList());
    }

    private Pageable buildSort(Pageable pageable) {
        ArrayList orders = new ArrayList();
        if (pageable.getSort().isSorted()) {
            pageable.getSort().toList().forEach(sort -> {
                if (sort.getProperty().equals(RECEITA)) {
                    orders.add((Sort.Order)((BiFunction)ORDERS.get(CODIGO)).apply(sort, RECEITA));
                }
                if (sort.getProperty().equals(DESCRICAO)) {
                    orders.add((Sort.Order)((BiFunction)ORDERS.get(DESCRICAO)).apply(sort, RECEITA_BASE));
                }
                if (sort.getProperty().equals("fonteRecursoRateio")) {
                    orders.add((Sort.Order)((BiFunction)ORDERS.get(CODIGO)).apply(sort, FONTE_RECURSO));
                }
                if (sort.getProperty().equals("descricaoFonte")) {
                    orders.add((Sort.Order)((BiFunction)ORDERS.get(DESCRICAO)).apply(sort, FONTE_RECURSO));
                }
            });
        }
        return PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)Sort.by(orders));
    }

    private String buildSearch(FindReceitaParams params) {
        StringBuilder search = new StringBuilder();
        params.getReceitaLike().ifPresent(r -> search.append((String)((BiFunction)FILTERS.get(CODIGO)).apply(r, ";receita")));
        params.getDescricaoReceita().ifPresent(r -> search.append((String)((BiFunction)FILTERS.get(DESCRICAO)).apply(r, ";receita.receitaBase")));
        params.getFonteRecursoRateio().ifPresent(r -> search.append((String)((BiFunction)FILTERS.get(CODIGO)).apply(r.toString(), ";fonteRecurso")));
        params.getDescricaoFonteRecurso().ifPresent(r -> search.append((String)((BiFunction)FILTERS.get(DESCRICAO)).apply(r, ";fonteRecurso")));
        if (search.toString().isEmpty()) {
            return "";
        }
        return search.toString().substring(1);
    }

    public List<ReceitaDTO> findReceitaValoresDia(FindReceitaParams params) {
        List<ReceitaSaldoLoadedDTO> saldos = this.receitaFeignClient.findAllReceitaSaldoLoaded(params.getEntidade(), params.getExercicio(), List.of()).stream().filter(s -> s.getReceita().getCodigo().startsWith(params.getReceita().orElse(""))).collect(Collectors.toList());
        ArrayList<ReceitaDTO> receitasDTO = new ArrayList<ReceitaDTO>();
        saldos.forEach(saldo -> {
            params.getDataFinal().ifPresent(dataFinal -> saldo.setReceitaSaldoDatas(saldo.getReceitaSaldoDatas().stream().filter(s -> DateUtils.isBeforeOrEquals((LocalDate)s.getData(), (LocalDate)dataFinal)).collect(Collectors.toList())));
            params.getDataInicial().ifPresent(dataInicial -> saldo.setReceitaSaldoDatas(saldo.getReceitaSaldoDatas().stream().filter(s -> DateUtils.isAfterOrEquals((LocalDate)s.getData(), (LocalDate)dataInicial)).collect(Collectors.toList())));
            saldo.getReceitaSaldoDatas().forEach(saldoData -> {
                ReceitaDTO receita = receitasDTO.stream().filter(r -> r.getData().equals(saldoData.getData())).findFirst().orElseGet(() -> {
                    ReceitaDTO newDTO = new ReceitaDTO();
                    newDTO.setData(saldoData.getData());
                    receitasDTO.add(newDTO);
                    return newDTO;
                });
                receita.setValorArrecadado(receita.getValorArrecadado().add(saldoData.getValores().getRealizadoLiquido()));
            });
        });
        receitasDTO.removeIf(r -> r.getValorArrecadado().compareTo(BigDecimal.ZERO) == 0);
        return receitasDTO.stream().sorted(Comparator.comparing(ReceitaDTO::getReceita)).collect(Collectors.toList());
    }

    public List<RealizacaoReceitaDTO> findReceitaValoresRazao(FindReceitaParams params) {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        List realizoesReceitas = this.realizacaoReceitaFeignClient.findAllRealizacaoReceitaByDate(params.getEntidade(), params.getExercicio(), LocalDate.parse(params.getData(), dtf), LocalDate.parse(params.getData(), dtf));
        ArrayList<RealizacaoReceitaDTO> receitasDTO = new ArrayList<RealizacaoReceitaDTO>();
        realizoesReceitas.forEach(r -> r.getItens().stream().filter(rFilter -> rFilter.getReceita().getCodigo().startsWith(params.getReceita().orElse(""))).forEach(item -> {
            RealizacaoReceitaDTO receita = new RealizacaoReceitaDTO();
            receita.setLancamento(r.getEventoLancamento().getId());
            receita.setData(r.getData());
            receita.setDescricao(item.getEventoConfig().getDescricao());
            receita.setBanco(r.getContaBancaria().getAgencia().getBanco().getCodigo());
            receita.setAgencia(r.getContaBancaria().getAgencia().getCodigo());
            receita.setConta(r.getContaBancaria().getConta());
            if (TIPO_OPERACAO_RECEITA.equals(item.getReceita().getTipoOperacaoReceita().getId())) {
                receita.setValor(item.getValor());
            } else {
                receita.setValor(item.getValor().multiply(BigDecimal.valueOf(-1L)));
            }
            receitasDTO.add(receita);
        }));
        return receitasDTO;
    }

    public Optional<ReceitaDTO> findReceita(FindReceitaParams params) {
        ReceitaSaldoLoadedDTO saldo = this.receitaFeignClient.findAllReceitaSaldoLoaded(params.getEntidade(), params.getExercicio(), List.of()).stream().filter(s -> s.getReceita().getCodigo().startsWith(params.getReceita().orElse(""))).findFirst().orElse(new ReceitaSaldoLoadedDTO());
        br.com.elotech.contabilidade.client.dto.ReceitaDTO receiaDTO = Optional.ofNullable(saldo.getReceita()).orElse(new br.com.elotech.contabilidade.client.dto.ReceitaDTO());
        ReceitaDTO newDTO = new ReceitaDTO();
        newDTO.setReceita(receiaDTO.getCodigo());
        newDTO.setDescricao(receiaDTO.getDescricao());
        return Optional.of(newDTO);
    }

    public List<ReceitaDTO> findReceitaValorMes(FindReceitaParams params) {
        List saldos = this.receitaFeignClient.findAllReceitaSaldoLoaded(params.getEntidade(), params.getExercicio(), List.of()).stream().filter(s -> s.getReceita().getCodigo().startsWith(params.getReceita().orElse(""))).collect(Collectors.toList());
        ArrayList<ReceitaDTO> receitasDTO = new ArrayList<ReceitaDTO>();
        saldos.stream().map(ReceitaSaldoLoadedDTO::getReceitaSaldoDatas).flatMap(Collection::stream).filter(receitaSaldoDataDTO -> {
            if (params.getDataInicial().isEmpty() && params.getDataFinal().isEmpty()) {
                return true;
            }
            if (params.getDataInicial().isPresent() && params.getDataFinal().isPresent()) {
                return DateUtils.isBetween((LocalDate)receitaSaldoDataDTO.getData(), (LocalDate)((LocalDate)params.getDataInicial().get()), (LocalDate)((LocalDate)params.getDataFinal().get()));
            }
            if (params.getDataInicial().isPresent()) {
                return DateUtils.isAfterOrEquals((LocalDate)receitaSaldoDataDTO.getData(), (LocalDate)((LocalDate)params.getDataInicial().get()));
            }
            if (params.getDataFinal().isPresent()) {
                return DateUtils.isBeforeOrEquals((LocalDate)receitaSaldoDataDTO.getData(), (LocalDate)((LocalDate)params.getDataFinal().get()));
            }
            return false;
        }).collect(Collectors.groupingBy(receitaSaldoDataDTO -> receitaSaldoDataDTO.getData().getMonthValue())).forEach((mes, receitaSaldoDataDTOS) -> {
            ReceitaDTO receita = receitasDTO.stream().filter(r -> r.getMes().equals(mes)).findFirst().orElseGet(() -> {
                ReceitaDTO newDTO = new ReceitaDTO();
                newDTO.setMes(mes);
                receitasDTO.add(newDTO);
                return newDTO;
            });
            BigDecimal realizadoLiquido = receitaSaldoDataDTOS.stream().map(dto -> dto.getValores().getRealizadoLiquido()).reduce(BigDecimal.ZERO, BigDecimal::add);
            receita.setValorArrecadado(receita.getValorArrecadado().add(realizadoLiquido));
        });
        receitasDTO.removeIf(r -> PrecisionUtils.isDifferentFromZero((BigDecimal)r.getValorArrecadado()) == false);
        return receitasDTO.stream().sorted(Comparator.comparing(ReceitaDTO::getMes)).collect(Collectors.toList());
    }

    private List<ReceitaDTO> createReceitaByNivel(FindReceitaParams params, BiFunction<ReceitaSaldoLoadedDTO, ReceitaDTO, Void> sumValores) {
        List receitasTCE = this.ppaFeignClient.findAllReceitasPadraoByUfAndDataBetweenAndEntidades(PR, DateUtils.firstDayOfMonth((int)Month.JANUARY.getValue(), (int)params.getExercicio().intValue()), DateUtils.lastDayOfMonth((int)Month.DECEMBER.getValue(), (int)params.getExercicio().intValue()), List.of(params.getEntidade()));
        List saldos = this.receitaFeignClient.findAllReceitaSaldoLoaded(params.getEntidade(), params.getExercicio(), List.of());
        ArrayList receitasDTO = new ArrayList();
        saldos.forEach(saldo -> {
            List<String> niveisReceita = Arrays.asList(saldo.getReceita().getFormattedCodigoWithoutZeros().split("\\."));
            StringBuilder codigo = new StringBuilder();
            for (int i = 0; i < niveisReceita.size(); ++i) {
                Long nivelReceita = i + 1;
                codigo.append(niveisReceita.get(i));
                Optional optionalReceitaDTO = receitasDTO.stream().filter(r -> nivelReceita.equals(r.getNivel()) && r.getReceita().startsWith(codigo.toString())).findFirst();
                if (optionalReceitaDTO.isEmpty()) {
                    optionalReceitaDTO = this.getOptionalFromReceitasTCE(receitasDTO, receitasTCE, nivelReceita, codigo);
                }
                optionalReceitaDTO.ifPresent(receitaDTO -> sumValores.apply((ReceitaSaldoLoadedDTO)saldo, (ReceitaDTO)receitaDTO));
            }
        });
        return receitasDTO.stream().sorted(Comparator.comparing(ReceitaDTO::getReceita)).collect(Collectors.toList());
    }

    private Optional<ReceitaDTO> getOptionalFromReceitasTCE(List<ReceitaDTO> receitasDTO, List<ReceitaPadraoTCEDTO> receitasTCE, Long nivelReceita, StringBuilder codigo) {
        Optional<ReceitaPadraoTCEDTO> optionalReceitaPadraoTCE = receitasTCE.stream().filter(tce -> tce.getNivel().equals(nivelReceita) && tce.getCodigo().startsWith(codigo.toString())).findFirst();
        if (optionalReceitaPadraoTCE.isPresent()) {
            ReceitaDTO newDto = ReceitaDTO.ofReceitaTCE((ReceitaPadraoTCEDTO)optionalReceitaPadraoTCE.get(), (String)codigo.toString());
            receitasDTO.add(newDto);
            return Optional.of(newDto);
        }
        return Optional.empty();
    }

    private BiFunction<ReceitaSaldoLoadedDTO, ReceitaDTO, Void> sumValores() {
        return (saldo, receita) -> {
            receita.setValorArrecadado(receita.getValorArrecadado().add(saldo.getValorArrecadado()));
            receita.setValorAtualizado(receita.getValorAtualizado().add(saldo.getValorAtualizado()));
            receita.setValorOrcado(receita.getValorOrcado().add(saldo.getValorOrcado()));
            return null;
        };
    }

    private BiFunction<ReceitaSaldoLoadedDTO, ReceitaDTO, Void> sumValoresDetalhado() {
        return (saldo, receita) -> {
            if (TIPO_OPERACAO_RECEITA.equals(saldo.getReceita().getTipoOperacaoReceita().getId())) {
                receita.setValorOrcado(receita.getValorOrcado().add(saldo.getValorOrcado()));
                receita.setValorAtualizado(receita.getValorAtualizado().add(saldo.getValorAtualizado()));
                receita.setValorArrecadado(receita.getValorArrecadado().add(saldo.getValorArrecadado()));
                receita.setValorRealizadoLiquido(receita.getValorRealizadoLiquido().add(saldo.getValorArrecadado()));
            } else {
                receita.setValorDeducaoInicial(receita.getValorDeducaoInicial().add(saldo.getValorOrcado()));
                receita.setValorAtualizado(receita.getValorAtualizado().subtract(saldo.getValorAtualizado()));
                receita.setValorDeducao(receita.getValorDeducao().add(saldo.getValorArrecadado()));
                receita.setValorRealizadoLiquido(receita.getValorRealizadoLiquido().add(saldo.getValorArrecadado()));
            }
            return null;
        };
    }

    public Page<ReceitaDTO> findReceitasFundeb(FindReceitaParams params, Pageable pageable) {
        return null;
    }

    public List<ReceitaFiltroDTO> findReceitaFiltro(FindReceitaParams params) {
        return null;
    }

    @Generated
    public ReceitaOxyRepositoryImpl(PPAFeignClient ppaFeignClient, ReceitaFeignClient receitaFeignClient, RealizacaoReceitaFeignClient realizacaoReceitaFeignClient) {
        this.ppaFeignClient = ppaFeignClient;
        this.receitaFeignClient = receitaFeignClient;
        this.realizacaoReceitaFeignClient = realizacaoReceitaFeignClient;
    }

    static {
        ORDERS.put(CODIGO, (sort, prefix) -> new Sort.Order(sort.getDirection(), prefix + ".codigo"));
        ORDERS.put(DESCRICAO, (sort, prefix) -> new Sort.Order(sort.getDirection(), prefix + ".descricao"));
        FILTERS.put(CODIGO, (filter, prefix) -> prefix + ".codigo=='*" + filter + "*'");
        FILTERS.put(DESCRICAO, (filter, prefix) -> prefix + ".descricao=='*" + filter + "*'");
    }
}

