/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.resource.params;

import br.com.elotech.multitenant.filter.TenantContextHolder;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.ArrecadacaoParams;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

public class ArrecadacaoParams {
    private Long entidade;
    private Long exercicio;
    private String receitas;
    private String receita;
    private String guiasRecolhimento;
    private String bairro;
    private String logradouro;
    private String tenant = TenantContextHolder.getTenantId().orElse(null);

    public Optional<String> getLogradouro() {
        return Optional.ofNullable(this.logradouro);
    }

    public MapSqlParameterSource toJdbcParameter() {
        MapSqlParameterSource params = new MapSqlParameterSource();
        this.addEntidade(params);
        this.addExercicio(params);
        this.addReceitas(params);
        this.addGuiasRecolhimento(params);
        this.addReceita(params);
        this.addBairro(params);
        return params;
    }

    private void addEntidade(MapSqlParameterSource params) {
        if (Objects.nonNull(this.entidade)) {
            params.addValue("entidade", (Object)this.entidade, 2);
        }
    }

    private void addExercicio(MapSqlParameterSource params) {
        if (Objects.nonNull(this.exercicio)) {
            params.addValue("exercicio", (Object)this.exercicio, 2);
        }
    }

    private void addReceitas(MapSqlParameterSource params) {
        if (Objects.nonNull(this.receitas)) {
            List listReceitas = Stream.of(this.receitas.split(",")).map(String::trim).collect(Collectors.toList());
            params.addValue("receitas", listReceitas);
        }
    }

    private void addGuiasRecolhimento(MapSqlParameterSource params) {
        if (Objects.nonNull(this.guiasRecolhimento)) {
            List guias = Stream.of(this.guiasRecolhimento.split(",")).map(String::trim).map(Long::parseLong).collect(Collectors.toList());
            params.addValue("guiasRecolhimento", guias);
        }
    }

    private void addReceita(MapSqlParameterSource params) {
        if (Objects.nonNull(this.receita)) {
            params.addValue("receita", (Object)this.receita, 12);
        }
    }

    private void addBairro(MapSqlParameterSource params) {
        if (Objects.nonNull(this.bairro)) {
            params.addValue("bairro", (Object)this.bairro, 12);
        }
    }

    @Generated
    public static ArrecadacaoParamsBuilder builder() {
        return new ArrecadacaoParamsBuilder();
    }

    @Generated
    public String toString() {
        return "ArrecadacaoParams(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", receitas=" + this.getReceitas() + ", receita=" + this.getReceita() + ", guiasRecolhimento=" + this.getGuiasRecolhimento() + ", bairro=" + this.getBairro() + ", logradouro=" + this.getLogradouro() + ", tenant=" + this.getTenant() + ")";
    }

    @Generated
    public ArrecadacaoParams() {
    }

    @Generated
    public ArrecadacaoParams(Long entidade, Long exercicio, String receitas, String receita, String guiasRecolhimento, String bairro, String logradouro, String tenant) {
        this.entidade = entidade;
        this.exercicio = exercicio;
        this.receitas = receitas;
        this.receita = receita;
        this.guiasRecolhimento = guiasRecolhimento;
        this.bairro = bairro;
        this.logradouro = logradouro;
        this.tenant = tenant;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public String getReceitas() {
        return this.receitas;
    }

    @Generated
    public String getReceita() {
        return this.receita;
    }

    @Generated
    public String getGuiasRecolhimento() {
        return this.guiasRecolhimento;
    }

    @Generated
    public String getBairro() {
        return this.bairro;
    }

    @Generated
    public String getTenant() {
        return this.tenant;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setReceitas(String receitas) {
        this.receitas = receitas;
    }

    @Generated
    public void setReceita(String receita) {
        this.receita = receita;
    }

    @Generated
    public void setGuiasRecolhimento(String guiasRecolhimento) {
        this.guiasRecolhimento = guiasRecolhimento;
    }

    @Generated
    public void setBairro(String bairro) {
        this.bairro = bairro;
    }

    @Generated
    public void setLogradouro(String logradouro) {
        this.logradouro = logradouro;
    }

    @Generated
    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArrecadacaoParams)) {
            return false;
        }
        ArrecadacaoParams other = (ArrecadacaoParams)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        String this$receitas = this.getReceitas();
        String other$receitas = other.getReceitas();
        if (this$receitas == null ? other$receitas != null : !this$receitas.equals(other$receitas)) {
            return false;
        }
        String this$receita = this.getReceita();
        String other$receita = other.getReceita();
        if (this$receita == null ? other$receita != null : !this$receita.equals(other$receita)) {
            return false;
        }
        String this$guiasRecolhimento = this.getGuiasRecolhimento();
        String other$guiasRecolhimento = other.getGuiasRecolhimento();
        if (this$guiasRecolhimento == null ? other$guiasRecolhimento != null : !this$guiasRecolhimento.equals(other$guiasRecolhimento)) {
            return false;
        }
        String this$bairro = this.getBairro();
        String other$bairro = other.getBairro();
        if (this$bairro == null ? other$bairro != null : !this$bairro.equals(other$bairro)) {
            return false;
        }
        Optional this$logradouro = this.getLogradouro();
        Optional other$logradouro = other.getLogradouro();
        if (this$logradouro == null ? other$logradouro != null : !((Object)this$logradouro).equals(other$logradouro)) {
            return false;
        }
        String this$tenant = this.getTenant();
        String other$tenant = other.getTenant();
        return !(this$tenant == null ? other$tenant != null : !this$tenant.equals(other$tenant));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ArrecadacaoParams;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        String $receitas = this.getReceitas();
        result = result * 59 + ($receitas == null ? 43 : $receitas.hashCode());
        String $receita = this.getReceita();
        result = result * 59 + ($receita == null ? 43 : $receita.hashCode());
        String $guiasRecolhimento = this.getGuiasRecolhimento();
        result = result * 59 + ($guiasRecolhimento == null ? 43 : $guiasRecolhimento.hashCode());
        String $bairro = this.getBairro();
        result = result * 59 + ($bairro == null ? 43 : $bairro.hashCode());
        Optional $logradouro = this.getLogradouro();
        result = result * 59 + ($logradouro == null ? 43 : ((Object)$logradouro).hashCode());
        String $tenant = this.getTenant();
        result = result * 59 + ($tenant == null ? 43 : $tenant.hashCode());
        return result;
    }
}

