/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.admportal.resource;

import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.portaltransparencia.admportal.service.OrganogramaAdminService;
import br.com.elotech.portaltransparencia.contabportal.domain.PortalOrganograma;
import java.io.IOException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/admin/organogramas"})
public class OrganogramaAdminResource
extends CrudResource<PortalOrganograma, Long> {
    public OrganogramaAdminService getService() {
        return (OrganogramaAdminService)super.getService();
    }

    @GetMapping(params={"entidade"})
    public ResponseEntity<Page<PortalOrganograma>> findOrganogramaPaginado(@RequestParam(value="entidade", required=true) Long entidade, Pageable pageable) {
        Page organogramasPage = this.getService().findByAllByEntidade(entidade, pageable);
        return ResponseEntity.ok((Object)organogramasPage);
    }

    @PostMapping(value={"/{id}/arquivo"})
    public ResponseEntity<PortalOrganograma> salvarArquivo(@PathVariable(name="id") Long id, @RequestParam(value="files") MultipartFile file) throws IOException {
        return ResponseEntity.ok((Object)this.getService().adicionarArquivo(id, file));
    }

    @DeleteMapping(value={"/{id}/arquivo"})
    public ResponseEntity<PortalOrganograma> deletarArquivo(@PathVariable(name="id") Long id) {
        return ResponseEntity.ok((Object)this.getService().removerArquivo(id));
    }
}

