SELECT EX.MES, 
   (SELECT COALESCE(SUM(CASE WHEN R.GRUPOEVENTO IN (11,14) THEN RI.VALOR ELSE RI.VALOR * (-1) END),0) 
	  FROM REALIZACAORECEITA R
	  JOIN REALIZACAORECEITAITEM RI
	    ON RI.ENTIDADE = R.ENTIDADE
	   AND RI.EXERCICIO = R.EXERCICIO
	   AND RI.LANCAMENTO = R.LANCAMENTO
	  JOIN FONTERECURSO FONTE 
	    ON FONTE.FONTERECURSO = RI.FONTERECURSO 
	  LEFT JOIN ${db.contabilidade.schema}.FONTERECURSOPADRAO FRP
	    ON FONTE.CODIGOFONTEPADRAO = FRP.CODIGO
	 WHERE R.ENTIDADE = EX.ENTIDADE
	   AND R.EXERCICIO = EX.EXERCICIO
       and EXTRACT(MONTH FROM R.DATA) = EX.MES
   	   AND R.DATA <= :diasRetroativo 
  	   $[FILTRO]) AS VALORARRECADADO,
	(SELECT COALESCE(SUM(FICHA.VALOR - FICHA.VALORANULACOES + FICHA.VALORESTANULACOES),0)
       FROM ${db.contabilidade.schema}.FICHAEMPENHO FICHA, ${db.contabilidade.schema}.EMPENHO E, 
       		${db.contabilidade.schema}.FONTERECURSO FONTE, ${db.contabilidade.schema}.FONTERECURSOPADRAO FRP
	  WHERE E.ENTIDADE = FICHA.ENTIDADE
		AND E.EXERCICIO = FICHA.EXERCICIO
		AND E.EMPENHO = FICHA.EMPENHO
		AND E.UNIDADEORCAMENTARIA = FICHA.UNIDADEORCAMENTARIA
		AND FICHA.DATA <= :diasRetroativo
        AND FICHA.ENTIDADE = EX.ENTIDADE
		AND FICHA.EXERCICIO = EX.EXERCICIO
        AND EXTRACT(MONTH FROM FICHA.DATA) = EX.MES
        AND FONTE.FONTERECURSO = E.FONTERECURSO
        and FRP.codigo = FONTE.codigofontepadrao
        $[FILTRO]) AS VALOREMPENHADO,  
    (SELECT COALESCE(SUM(FICHA.VALORLIQUIDACOES - FICHA.VALORESTLIQUIDACOES),0)
       FROM ${db.contabilidade.schema}.FICHAEMPENHO FICHA, ${db.contabilidade.schema}.EMPENHO E, 
       		${db.contabilidade.schema}.FONTERECURSO FONTE, ${db.contabilidade.schema}.FONTERECURSOPADRAO FRP
	  WHERE E.ENTIDADE = FICHA.ENTIDADE
		AND E.EXERCICIO = FICHA.EXERCICIO
		AND E.EMPENHO = FICHA.EMPENHO
		AND E.UNIDADEORCAMENTARIA = FICHA.UNIDADEORCAMENTARIA
		AND FICHA.DATA <= :diasRetroativo
        AND FICHA.ENTIDADE = EX.ENTIDADE
		AND FICHA.EXERCICIO = EX.EXERCICIO
        AND EXTRACT(MONTH FROM FICHA.DATA) = EX.MES
        AND FONTE.FONTERECURSO = E.FONTERECURSO
        and FRP.codigo = FONTE.codigofontepadrao
        $[FILTRO]) AS VALORLIQUIDADO,
	(SELECT COALESCE(SUM(FICHA.VALORPAGAMENTO - FICHA.VALORESTPAGAMENTO),0)
       FROM ${db.contabilidade.schema}.FICHAEMPENHO FICHA, ${db.contabilidade.schema}.EMPENHO E, 
       		${db.contabilidade.schema}.FONTERECURSO FONTE, ${db.contabilidade.schema}.FONTERECURSOPADRAO FRP
	  WHERE E.ENTIDADE = FICHA.ENTIDADE
		AND E.EXERCICIO = FICHA.EXERCICIO
		AND E.EMPENHO = FICHA.EMPENHO
		AND E.UNIDADEORCAMENTARIA = FICHA.UNIDADEORCAMENTARIA
		AND FICHA.DATA <= :diasRetroativo
        AND FICHA.ENTIDADE = EX.ENTIDADE
		AND FICHA.EXERCICIO = EX.EXERCICIO
        AND EXTRACT(MONTH FROM FICHA.DATA) = EX.MES
        AND FONTE.FONTERECURSO = E.FONTERECURSO
        and FRP.codigo = FONTE.codigofontepadrao
        $[FILTRO]) AS VALORPAGO
 FROM ${db.contabilidade.schema}.EXERCICIO_MES EX
 WHERE EX.EXERCICIO = :exercicio