SELECT EX.MES, 
   (SELECT COALESCE(SUM(RD.VALORARRECADADO-RD.VALORESTARRECADADO-RD.VALORDEVOLUCAO+RD.VALORESTDEVOLUCAO),0) 
           FROM ${db.contabilidade.schema}.RECEITADIARIA RD
           LEFT OUTER JOIN ${db.contabilidade.schema}.RECEITA R
             ON RD.ENTIDADE = R.ENTIDADE 
            AND RD.EXERCICIO = R.EXERCICIO 
            AND RD.RECEITA = R.RECEITA 
            AND RD.FONTERECURSO = R.FONTERECURSO 
            AND RD.IDTIPOOPERACAORECEITA = R.IDTIPOOPERACAORECEITA
           WHERE EX.ENTIDADE = RD.ENTIDADE 
             AND EX.EXERCICIO = RD.EXERCICIO 
             AND EX.MES = EXTRACT(MONTH FROM RD.DATA) 
             AND RD.DATA <= :diasRetroativo
             AND R.MOVSN = 'S') AS VALORARRECADADO,
   (SELECT COALESCE(SUM(CASE WHEN C.DEBCRED = 'C' THEN C.VALOR ELSE C.VALOR * -1 END), 0) 
	FROM ELOPORTALREPASSES A
	LEFT OUTER JOIN ${db.contabilidade.schema}.EVENTOSLANCADOSCONTA C
		ON C.ENTIDADE = A.ENTIDADE 
		AND C.EXERCICIO = A.EXERCICIO 
		AND C.CONTA = A.CONTA 
	LEFT OUTER JOIN ${db.contabilidade.schema}.EVENTOSLANCADOS B
		ON B.ENTIDADE = C.ENTIDADE 
		AND B.EXERCICIO = C.EXERCICIO 
		AND B.TIPOEVENTO = C.TIPOEVENTO 
		AND B.GRUPOEVENTO = C.GRUPOEVENTO 
		AND B.EVENTO = C.EVENTO 
		AND B.NROLANCAMENTO = C.NROLANCAMENTO 
	WHERE A.ENTIDADE = EX.ENTIDADE
	  AND A.EXERCICIO = EX.EXERCICIO
	  AND A.TIPO  = 'R'
	  AND C.GRUPOEVENTO NOT IN (80,81,85,86) 
	  AND EXTRACT(MONTH FROM B.DATA) = EX.MES) AS REPASSERECEBIDO,             
   (SELECT COALESCE(SUM(DD.VALOREMPENHO-DD.VALORANULACAOEMPENHO+DD.VALORESTANULACAOEMPENHO),0) 
           FROM ${db.contabilidade.schema}.DESPESADIARIA DD
           LEFT OUTER JOIN ${db.contabilidade.schema}.DESPESA D
             ON DD.ENTIDADE = D.ENTIDADE 
            AND DD.EXERCICIO = D.EXERCICIO 
            AND DD.PROGRAMATICA = D.PROGRAMATICA 
            AND DD.FONTERECURSO = D.FONTERECURSO 
           WHERE EX.ENTIDADE = DD.ENTIDADE 
             AND EX.EXERCICIO = DD.EXERCICIO 
             AND EX.MES = EXTRACT(MONTH FROM DD.DATA) 
             AND DD.DATA <= :diasRetroativo
             AND D.MOVSN = 'S')
             AS VALOREMPENHADO,
   (SELECT COALESCE(SUM(CASE WHEN C.DEBCRED = 'D' THEN C.VALOR ELSE C.VALOR * -1 END), 0) 
	FROM ELOPORTALREPASSES A
	LEFT OUTER JOIN ${db.contabilidade.schema}.EVENTOSLANCADOSCONTA C
		ON C.ENTIDADE = A.ENTIDADE 
		AND C.EXERCICIO = A.EXERCICIO 
		AND C.CONTA = A.CONTA 
	LEFT OUTER JOIN ${db.contabilidade.schema}.EVENTOSLANCADOS B
		ON B.ENTIDADE = C.ENTIDADE 
		AND B.EXERCICIO = C.EXERCICIO 
		AND B.TIPOEVENTO = C.TIPOEVENTO 
		AND B.GRUPOEVENTO = C.GRUPOEVENTO 
		AND B.EVENTO = C.EVENTO 
		AND B.NROLANCAMENTO = C.NROLANCAMENTO 
	WHERE A.ENTIDADE = EX.ENTIDADE
	  AND A.EXERCICIO = EX.EXERCICIO
	  AND A.TIPO  = 'E'
	  AND C.GRUPOEVENTO NOT IN (80,81,85,86) 
	  AND EXTRACT(MONTH FROM B.DATA) = EX.MES) AS REPASSECONCEDIDO,
   (SELECT COALESCE(SUM(DD.VALORPAGAMENTO - DD.VALORESTPAGAMENTO),0)
      FROM ${db.contabilidade.schema}.DESPESADIARIA DD
      LEFT OUTER JOIN ${db.contabilidade.schema}.DESPESA D
        ON DD.ENTIDADE     = D.ENTIDADE
       AND DD.EXERCICIO    = D.EXERCICIO
       AND DD.PROGRAMATICA = D.PROGRAMATICA
       AND DD.FONTERECURSO = D.FONTERECURSO
    WHERE EX.ENTIDADE  = DD.ENTIDADE
      AND EX.EXERCICIO = DD.EXERCICIO
      AND EX.MES       = EXTRACT(MONTH FROM DD.DATA)
      AND DD.DATA     <= :diasRetroativo
      AND D.MOVSN = 'S'
   ) AS VALORPAGO,
   (SELECT COALESCE(SUM(DD.VALORLIQUIDACAO - DD.VALORESTLIQUIDACAO),0)
      FROM ${db.contabilidade.schema}.DESPESADIARIA DD
      LEFT OUTER JOIN ${db.contabilidade.schema}.DESPESA D
        ON DD.ENTIDADE     = D.ENTIDADE
       AND DD.EXERCICIO    = D.EXERCICIO
       AND DD.PROGRAMATICA = D.PROGRAMATICA
       AND DD.FONTERECURSO = D.FONTERECURSO
     WHERE EX.ENTIDADE  = DD.ENTIDADE
       AND EX.EXERCICIO = DD.EXERCICIO
       AND EX.MES       = EXTRACT(MONTH FROM DD.DATA)
       AND DD.DATA     <= :diasRetroativo
       AND D.MOVSN = 'S'
   ) AS VALORLIQUIDADO
 FROM ${db.contabilidade.schema}.EXERCICIO_MES EX
 WHERE EX.ENTIDADE = :entidade
 AND EX.EXERCICIO = :exercicio
 ORDER BY EX.MES
