/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource.params;

import br.com.elotech.portaltransparencia.contabportal.resource.params.SubvencaoParams;
import java.sql.Date;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

public class SubvencaoParams {
    private Optional<Long> subvencaoId;
    private Long entidade;
    private Long exercicio;
    private Long subvencao;
    private Long anoSubvencao;
    private Long tipo;
    private String cnpj;
    private String nomeBeneficiario;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    private LocalDate dataAssinatura;
    private String objeto;
    private String exportType;
    private String chaveAutenticacao;

    public MapSqlParameterSource toJdbcParameter() {
        MapSqlParameterSource params = new MapSqlParameterSource();
        this.addEntidade(params);
        this.addExercicio(params);
        this.addSubvencao(params);
        this.addAnoSubvencao(params);
        this.addTipo(params);
        this.addCnpj(params);
        this.addNomeOrganizacao(params);
        this.addDataAssinatura(params);
        this.addObjeto(params);
        this.addChaveAutenticacao(params);
        return params;
    }

    private void addEntidade(MapSqlParameterSource params) {
        if (Objects.nonNull(this.entidade)) {
            params.addValue("entidade", (Object)this.entidade, 2);
        }
    }

    private void addExercicio(MapSqlParameterSource params) {
        if (Objects.nonNull(this.exercicio)) {
            params.addValue("exercicio", (Object)this.exercicio, 2);
        }
    }

    private void addSubvencao(MapSqlParameterSource params) {
        if (Objects.nonNull(this.subvencao)) {
            params.addValue("subvencao", (Object)this.subvencao, 2);
        }
    }

    private void addAnoSubvencao(MapSqlParameterSource params) {
        if (Objects.nonNull(this.anoSubvencao)) {
            params.addValue("anoSubvencao", (Object)this.anoSubvencao, 2);
        }
    }

    private void addTipo(MapSqlParameterSource params) {
        if (Objects.nonNull(this.tipo)) {
            params.addValue("tipo", (Object)this.tipo, 2);
        }
    }

    private void addCnpj(MapSqlParameterSource params) {
        if (Objects.nonNull(this.cnpj)) {
            params.addValue("cnpj", (Object)this.cnpj, 12);
        }
    }

    private void addNomeOrganizacao(MapSqlParameterSource params) {
        if (Objects.nonNull(this.nomeBeneficiario)) {
            params.addValue("nomeBeneficiario", (Object)this.nomeBeneficiario, 12);
        }
    }

    private void addDataAssinatura(MapSqlParameterSource params) {
        if (Objects.nonNull(this.dataAssinatura)) {
            params.addValue("dataAssinatura", (Object)Date.valueOf(this.dataAssinatura), 91);
        }
    }

    private void addObjeto(MapSqlParameterSource params) {
        if (Objects.nonNull(this.objeto)) {
            params.addValue("objeto", (Object)this.objeto, 12);
        }
    }

    private void addChaveAutenticacao(MapSqlParameterSource params) {
        if (Objects.nonNull(this.chaveAutenticacao)) {
            params.addValue("chaveAutenticacao", (Object)this.chaveAutenticacao, 12);
        }
    }

    @Generated
    public static SubvencaoParamsBuilder builder() {
        return new SubvencaoParamsBuilder();
    }

    @Generated
    public Optional<Long> getSubvencaoId() {
        return this.subvencaoId;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getSubvencao() {
        return this.subvencao;
    }

    @Generated
    public Long getAnoSubvencao() {
        return this.anoSubvencao;
    }

    @Generated
    public Long getTipo() {
        return this.tipo;
    }

    @Generated
    public String getCnpj() {
        return this.cnpj;
    }

    @Generated
    public String getNomeBeneficiario() {
        return this.nomeBeneficiario;
    }

    @Generated
    public LocalDate getDataAssinatura() {
        return this.dataAssinatura;
    }

    @Generated
    public String getObjeto() {
        return this.objeto;
    }

    @Generated
    public String getExportType() {
        return this.exportType;
    }

    @Generated
    public String getChaveAutenticacao() {
        return this.chaveAutenticacao;
    }

    @Generated
    public void setSubvencaoId(Optional<Long> subvencaoId) {
        this.subvencaoId = subvencaoId;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setSubvencao(Long subvencao) {
        this.subvencao = subvencao;
    }

    @Generated
    public void setAnoSubvencao(Long anoSubvencao) {
        this.anoSubvencao = anoSubvencao;
    }

    @Generated
    public void setTipo(Long tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setCnpj(String cnpj) {
        this.cnpj = cnpj;
    }

    @Generated
    public void setNomeBeneficiario(String nomeBeneficiario) {
        this.nomeBeneficiario = nomeBeneficiario;
    }

    @Generated
    public void setDataAssinatura(LocalDate dataAssinatura) {
        this.dataAssinatura = dataAssinatura;
    }

    @Generated
    public void setObjeto(String objeto) {
        this.objeto = objeto;
    }

    @Generated
    public void setExportType(String exportType) {
        this.exportType = exportType;
    }

    @Generated
    public void setChaveAutenticacao(String chaveAutenticacao) {
        this.chaveAutenticacao = chaveAutenticacao;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubvencaoParams)) {
            return false;
        }
        SubvencaoParams other = (SubvencaoParams)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$subvencao = this.getSubvencao();
        Long other$subvencao = other.getSubvencao();
        if (this$subvencao == null ? other$subvencao != null : !((Object)this$subvencao).equals(other$subvencao)) {
            return false;
        }
        Long this$anoSubvencao = this.getAnoSubvencao();
        Long other$anoSubvencao = other.getAnoSubvencao();
        if (this$anoSubvencao == null ? other$anoSubvencao != null : !((Object)this$anoSubvencao).equals(other$anoSubvencao)) {
            return false;
        }
        Long this$tipo = this.getTipo();
        Long other$tipo = other.getTipo();
        if (this$tipo == null ? other$tipo != null : !((Object)this$tipo).equals(other$tipo)) {
            return false;
        }
        Optional this$subvencaoId = this.getSubvencaoId();
        Optional other$subvencaoId = other.getSubvencaoId();
        if (this$subvencaoId == null ? other$subvencaoId != null : !((Object)this$subvencaoId).equals(other$subvencaoId)) {
            return false;
        }
        String this$cnpj = this.getCnpj();
        String other$cnpj = other.getCnpj();
        if (this$cnpj == null ? other$cnpj != null : !this$cnpj.equals(other$cnpj)) {
            return false;
        }
        String this$nomeBeneficiario = this.getNomeBeneficiario();
        String other$nomeBeneficiario = other.getNomeBeneficiario();
        if (this$nomeBeneficiario == null ? other$nomeBeneficiario != null : !this$nomeBeneficiario.equals(other$nomeBeneficiario)) {
            return false;
        }
        LocalDate this$dataAssinatura = this.getDataAssinatura();
        LocalDate other$dataAssinatura = other.getDataAssinatura();
        if (this$dataAssinatura == null ? other$dataAssinatura != null : !((Object)this$dataAssinatura).equals(other$dataAssinatura)) {
            return false;
        }
        String this$objeto = this.getObjeto();
        String other$objeto = other.getObjeto();
        if (this$objeto == null ? other$objeto != null : !this$objeto.equals(other$objeto)) {
            return false;
        }
        String this$exportType = this.getExportType();
        String other$exportType = other.getExportType();
        if (this$exportType == null ? other$exportType != null : !this$exportType.equals(other$exportType)) {
            return false;
        }
        String this$chaveAutenticacao = this.getChaveAutenticacao();
        String other$chaveAutenticacao = other.getChaveAutenticacao();
        return !(this$chaveAutenticacao == null ? other$chaveAutenticacao != null : !this$chaveAutenticacao.equals(other$chaveAutenticacao));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SubvencaoParams;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $subvencao = this.getSubvencao();
        result = result * 59 + ($subvencao == null ? 43 : ((Object)$subvencao).hashCode());
        Long $anoSubvencao = this.getAnoSubvencao();
        result = result * 59 + ($anoSubvencao == null ? 43 : ((Object)$anoSubvencao).hashCode());
        Long $tipo = this.getTipo();
        result = result * 59 + ($tipo == null ? 43 : ((Object)$tipo).hashCode());
        Optional $subvencaoId = this.getSubvencaoId();
        result = result * 59 + ($subvencaoId == null ? 43 : ((Object)$subvencaoId).hashCode());
        String $cnpj = this.getCnpj();
        result = result * 59 + ($cnpj == null ? 43 : $cnpj.hashCode());
        String $nomeBeneficiario = this.getNomeBeneficiario();
        result = result * 59 + ($nomeBeneficiario == null ? 43 : $nomeBeneficiario.hashCode());
        LocalDate $dataAssinatura = this.getDataAssinatura();
        result = result * 59 + ($dataAssinatura == null ? 43 : ((Object)$dataAssinatura).hashCode());
        String $objeto = this.getObjeto();
        result = result * 59 + ($objeto == null ? 43 : $objeto.hashCode());
        String $exportType = this.getExportType();
        result = result * 59 + ($exportType == null ? 43 : $exportType.hashCode());
        String $chaveAutenticacao = this.getChaveAutenticacao();
        result = result * 59 + ($chaveAutenticacao == null ? 43 : $chaveAutenticacao.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SubvencaoParams(subvencaoId=" + this.getSubvencaoId() + ", entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", subvencao=" + this.getSubvencao() + ", anoSubvencao=" + this.getAnoSubvencao() + ", tipo=" + this.getTipo() + ", cnpj=" + this.getCnpj() + ", nomeBeneficiario=" + this.getNomeBeneficiario() + ", dataAssinatura=" + this.getDataAssinatura() + ", objeto=" + this.getObjeto() + ", exportType=" + this.getExportType() + ", chaveAutenticacao=" + this.getChaveAutenticacao() + ")";
    }

    @Generated
    public SubvencaoParams() {
    }

    @Generated
    public SubvencaoParams(Optional<Long> subvencaoId, Long entidade, Long exercicio, Long subvencao, Long anoSubvencao, Long tipo, String cnpj, String nomeBeneficiario, LocalDate dataAssinatura, String objeto, String exportType, String chaveAutenticacao) {
        this.subvencaoId = subvencaoId;
        this.entidade = entidade;
        this.exercicio = exercicio;
        this.subvencao = subvencao;
        this.anoSubvencao = anoSubvencao;
        this.tipo = tipo;
        this.cnpj = cnpj;
        this.nomeBeneficiario = nomeBeneficiario;
        this.dataAssinatura = dataAssinatura;
        this.objeto = objeto;
        this.exportType = exportType;
        this.chaveAutenticacao = chaveAutenticacao;
    }
}

