/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.domain.dto;

import br.com.elotech.atos.client.dto.ConvenioAnexoDTO;
import br.com.elotech.orcamento.client.dto.AudienciaPublicaAnexoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ArquivoDTO;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.time.LocalDate;
import java.util.Arrays;
import lombok.Generated;

public class ArquivoDTO {
    private Long id;
    private String nomeArquivo;
    private String extensao;
    private String link;
    private byte[] arquivoFisico;
    private Long tamanhoArquivo;
    private LocalDate dataArquivo;
    private String ativo;
    private LocalDate dataValidade;

    @JsonSetter
    public void setArquivoFisico(byte[] binary) {
        this.arquivoFisico = binary;
    }

    @JsonIgnore
    public byte[] getArquivoFisico() {
        return this.arquivoFisico;
    }

    @JsonIgnore
    public String getExtensaoNomeArquivo() {
        return this.nomeArquivo.substring(this.nomeArquivo.lastIndexOf(46), this.nomeArquivo.length());
    }

    public static ArquivoDTO ofConvenioAnexo(ConvenioAnexoDTO anexo) {
        ArquivoDTO arquivo = new ArquivoDTO();
        arquivo.setNomeArquivo(anexo.getFile().getFileNameFormated());
        arquivo.setArquivoFisico(anexo.getFile().getFile());
        arquivo.setLink(anexo.getLink());
        arquivo.setId(anexo.getId());
        arquivo.setDataArquivo(anexo.getDataPublicacao());
        return arquivo;
    }

    public static ArquivoDTO ofAudienciaPublicaAnexo(AudienciaPublicaAnexoDTO anexo) {
        ArquivoDTO arquivo = new ArquivoDTO();
        arquivo.setNomeArquivo(anexo.getFile().getFileNameFormated());
        arquivo.setArquivoFisico(anexo.getFile().getFile());
        return arquivo;
    }

    @Generated
    public static ArquivoDTOBuilder builder() {
        return new ArquivoDTOBuilder();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getNomeArquivo() {
        return this.nomeArquivo;
    }

    @Generated
    public String getExtensao() {
        return this.extensao;
    }

    @Generated
    public String getLink() {
        return this.link;
    }

    @Generated
    public Long getTamanhoArquivo() {
        return this.tamanhoArquivo;
    }

    @Generated
    public LocalDate getDataArquivo() {
        return this.dataArquivo;
    }

    @Generated
    public String getAtivo() {
        return this.ativo;
    }

    @Generated
    public LocalDate getDataValidade() {
        return this.dataValidade;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setNomeArquivo(String nomeArquivo) {
        this.nomeArquivo = nomeArquivo;
    }

    @Generated
    public void setExtensao(String extensao) {
        this.extensao = extensao;
    }

    @Generated
    public void setLink(String link) {
        this.link = link;
    }

    @Generated
    public void setTamanhoArquivo(Long tamanhoArquivo) {
        this.tamanhoArquivo = tamanhoArquivo;
    }

    @Generated
    public void setDataArquivo(LocalDate dataArquivo) {
        this.dataArquivo = dataArquivo;
    }

    @Generated
    public void setAtivo(String ativo) {
        this.ativo = ativo;
    }

    @Generated
    public void setDataValidade(LocalDate dataValidade) {
        this.dataValidade = dataValidade;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArquivoDTO)) {
            return false;
        }
        ArquivoDTO other = (ArquivoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$tamanhoArquivo = this.getTamanhoArquivo();
        Long other$tamanhoArquivo = other.getTamanhoArquivo();
        if (this$tamanhoArquivo == null ? other$tamanhoArquivo != null : !((Object)this$tamanhoArquivo).equals(other$tamanhoArquivo)) {
            return false;
        }
        String this$nomeArquivo = this.getNomeArquivo();
        String other$nomeArquivo = other.getNomeArquivo();
        if (this$nomeArquivo == null ? other$nomeArquivo != null : !this$nomeArquivo.equals(other$nomeArquivo)) {
            return false;
        }
        String this$extensao = this.getExtensao();
        String other$extensao = other.getExtensao();
        if (this$extensao == null ? other$extensao != null : !this$extensao.equals(other$extensao)) {
            return false;
        }
        String this$link = this.getLink();
        String other$link = other.getLink();
        if (this$link == null ? other$link != null : !this$link.equals(other$link)) {
            return false;
        }
        if (!Arrays.equals(this.getArquivoFisico(), other.getArquivoFisico())) {
            return false;
        }
        LocalDate this$dataArquivo = this.getDataArquivo();
        LocalDate other$dataArquivo = other.getDataArquivo();
        if (this$dataArquivo == null ? other$dataArquivo != null : !((Object)this$dataArquivo).equals(other$dataArquivo)) {
            return false;
        }
        String this$ativo = this.getAtivo();
        String other$ativo = other.getAtivo();
        if (this$ativo == null ? other$ativo != null : !this$ativo.equals(other$ativo)) {
            return false;
        }
        LocalDate this$dataValidade = this.getDataValidade();
        LocalDate other$dataValidade = other.getDataValidade();
        return !(this$dataValidade == null ? other$dataValidade != null : !((Object)this$dataValidade).equals(other$dataValidade));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ArquivoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $tamanhoArquivo = this.getTamanhoArquivo();
        result = result * 59 + ($tamanhoArquivo == null ? 43 : ((Object)$tamanhoArquivo).hashCode());
        String $nomeArquivo = this.getNomeArquivo();
        result = result * 59 + ($nomeArquivo == null ? 43 : $nomeArquivo.hashCode());
        String $extensao = this.getExtensao();
        result = result * 59 + ($extensao == null ? 43 : $extensao.hashCode());
        String $link = this.getLink();
        result = result * 59 + ($link == null ? 43 : $link.hashCode());
        result = result * 59 + Arrays.hashCode(this.getArquivoFisico());
        LocalDate $dataArquivo = this.getDataArquivo();
        result = result * 59 + ($dataArquivo == null ? 43 : ((Object)$dataArquivo).hashCode());
        String $ativo = this.getAtivo();
        result = result * 59 + ($ativo == null ? 43 : $ativo.hashCode());
        LocalDate $dataValidade = this.getDataValidade();
        result = result * 59 + ($dataValidade == null ? 43 : ((Object)$dataValidade).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ArquivoDTO(id=" + this.getId() + ", nomeArquivo=" + this.getNomeArquivo() + ", extensao=" + this.getExtensao() + ", link=" + this.getLink() + ", arquivoFisico=" + Arrays.toString(this.getArquivoFisico()) + ", tamanhoArquivo=" + this.getTamanhoArquivo() + ", dataArquivo=" + this.getDataArquivo() + ", ativo=" + this.getAtivo() + ", dataValidade=" + this.getDataValidade() + ")";
    }

    @Generated
    public ArquivoDTO() {
    }

    @Generated
    public ArquivoDTO(Long id, String nomeArquivo, String extensao, String link, byte[] arquivoFisico, Long tamanhoArquivo, LocalDate dataArquivo, String ativo, LocalDate dataValidade) {
        this.id = id;
        this.nomeArquivo = nomeArquivo;
        this.extensao = extensao;
        this.link = link;
        this.arquivoFisico = arquivoFisico;
        this.tamanhoArquivo = tamanhoArquivo;
        this.dataArquivo = dataArquivo;
        this.ativo = ativo;
        this.dataValidade = dataValidade;
    }
}

