/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.comprasportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.RecursoArquivoDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.RecursoDTO;
import br.com.elotech.portaltransparencia.comprasportal.repository.RecursoRepository;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindRecursoParams;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class RecursoRepositoryImpl
implements RecursoRepository {
    private static final String RECURSO = "db/sql/compras/recurso.sql";
    private static final String RECURSOARQUIVOS = "db/sql/compras/recursoArquivos.sql";
    private final DatasourceWrapper datasourceWrapper;

    @Autowired
    public RecursoRepositoryImpl(DatasourceWrapper datasourceWrapper) {
        this.datasourceWrapper = datasourceWrapper;
    }

    public RecursoDTO findRecurso(FindRecursoParams params) {
        Object sql = FileUtils.readResourceAsString((String)RECURSO);
        sql = (String)sql + params.montaWhere();
        return (RecursoDTO)this.datasourceWrapper.getJdbcTemplate().queryForObject((String)sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(RecursoDTO.class));
    }

    public List<RecursoArquivoDTO> findArquivos(FindRecursoParams params, String nomeSchemaEloArquivo) {
        RecursoDTO recurso = this.findRecurso(params);
        String sqlArquivos = FileUtils.readResourceAsString((String)RECURSOARQUIVOS).replace("schema_eloarquivo", nomeSchemaEloArquivo);
        MapSqlParameterSource paramsWhere = new MapSqlParameterSource();
        paramsWhere.addValue("idchave", (Object)String.format("R%s", recurso.getId()), 12);
        return this.datasourceWrapper.getJdbcTemplate().query(sqlArquivos, (SqlParameterSource)paramsWhere, (RowMapper)new ElotechBeanPropertyRowMapper(RecursoArquivoDTO.class));
    }
}

