/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.resource;

import br.com.elotech.core.config.ElotechProperties;
import br.com.elotech.folhapagamento.client.domain.PortalTransparenciaLotacaoDTO;
import br.com.elotech.folhapagamento.client.domain.PortalTransparenciaLotacaoServidorDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.HorasExtrasDetalhesDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.PermutaDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ProcessoDisciplinarDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.RegistroPontoDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorDadosPensaoDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorResumoNaturezaDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorVencimentosDescontosDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidoresHorasExtrasDTO;
import br.com.elotech.portaltransparencia.aiseportal.service.ServidorService;
import br.com.elotech.portaltransparencia.aiseportal.ws.domain.GetServidoresCedidosRespostaResult;
import br.com.elotech.portaltransparencia.web.rest.params.HorasExtrasDetalhesParams;
import br.com.elotech.portaltransparencia.web.rest.params.PermutaParams;
import br.com.elotech.portaltransparencia.web.rest.params.ProcessoAdministrativoParams;
import br.com.elotech.portaltransparencia.web.rest.params.ServidorCedidoParams;
import br.com.elotech.portaltransparencia.web.rest.params.ServidorParams;
import java.text.ParseException;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/api/servidores"})
public class ServidorResource {
    private final ServidorService servidorService;
    private final ElotechProperties elotechProperties;
    private static final Integer MAXIMO_REGISTROS_SERVIDORES = 15000;

    @Autowired
    public ServidorResource(ServidorService servidorService, ElotechProperties elotechProperties) {
        this.servidorService = servidorService;
        this.elotechProperties = elotechProperties;
    }

    @GetMapping
    public ResponseEntity<Page<ServidorDTO>> loadServidores(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid ServidorParams servidorParams, Pageable pageable) {
        servidorParams.setEntidade(entidade);
        servidorParams.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.servidorService.loadServidores(servidorParams, pageable));
    }

    @GetMapping(value={"/report"})
    public ModelAndView loadServidoresExport(HttpServletRequest request, HttpServletResponse response, @Valid ServidorParams servidorParams, Pageable pageable) throws Throwable {
        PageRequest page = PageRequest.of((int)0, (int)MAXIMO_REGISTROS_SERVIDORES, (Sort)pageable.getSort());
        Page servidoresPage = this.servidorService.loadServidores(servidorParams, (Pageable)page);
        return this.servidorService.exportReport(request, response, servidorParams, servidoresPage);
    }

    @GetMapping(value={"/{matricula}"})
    public ResponseEntity<ServidorDTO> findServidor(@PathVariable Long matricula, @RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid ServidorParams servidorParams) {
        servidorParams.setEntidade(entidade);
        servidorParams.setExercicio(exercicio);
        servidorParams.setMatricula(matricula);
        Optional servidor = this.servidorService.loadServidor(servidorParams);
        if (servidor.isPresent()) {
            return ResponseEntity.ok((Object)((ServidorDTO)servidor.get()));
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{vinculo}/{matricula}/{entidadeOrigem}"})
    public ResponseEntity<ServidorDTO> findServidorPorVinculo(@PathVariable(name="vinculo") String vinculo, @PathVariable(name="matricula") Long matricula, @PathVariable(name="entidadeOrigem") Long entidadeOrigem, @RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid ServidorParams servidorParams) {
        servidorParams.setEntidade(entidade);
        servidorParams.setExercicio(exercicio);
        servidorParams.setMatricula(matricula);
        servidorParams.setVinculo(vinculo);
        servidorParams.setEntidadeOrigem(entidadeOrigem);
        Optional servidor = this.servidorService.loadServidor(servidorParams);
        if (servidor.isPresent()) {
            return ResponseEntity.ok((Object)((ServidorDTO)servidor.get()));
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/dados-pensao"}, params={"matricula", "entidadeOrigem"})
    public ResponseEntity<ServidorDadosPensaoDTO> findDadosPensaoServidor(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid ServidorParams servidorParams) {
        servidorParams.setEntidade(entidade);
        servidorParams.setExercicio(exercicio);
        Optional servidor = this.servidorService.loadPensaoServidor(servidorParams);
        return servidor.map(ResponseEntity::ok).orElse(ResponseEntity.noContent().build());
    }

    @GetMapping(value={"/vencimentos-descontos"}, params={"matricula", "anoCompetencia", "mesCompetencia", "tipoEvento", "tipoFolha", "codigoCalculo", "entidadeOrigem"})
    public ResponseEntity<List<ServidorVencimentosDescontosDTO>> loadVencimentosEDescontosServidor(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid ServidorParams servidorParams) {
        servidorParams.setEntidade(entidade);
        servidorParams.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.servidorService.loadVencimentoEDescontos(servidorParams));
    }

    @GetMapping(value={"/registros-pontos"}, params={"matricula", "anoCompetencia", "mesCompetencia"})
    public ResponseEntity<List<RegistroPontoDTO>> loadRegistroPontoServidor(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid ServidorParams servidorParams) {
        return ResponseEntity.ok((Object)this.servidorService.loadRegistroPonto(servidorParams));
    }

    @GetMapping(value={"/situacoes"})
    public ResponseEntity<List<String>> getSituacoes(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio) {
        return ResponseEntity.ok((Object)this.servidorService.getSituacoes(entidade, exercicio));
    }

    @GetMapping(value={"/resumonatureza"})
    public ResponseEntity<List<ServidorResumoNaturezaDTO>> loadServidoresResumoNatureza(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid ServidorParams servidorParams) {
        servidorParams.setEntidade(entidade);
        servidorParams.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.servidorService.loadServidoresResumoNatureza(servidorParams));
    }

    @GetMapping(value={"/aposentados"})
    public ResponseEntity<Page<ServidorDTO>> loadServidoresAposentados(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid ServidorParams servidorParams, Pageable pageable) {
        servidorParams.setEntidade(entidade);
        servidorParams.setExercicio(exercicio);
        servidorParams.setSituacao("Aposentado(a)");
        return ResponseEntity.ok((Object)this.servidorService.loadAposentadosPensionistas(servidorParams, pageable));
    }

    @GetMapping(value={"/aposentados/report"})
    public ModelAndView loadServidoresAposentadosExport(HttpServletRequest request, HttpServletResponse response, @Valid ServidorParams servidorParams, Pageable pageable) throws Throwable {
        servidorParams.setSituacao("Aposentado(a)");
        PageRequest page = PageRequest.of((int)0, (int)MAXIMO_REGISTROS_SERVIDORES);
        Page aposentadosPage = this.servidorService.loadAposentadosPensionistas(servidorParams, (Pageable)page);
        return this.servidorService.exportReport(request, response, servidorParams, aposentadosPage);
    }

    @GetMapping(value={"/hora-extra"}, params={"mesCompetencia"})
    public ResponseEntity<ServidoresHorasExtrasDTO> loadServidoresHorasExtras(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid ServidorParams servidorParams) {
        servidorParams.setEntidade(entidade);
        servidorParams.setExercicio(exercicio);
        servidorParams.setAnoCompetencia(exercicio);
        Optional horaExtra = this.servidorService.loadServidoresHorasExtras(servidorParams);
        return horaExtra.map(ResponseEntity::ok).orElse(ResponseEntity.noContent().build());
    }

    @GetMapping(value={"/permutas"})
    public ResponseEntity<Page<PermutaDTO>> loadPermutas(@RequestHeader(value="entidade") Long entidade, @Valid PermutaParams permutaParams, Pageable pageable) {
        return ResponseEntity.ok((Object)this.servidorService.loadPermutas(permutaParams, pageable));
    }

    @GetMapping(value={"/hora-extra/detalhes"}, params={"mesCompetencia", "secretaria"})
    public ResponseEntity<List<HorasExtrasDetalhesDTO>> loadServidoresHorasExtrasDetalhes(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid HorasExtrasDetalhesParams horasExtrasDetalhesParams) {
        horasExtrasDetalhesParams.setAnoCompetencia(exercicio);
        return ResponseEntity.ok((Object)this.servidorService.loadHorasExtrasDetalhes(horasExtrasDetalhesParams));
    }

    @GetMapping(value={"/verbas/{definicao}/{competencia}"})
    public ResponseEntity<List<PortalTransparenciaLotacaoDTO>> findVerbas(@PathVariable(name="definicao") Long definicaoEvento, @PathVariable(name="competencia") Long competencia, @RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio) {
        ServidorParams params = new ServidorParams();
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        params.setAnoCompetencia(exercicio);
        params.setMesCompetencia(competencia);
        return ResponseEntity.ok((Object)this.servidorService.findVerbas(definicaoEvento, params));
    }

    @GetMapping(value={"/verbas/detalhes/{codigoDefinicaoEvento}/{competencia}/{lotacao}"})
    public ResponseEntity<List<PortalTransparenciaLotacaoServidorDTO>> findVerbaDetalhes(@PathVariable(name="codigoDefinicaoEvento") Long codigoDefinicaoEvento, @PathVariable(name="competencia") Long competencia, @PathVariable(name="lotacao") String lotacao, @RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio) {
        ServidorParams params = new ServidorParams();
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        params.setMesCompetencia(competencia);
        params.setLotacao(lotacao);
        return ResponseEntity.ok((Object)this.servidorService.findVerbaDetalhes(codigoDefinicaoEvento, params));
    }

    @GetMapping(value={"/processos-disciplinares"})
    public ResponseEntity<Page<ProcessoDisciplinarDTO>> loadProcessosDiscipinares(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid ProcessoAdministrativoParams processoAdministrativoParams, Pageable pageable) throws ParseException {
        processoAdministrativoParams.setDataInicio(String.format("01/01/%d", exercicio));
        processoAdministrativoParams.setDataFim(String.format("31/12/%d", exercicio));
        return ResponseEntity.ok((Object)this.servidorService.loadProcessosDisciplinares(processoAdministrativoParams, pageable));
    }

    @GetMapping(value={"/cedidos"})
    public ResponseEntity<GetServidoresCedidosRespostaResult> loadServidoresCedidos(@Valid ServidorCedidoParams servidorCedidoParams) {
        return ResponseEntity.ok((Object)this.servidorService.loadServidoresCedidos(servidorCedidoParams));
    }
}

