/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.folhaportal.service;

import br.com.elotech.core.utils.EloPage;
import br.com.elotech.folhapagamento.client.IntegracaoFolhaPortalTransparenciaClient;
import br.com.elotech.folhapagamento.client.domain.PortalTransparenciaDadosServidorDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.PensionistaDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ServidorVencimentosDescontosDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.converter.PensionistaDTOConverter;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.converter.ServidorParamsConverter;
import br.com.elotech.portaltransparencia.aiseportal.service.PensionistaService;
import br.com.elotech.portaltransparencia.folhaportal.service.VencimentoDescontoServiceOxy;
import br.com.elotech.portaltransparencia.web.rest.params.ServidorParams;
import br.com.elotech.reportexport.exporter.BaseExport;
import br.com.elotech.unico.client.EntidadeFeignClient;
import br.com.elotech.unico.client.domain.EntidadeDTO;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class PensionistaServiceOxy
implements PensionistaService {
    private final IntegracaoFolhaPortalTransparenciaClient integracaoFolhaPortalTransparenciaClient;
    private final VencimentoDescontoServiceOxy vencimentoDescontoServiceOxy;
    private final EntidadeFeignClient entidadeClient;
    private final BaseExport baseExport;

    public Page<PensionistaDTO> loadPensionistas(ServidorParams params, Pageable pageable) {
        EloPage pensionistas = this.integracaoFolhaPortalTransparenciaClient.getPensionistas(ServidorParamsConverter.toDTO((ServidorParams)params), pageable);
        return new PageImpl(pensionistas.getContent().stream().map(PensionistaDTOConverter::portalTransparenciaServidoresDTOToPensionistaDTO).collect(Collectors.toList()), pageable, pensionistas.getTotalElements());
    }

    public Optional<PensionistaDTO> loadPensionista(ServidorParams params) {
        Long entidade = (Long)ObjectUtils.defaultIfNull((Object)params.getEntidadeAise(), (Object)params.getEntidade());
        PortalTransparenciaDadosServidorDTO dadosPensionista = this.integracaoFolhaPortalTransparenciaClient.getDadosPensionista(entidade, params.getExercicio(), params.getMatricula());
        if (Objects.nonNull(dadosPensionista)) {
            return Optional.of(PensionistaDTOConverter.portalTransparenciaDadosServidorDTOToPensionistaDTO((PortalTransparenciaDadosServidorDTO)dadosPensionista));
        }
        return Optional.empty();
    }

    public List<ServidorVencimentosDescontosDTO> loadVencimentoEDescontos(ServidorParams params) {
        return this.vencimentoDescontoServiceOxy.getLoadVencimentoEDescontos(params);
    }

    public String findNomeEntidadeById(Long entidadeId) {
        EntidadeDTO entidadeDTO = this.entidadeClient.findOne(entidadeId);
        return Objects.nonNull(entidadeDTO) ? entidadeDTO.getNome() : "";
    }

    @Generated
    public PensionistaServiceOxy(IntegracaoFolhaPortalTransparenciaClient integracaoFolhaPortalTransparenciaClient, VencimentoDescontoServiceOxy vencimentoDescontoServiceOxy, EntidadeFeignClient entidadeClient, BaseExport baseExport) {
        this.integracaoFolhaPortalTransparenciaClient = integracaoFolhaPortalTransparenciaClient;
        this.vencimentoDescontoServiceOxy = vencimentoDescontoServiceOxy;
        this.entidadeClient = entidadeClient;
        this.baseExport = baseExport;
    }

    @Generated
    public BaseExport getBaseExport() {
        return this.baseExport;
    }
}

