/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource;

import br.com.elotech.core.config.ElotechProperties;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.EntidadeComprasDTO;
import br.com.elotech.portaltransparencia.comprasportal.service.impl.EntidadeComprasService;
import br.com.elotech.portaltransparencia.contabportal.domain.AcordoSemRecurso;
import br.com.elotech.portaltransparencia.contabportal.resource.params.AcordoSemRecursoParams;
import br.com.elotech.portaltransparencia.contabportal.service.AcordoSemRecursoService;
import br.com.elotech.reportexport.exporter.BaseExport;
import br.com.elotech.reportexport.exporter.ReportParam;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/api/acordos-sem-recurso"})
public class AcordoSemRecursoResource {
    private final AcordoSemRecursoService service;
    private final ElotechProperties elotechProperties;
    private final EntidadeComprasService entidadeComprasService;
    private final BaseExport baseExport;

    @Autowired
    public AcordoSemRecursoResource(AcordoSemRecursoService acordoSemRecursoService, ElotechProperties elotechProperties, EntidadeComprasService entidadeComprasService, BaseExport baseExport) {
        this.service = acordoSemRecursoService;
        this.elotechProperties = elotechProperties;
        this.entidadeComprasService = entidadeComprasService;
        this.baseExport = baseExport;
    }

    @GetMapping
    public ResponseEntity<Page<AcordoSemRecurso>> findAcordos(@RequestParam(value="entidade", required=false) Long entidade, @RequestParam(value="exercicio", required=false) Long exercicio, @Valid AcordoSemRecursoParams params, Pageable pageable) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.service.findByParams(params, pageable));
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<AcordoSemRecurso> findById(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.service.findById(id));
    }

    @GetMapping(value={"/report"})
    public ModelAndView exportAcordos(HttpServletRequest request, HttpServletResponse response, @Valid AcordoSemRecursoParams params, Pageable pageable) throws Throwable {
        EntidadeComprasDTO entidadeCompras;
        PageRequest pageRequest = PageRequest.of((int)0, (int)this.elotechProperties.getReport().getMaximoRegistros(), (Sort)pageable.getSort());
        Page page = this.service.findByParams(params, (Pageable)pageRequest);
        ReportParam reportParam = new ReportParam();
        if (Objects.nonNull(params.getEntidade()) && Objects.nonNull(entidadeCompras = this.entidadeComprasService.findOne((Long)params.getEntidade().get()))) {
            reportParam.setNomeEntidade(entidadeCompras.getNome());
        }
        reportParam.setReportTitle("Listagem Acordos sem Recursos Financeiros");
        reportParam.setClazzDTO(AcordoSemRecurso.class);
        reportParam.setHeaderFields("N\u00famero,Ano,Tipo,Parte Contratada,Situa\u00e7\u00e3o,In\u00edcio,T\u00e9rmino,Objeto");
        reportParam.setFields("numero,ano,tipo,nomeFornecedor,situacao,dataInicio,dataTermino,objeto");
        float[] fieldsPerc = new float[]{0.4f, 0.3f, 0.6f, 1.0f, 0.6f, 0.6f, 0.6f, 2.0f};
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        int[] fieldTab = new int[]{10, 7, 15, 25, 15, 15, 15, 50};
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setPage(page);
        reportParam.setFontSize(8.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(params.getExportType());
        return this.baseExport.toExport(reportParam);
    }
}

