/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.comprasportal.repository.impl;

import br.com.elotech.atos.client.AtosFeignClient;
import br.com.elotech.atos.client.dto.ConvenioAditivoDTO;
import br.com.elotech.atos.client.dto.ConvenioPortalDTO;
import br.com.elotech.core.utils.EloPage;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ArquivoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EmpenhoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.SubvencaoAditivoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.SubvencaoArquivoSitDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.SubvencaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.SubvencaoRemuneracaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.SubvencaoSituacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.SubvencaoRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.AditivoParams;
import br.com.elotech.portaltransparencia.contabportal.resource.params.FindPessoalParams;
import br.com.elotech.portaltransparencia.contabportal.resource.params.PrestacaoContasParams;
import br.com.elotech.portaltransparencia.contabportal.resource.params.SubvencaoParams;
import br.com.elotech.portaltransparencia.utils.MaskFormatterUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class SubvencaoOxyRepositoryImpl
implements SubvencaoRepository {
    private static final HashMap<String, Function<Sort.Direction, Sort.Order>> ORDERS = new HashMap();
    private static final HashMap<String, Function<String, String>> FILTERS = new HashMap();
    private static final long TIPO_SISTEMA_SUBVENCAO = 2L;
    private static final List<String> IGNORE_SORTING = List.of("valorAditivo", "valorLiberado", "saldoAtualizado");
    private final AtosFeignClient atosFeignClient;

    public Page<SubvencaoDTO> findSubvencoes(SubvencaoParams params, Pageable pageable) {
        EloPage convenios = this.atosFeignClient.findAllConvenios(this.buildSearch(params), this.buildSort(pageable));
        List subvencoes = convenios.getContent().stream().map(SubvencaoDTO::toSubvencaoDTO).collect(Collectors.toList());
        return new PageImpl(subvencoes, pageable, convenios.getTotalElements());
    }

    public SubvencaoDTO findSubvencao(SubvencaoParams params) {
        return SubvencaoDTO.toSubvencaoDTO((ConvenioPortalDTO)this.atosFeignClient.findConvenioById((Long)params.getSubvencaoId().get()));
    }

    public List<SubvencaoAditivoDTO> findAditivos(SubvencaoParams params) {
        return this.atosFeignClient.findAllConveniosAditivosByConvenioId((Long)params.getSubvencaoId().get()).stream().map(aditivo -> SubvencaoAditivoDTO.ofConvenioAditivo((ConvenioAditivoDTO)aditivo, (Long)params.getExercicio(), (Long)params.getEntidade(), (Long)params.getSubvencao())).collect(Collectors.toList());
    }

    public SubvencaoAditivoDTO findAditivo(AditivoParams params) {
        return SubvencaoAditivoDTO.ofConvenioAditivo((ConvenioAditivoDTO)this.atosFeignClient.findConvenioAditivoById((Long)params.getAditivoId().get()), (Long)params.getExercicio(), (Long)params.getEntidade(), (Long)params.getSubvencao());
    }

    public List<ArquivoDTO> findAditivoAnexos(AditivoParams params) {
        return List.of();
    }

    public List<ArquivoDTO> findSubvencaoAnexo(SubvencaoParams params) {
        return this.atosFeignClient.findAllConvenioAnexoByIdConvenio((Long)params.getSubvencaoId().get()).stream().map(ArquivoDTO::ofConvenioAnexo).collect(Collectors.toList());
    }

    public List<ArquivoDTO> findCertidaoAnexo(SubvencaoParams params) {
        return List.of();
    }

    public Page<SubvencaoArquivoSitDTO> findSubvencaoArquivoSit(FindPessoalParams params, Pageable pageable) {
        ArrayList list = new ArrayList();
        return new PageImpl(list, pageable, 0L);
    }

    public List<EmpenhoDTO> findValoresLiberados(SubvencaoParams params) {
        return List.of();
    }

    public List<SubvencaoSituacaoDTO> findPrestacoesContas(SubvencaoParams params) {
        return List.of();
    }

    public SubvencaoSituacaoDTO findPrestacaoContas(PrestacaoContasParams params) {
        return new SubvencaoSituacaoDTO();
    }

    public List<ArquivoDTO> findPrestacaoContasAnexo(PrestacaoContasParams params) {
        return List.of();
    }

    public List<SubvencaoRemuneracaoDTO> findRemuneracoes(SubvencaoParams params) {
        return List.of();
    }

    private String buildSearch(SubvencaoParams params) {
        StringBuilder search = new StringBuilder().append(String.format("tipoRegistroConvenio==%s", 2L));
        Optional.ofNullable(params.getEntidade()).ifPresent(entidade -> search.append((String)((Function)FILTERS.get("entidade")).apply(entidade.toString())));
        Optional.ofNullable(params.getAnoSubvencao()).ifPresent(anoSubvencao -> search.append((String)((Function)FILTERS.get("anoSubvencao")).apply(anoSubvencao.toString())));
        Optional.ofNullable(params.getCnpj()).ifPresent(cnpj -> search.append((String)((Function)FILTERS.get("cnpj")).apply(MaskFormatterUtils.somenteNumeros((String)cnpj))));
        Optional.ofNullable(params.getNomeBeneficiario()).ifPresent(nome -> search.append((String)((Function)FILTERS.get("nomeBeneficiario")).apply(nome)));
        Optional.ofNullable(params.getObjeto()).ifPresent(objeto -> search.append((String)((Function)FILTERS.get("objeto")).apply(objeto)));
        Optional.ofNullable(params.getExercicio()).ifPresent(exercicio -> search.append((String)((Function)FILTERS.get("exercicio")).apply(exercicio.toString())));
        Optional.ofNullable(params.getTipo()).ifPresent(tipo -> search.append((String)((Function)FILTERS.get("tipo")).apply(tipo.toString())));
        Optional.ofNullable(params.getDataAssinatura()).ifPresent(dataAssinatura -> search.append((String)((Function)FILTERS.get("dataAssinatura")).apply(dataAssinatura.toString())));
        return search.substring(0);
    }

    private Pageable buildSort(Pageable pageable) {
        ArrayList orders = new ArrayList();
        if (pageable.getSort().isSorted() && pageable.getSort().stream().noneMatch(sort -> IGNORE_SORTING.contains(sort.getProperty()))) {
            pageable.getSort().toList().forEach(sort -> orders.add((Sort.Order)((Function)ORDERS.get(sort.getProperty())).apply(sort.getDirection())));
        }
        return PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)Sort.by(orders));
    }

    @Generated
    public SubvencaoOxyRepositoryImpl(AtosFeignClient atosFeignClient) {
        this.atosFeignClient = atosFeignClient;
    }

    static {
        ORDERS.put("subvencao", direction -> new Sort.Order(direction, "id"));
        ORDERS.put("tipoSubvencao", direction -> new Sort.Order(direction, "tipoConvenio"));
        ORDERS.put("nomeBeneficiario", direction -> new Sort.Order(direction, "beneficiario.pessoa.nome"));
        ORDERS.put("dataInicioConvenio", direction -> new Sort.Order(direction, "dataCelebracao"));
        ORDERS.put("cnpj", direction -> new Sort.Order(direction, "beneficiario.pessoa.cnpjCpf"));
        ORDERS.put("valorPrevisto", direction -> new Sort.Order(direction, "valor"));
        FILTERS.put("entidade", filter -> ";entidade.id==" + filter);
        FILTERS.put("subvencao", filter -> ";id==" + filter);
        FILTERS.put("anoSubvencao", filter -> ";ano==" + filter);
        FILTERS.put("cnpj", filter -> ";beneficiario.pessoa.cnpjCpf==" + filter);
        FILTERS.put("nomeBeneficiario", filter -> ";beneficiario.pessoa.nome=='*" + filter + "*'");
        FILTERS.put("objeto", filter -> ";objetivo=='*" + filter + "*'");
        FILTERS.put("exercicio", filter -> ";ano==" + filter);
        FILTERS.put("tipo", filter -> ";tipoConvenio==" + filter);
        FILTERS.put("dataAssinatura", filter -> ";dataCelebracao==" + filter);
    }
}

