/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.admportal.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.portaltransparencia.contabportal.domain.AcordoSemRecurso;
import br.com.elotech.portaltransparencia.contabportal.domain.ArquivoContab;
import br.com.elotech.portaltransparencia.contabportal.domain.Fornecedor;
import br.com.elotech.portaltransparencia.contabportal.service.ArquivoContabilService;
import br.com.elotech.portaltransparencia.contabportal.service.FornecedorService;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Timestamp;
import lombok.Generated;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AcordoSemRecursoService
extends CrudService<AcordoSemRecurso, Long> {
    private final ArquivoContabilService arquivoService;
    private final FornecedorService fornecedorService;

    protected void beforeSave(AcordoSemRecurso entity, Authentication authentication) {
        entity.setDataUltimaAtualizacao(new Timestamp(System.currentTimeMillis()));
        super.beforeSave((EloEntity)entity, authentication);
    }

    @Transactional
    public Fornecedor getFornecedor(Long id) {
        return this.fornecedorService.getFornecedor(id);
    }

    @Transactional
    public AcordoSemRecurso adicionarArquivo(Long id, MultipartFile file) {
        AcordoSemRecurso acordo = (AcordoSemRecurso)this.findOne((Serializable)id);
        try {
            ArquivoContab novoArquivo = this.arquivoService.salvarArquivo(file, file.getOriginalFilename());
            acordo.setArquivo(this.arquivoService.save(novoArquivo));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return (AcordoSemRecurso)this.save((EloEntity)acordo, null);
    }

    @Transactional
    public AcordoSemRecurso removerArquivo(Long id) {
        AcordoSemRecurso acordo = (AcordoSemRecurso)this.findOne((Serializable)id);
        acordo.setArquivo(null);
        this.arquivoService.remove(acordo.getArquivo().getId());
        return (AcordoSemRecurso)this.save((EloEntity)acordo, null);
    }

    @Generated
    public AcordoSemRecursoService(ArquivoContabilService arquivoService, FornecedorService fornecedorService) {
        this.arquivoService = arquivoService;
        this.fornecedorService = fornecedorService;
    }
}

