SELECT LDOCOMPENSACAO.ENTIDADE,
	   LDOCOMPENSACAO.EXERCICIO,
       LDOCOMPENSACAO.ID,
	   LDOCOMPENSACAO.SETORBENEFICIARIO,
	   LDOCOMPENSACAO.TRIBUTOCONTRIB,
	   LDOCOMPENSACAO.COMPENSACAO,
	   LDOCOMPENSACAO.VALOR1 VALORUM,
	   LDOCOMPENSACAO.VALOR2 VALORDOIS,
	   LDOCOMPENSACAO.VALOR3 VALORTRES,
	   LDOCOMPENSACAO.TIPOTRIBUTO,
	   LDOCOMPENSACAO.TIPOMODALIDADE,
	   CASE 
	     WHEN LDOCOMPENSACAO.TIPOTRIBUTO = 1 THEN 'IPTU'
		 WHEN LDOCOMPENSACAO.TIPOTRIBUTO = 2 THEN 'ITBI'
		 WHEN LDOCOMPENSACAO.TIPOTRIBUTO = 3 THEN 'ISS'
		 WHEN LDOCOMPENSACAO.TIPOTRIBUTO = 4 THEN 'CONTRIBUIÇÃO DE MELHORI'
		 WHEN LDOCOMPENSACAO.TIPOTRIBUTO = 5 THEN 'TAXAS'
		 WHEN LDOCOMPENSACAO.TIPOTRIBUTO = 6 THEN 'OUTROS TRIBUTOS'
		 WHEN LDOCOMPENSACAO.TIPOTRIBUTO = 7 THEN 'COSIP'
		 WHEN LDOCOMPENSACAO.TIPOTRIBUTO = 8 THEN 'IMPUGNAÇÕES/IMPOSIÇÕES'
		 ELSE ''
	   END DESCTIPOTRIBUTO,
	   CASE
	     WHEN LDOCOMPENSACAO.TIPOMODALIDADE = 10 THEN 'Anistia'
		 WHEN LDOCOMPENSACAO.TIPOMODALIDADE = 20 THEN 'Remissão'
		 WHEN LDOCOMPENSACAO.TIPOMODALIDADE = 30 THEN 'Subsídio'
		 WHEN LDOCOMPENSACAO.TIPOMODALIDADE = 40 THEN 'Crédito Presumido'
		 WHEN LDOCOMPENSACAO.TIPOMODALIDADE = 50 THEN 'Alteração de Alíquota ou Modificação de Base de Cálculo'
		 WHEN LDOCOMPENSACAO.TIPOMODALIDADE = 60 THEN 'Outros Benefícios'
		 ELSE ''
	   END DESCTIPOMODALIDADE,
	   LDOCOMPENSACAO.FUNDAMENTOLEGAL,
	   LDOCOMPENSACAO.DESCFUNDAMENTOLEGAL,
	   LDOCOMPENSACAO.IDLEIS_ATOS,
	   LEIS_ATOS.NUMERO,
	   LEIS_ATOS.EXERCICIO EXERCICIO_LEIATO,
	   LEIS_ATOS.ESCOPO,
	   LEIS_ATOS.MOSTRARPORTAL
  FROM ${db.contabilidade.schema}.LDOCOMPENSACAO
  LEFT JOIN ${db.contabilidade.schema}.LEIS_ATOS 
     ON LDOCOMPENSACAO.IDLEIS_ATOS = LEIS_ATOS.ID AND LEIS_ATOS.ENTIDADE = LDOCOMPENSACAO.ENTIDADE AND LEIS_ATOS.EXERCICIO = LDOCOMPENSACAO.EXERCICIO
