SELECT A.ENTIDADE, A.EXERCICIO, A.IDORDEMSERVICO, A.ORDEMSERVICO, A.BEMPROPRIO AS DESCRICAOBEM,
 A.DESCRICAO, A.BEM,
 A.VALOR AS VALORINTERVENCAO,
 C.VALOR AS VALORCONTRATO,
 P.NOME AS EMPRESA,
 ((SELECT SUM(COALESCE(AD.VALOR,0) - COALESCE(AD.VALORREDUCAO,0))
    FROM ${db.aise.schema}.OBRAEMPRESACONTRATOADITIVO AD
   WHERE C.IDEMPRESACONTRATO = AD.IDEMPRESACONTRATO)) AS VALORADITIVO,
 ((SELECT SUM(COALESCE(AC.VALORFATURAMENTO,0) + COALESCE(AC.VALORCONVENIO,0))
    FROM ${db.aise.schema}.OBRAACOMPANHAMENTO AC
   WHERE A.ENTIDADE = AC.ENTIDADE
     AND A.EXERCICIO = AC.EXERCICIO
     AND A.IDORDEMSERVICO = AC.IDORDEMSERVICO)) AS VALORPAGO,
 A.DATAINICIO AS DATA,
 A.IDTIPOACOMPANHAMENTO AS SITUACAO,
 A.PERCENTUAL,
 A.OBJETO,
 C.NOCONTRATO AS NUMEROCONTRATO,
 C.EXERCICIOCONTRATO,
 C.IDCONTRATO,
 COALESCE(C.IDTIPOATOCONTRATO, 1) AS TIPOATO,
 (SELECT
        max(V.CONTRATO)
        FROM
            ${db.compras.schema}.VWCONTRATOS V
       WHERE
           V.IDCONTRATO =  C.IDCONTRATO
           AND V.NUMEROCONTRATO =  C.NOCONTRATO
           AND V.TIPOATO = COALESCE(C.IDTIPOATOCONTRATO, 1)
           AND V.EXERCICIO = C.EXERCICIOCONTRATO
           AND V.ENTIDADE = :entidadeApice  ) AS CONTRATO,
 (SELECT COALESCE(COUNT(*),0) FROM ${db.aise.schema}.OBRAORDEMPLANILHAORCAMENTO B
   WHERE B.ENTIDADE = A.ENTIDADE
   AND B.EXERCICIO = A.EXERCICIO
   AND B.IDORDEMSERVICO = A.IDORDEMSERVICO) AS EXISTEPLANILHA,
   A.PREVISAOTERMINO,
 D.DATA AS ACOMPDATA,
 D.OBSERVACAO AS ACOMPMOTIVO,
 D.DATAPREVISTAREINICIO AS ACOMPPREVISAOREINICIO,
 E.NOME AS ACOMPRESPONSAVELNOME
 FROM ${db.aise.schema}.OBRAORDEMSERVICO A
 LEFT OUTER JOIN ${db.aise.schema}.OBRABEM B ON
      A.ENTIDADE = B.ENTIDADE
      AND A.BEM = B.BEM
 LEFT OUTER JOIN ${db.aise.schema}.OBRAEMPRESACONTRATO C ON
      A.IDEMPRESACONTRATO = C.IDEMPRESACONTRATO
 LEFT OUTER JOIN ${db.aise.schema}.OBRAACOMPANHAMENTO D ON
      A.ENTIDADE = D.ENTIDADE
      AND A.EXERCICIO = D.EXERCICIO
      AND A.IDORDEMSERVICO = D.IDORDEMSERVICO
      AND D.IDTIPOACOMPANHAMENTO = 2
      AND NOT EXISTS(
            SELECT *
            FROM ${db.aise.schema}.OBRAACOMPANHAMENTO D2
            WHERE D2.ENTIDADE = D.ENTIDADE
              AND D2.EXERCICIO = D.EXERCICIO
              AND D2.IDORDEMSERVICO = D.IDORDEMSERVICO
              AND D2.IDTIPOACOMPANHAMENTO = 2
              AND ((D2.DATA > D.DATA) OR
                   (D2.DATA = D.DATA AND D2.SEQUENCIA > D.SEQUENCIA)
                  )
              AND D2.SEQUENCIA <> D.SEQUENCIA)
 LEFT OUTER JOIN ${db.aise.schema}.PESSOA E ON
      D.PESSOA = E.PESSOA
 LEFT OUTER JOIN ${db.aise.schema}.PESSOA P ON
      A.CONSTRUTORA = P.PESSOA
 LEFT OUTER JOIN ${db.aise.schema}.OBRATIPOACOMPANHAMENTO T ON
   A.IDTIPOACOMPANHAMENTO = T.IDTIPOACOMPANHAMENTO
 WHERE A.ENTIDADE = :entidade
  AND EXTRACT(YEAR FROM A.DATAINICIO) <= :exercicio
  AND (A.IDTIPOACOMPANHAMENTO NOT IN (3,4,5)
        or exists( select * FROM ${db.aise.schema}.OBRAACOMPANHAMENTO OA
                   WHERE OA.IDORDEMSERVICO = A.IDORDEMSERVICO
                     AND OA.ENTIDADE = A.ENTIDADE
                     AND OA.EXERCICIO = A.EXERCICIO
                     AND EXTRACT(YEAR from OA.data) = :exercicio ) )

   
