/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.utils.EloPage;
import br.com.elotech.orcamento.client.EmendaParlamentarFeignClient;
import br.com.elotech.orcamento.client.dto.EmendaParlamentarDTO;
import br.com.elotech.portaltransparencia.admportal.domain.EmendaParlamentar;
import br.com.elotech.portaltransparencia.admportal.resource.params.EmendaParlamentarParams;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.converter.EmendaParlamentarConverter;
import br.com.elotech.portaltransparencia.contabportal.service.EmendaParlamentarService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpEntity;
import org.springframework.web.multipart.MultipartFile;

public class EmendaParlamentarOxyService
implements EmendaParlamentarService {
    private EmendaParlamentarFeignClient emendaParlamentarFeignClient;

    public Page<EmendaParlamentar> findByParams(EmendaParlamentarParams params, Pageable pageable) {
        return new PageImpl(((List)Optional.ofNullable(this.emendaParlamentarFeignClient.findBy(this.getFiltros(params), pageable)).map(HttpEntity::getBody).map(EloPage::getContent).orElse(new ArrayList())).stream().map(EmendaParlamentarConverter::fromDTO).collect(Collectors.toList()));
    }

    public void delete(EmendaParlamentar emendaParlamentar) {
        this.emendaParlamentarFeignClient.deleteById(emendaParlamentar.getId());
    }

    public EmendaParlamentar save(EmendaParlamentar emenda) {
        EmendaParlamentarDTO emendaDto = EmendaParlamentarConverter.toDTO((EmendaParlamentar)emenda);
        this.verifyTipoEmenda(emenda);
        return EmendaParlamentarConverter.fromDTO((EmendaParlamentarDTO)this.emendaParlamentarFeignClient.insert(emendaDto));
    }

    public EmendaParlamentar findOne(Long id) {
        return EmendaParlamentarConverter.fromDTO((EmendaParlamentarDTO)this.emendaParlamentarFeignClient.findOne(id));
    }

    public EmendaParlamentar adicionarArquivoPublicacao(Long id, MultipartFile file) {
        return this.findOne(id);
    }

    public EmendaParlamentar removerArquivoPublicacao(Long id) {
        return this.findOne(id);
    }

    public List<EmendaParlamentar> findEmendaParlamentar(Long entidade, Long exercicio) {
        return null;
    }

    public EmendaParlamentar update(EmendaParlamentar emenda) {
        EmendaParlamentarDTO emendaFound = this.emendaParlamentarFeignClient.findOne(emenda.getId());
        this.verifyTipoEmenda(emenda);
        if (Objects.isNull(emendaFound)) {
            throw RestException.notFound();
        }
        emendaFound.setIdEntidade(emenda.getEntidade());
        emendaFound.setNumeroExercicio(emenda.getExercicio());
        emendaFound.setAutor(emenda.getAutoria());
        emendaFound.setTipoEmendaCodigo(emenda.getTipo());
        emendaFound.setNumero(emenda.getNumero());
        emendaFound.setDescricao(emenda.getObjeto());
        emendaFound.setFuncao(emenda.getFuncao());
        emendaFound.setValorPrevisto(BigDecimal.valueOf(emenda.getValorPrevisto()));
        emendaFound.setValorRealizado(BigDecimal.valueOf(emenda.getValorRealizado()));
        return EmendaParlamentarConverter.fromDTO((EmendaParlamentarDTO)this.emendaParlamentarFeignClient.insert(emendaFound));
    }

    private String getFiltros(EmendaParlamentarParams params) {
        StringBuilder filtro = new StringBuilder();
        params.getEntidade().ifPresent(i -> filtro.append("exercicio.entidade.id==").append(params.getEntidade().get()));
        params.getExercicio().ifPresent(i -> filtro.append(";exercicio.exercicio==").append(params.getExercicio().get()));
        return filtro.toString();
    }

    private void verifyTipoEmenda(EmendaParlamentar emenda) {
        String tipoEmenda = emenda.getTipo();
        if (!tipoEmenda.equalsIgnoreCase("P") && !tipoEmenda.equalsIgnoreCase("L")) {
            throw new IllegalArgumentException("Tipo emenda informado deve ser 'P' para Plano Plurianual ou 'L' para Lei Or\u00e7ament\u00e1ria Anual.");
        }
    }

    @Generated
    public EmendaParlamentarOxyService(EmendaParlamentarFeignClient emendaParlamentarFeignClient) {
        this.emendaParlamentarFeignClient = emendaParlamentarFeignClient;
    }
}

