/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.RepasseDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.RepasseMesDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.RepasseRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.FindRepasseParams;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class RepasseRepositoryImpl
implements RepasseRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepasseRepositoryImpl.class);
    private static final String REPASSES = "db/sql/contab/repasses.sql";
    private static final String REPASSES_ENVIADO_MES = "db/sql/contab/repasse-enviado-mes.sql";
    private static final String REPASSES_RECEBIDO_MES = "db/sql/contab/repasse-recebido-mes.sql";
    private final DatasourceWrapper datasourceWrapper;

    @Autowired
    public RepasseRepositoryImpl(DatasourceWrapper datasourceWrapper) {
        this.datasourceWrapper = datasourceWrapper;
    }

    public List<RepasseDTO> findRepasses(FindRepasseParams params) {
        String sql = FileUtils.readResourceAsString((String)REPASSES);
        this.consoleLogger(params, sql);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(RepasseDTO.class));
    }

    private void consoleLogger(FindRepasseParams params, String sql) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(sql);
            LOGGER.debug(params.toString());
        }
    }

    public List<RepasseMesDTO> findRepassesEnviadosMes(FindRepasseParams params) {
        StringBuilder query = this.filtrosRepasses(params, FileUtils.readResourceAsString((String)REPASSES_ENVIADO_MES));
        query.append(" GROUP BY B.DATA, CB.DESCRICAO, C1.CONTA, C.IDCONTACORRENTE, C1.NROLANCAMENTO, B.COMPLEMENTO, B.NRODOCUMENTOORIGEM ");
        query.append(" ORDER BY B.DATA ");
        this.consoleLogger(params, query.toString());
        return this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(RepasseMesDTO.class));
    }

    public List<RepasseMesDTO> findRepassesRecebidosMes(FindRepasseParams params) {
        StringBuilder query = this.filtrosRepasses(params, FileUtils.readResourceAsString((String)REPASSES_RECEBIDO_MES));
        params.getIdContaCorrente().ifPresent(item -> query.append(" AND C.IDCONTACORRENTE = :idContaCorrente "));
        query.append(" ORDER BY B.DATA ");
        this.consoleLogger(params, query.toString());
        return this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(RepasseMesDTO.class));
    }

    public StringBuilder filtrosRepasses(FindRepasseParams params, String sql) {
        StringBuilder query = new StringBuilder(sql);
        params.getDataInicial().ifPresent(item -> query.append(" AND CAST(B.DATA AS DATE) >= :dataInicial "));
        params.getDataFinal().ifPresent(item -> query.append(" AND CAST(B.DATA AS DATE) <= :dataFinal "));
        return query;
    }
}

