/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.domain.dto;

import br.com.elotech.contabilidade.client.dto.DemonstrativoInterferenciaFinanceiraDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.RepasseDTO;
import java.math.BigDecimal;
import lombok.Generated;

public class RepasseDTO {
    private Long entidade;
    private Long exercicio;
    private String conta;
    private Long idContaCorrente;
    private BigDecimal valorLancado;
    private BigDecimal valorPrevistoReceber;
    private BigDecimal valorPrevistoRepassar;
    private BigDecimal valorDevolvido;
    private BigDecimal valorRecebido;
    private BigDecimal valorRestanteReceber;
    private BigDecimal valorRestanteRepassar;
    private String descricao;
    private String tipo;
    private String nomeFornecedor;

    public static RepasseDTO ofDemonstrativo(DemonstrativoInterferenciaFinanceiraDTO demonstrativo, String tipo) {
        RepasseDTO repasseDTO = new RepasseDTO();
        repasseDTO.setEntidade(demonstrativo.getIdEntidade());
        repasseDTO.setExercicio(demonstrativo.getExercicio());
        repasseDTO.setConta(demonstrativo.getDescricao());
        repasseDTO.setIdContaCorrente(demonstrativo.getCodigo());
        if (tipo.equals("R")) {
            repasseDTO.setValorLancado(demonstrativo.getIngresso().abs());
        } else {
            repasseDTO.setValorLancado(demonstrativo.getEgresso().abs());
        }
        repasseDTO.setDescricao(demonstrativo.getDescricao());
        repasseDTO.setTipo(tipo);
        return repasseDTO;
    }

    @Generated
    public static RepasseDTOBuilder builder() {
        return new RepasseDTOBuilder();
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public String getConta() {
        return this.conta;
    }

    @Generated
    public Long getIdContaCorrente() {
        return this.idContaCorrente;
    }

    @Generated
    public BigDecimal getValorLancado() {
        return this.valorLancado;
    }

    @Generated
    public BigDecimal getValorPrevistoReceber() {
        return this.valorPrevistoReceber;
    }

    @Generated
    public BigDecimal getValorPrevistoRepassar() {
        return this.valorPrevistoRepassar;
    }

    @Generated
    public BigDecimal getValorDevolvido() {
        return this.valorDevolvido;
    }

    @Generated
    public BigDecimal getValorRecebido() {
        return this.valorRecebido;
    }

    @Generated
    public BigDecimal getValorRestanteReceber() {
        return this.valorRestanteReceber;
    }

    @Generated
    public BigDecimal getValorRestanteRepassar() {
        return this.valorRestanteRepassar;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public String getTipo() {
        return this.tipo;
    }

    @Generated
    public String getNomeFornecedor() {
        return this.nomeFornecedor;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setConta(String conta) {
        this.conta = conta;
    }

    @Generated
    public void setIdContaCorrente(Long idContaCorrente) {
        this.idContaCorrente = idContaCorrente;
    }

    @Generated
    public void setValorLancado(BigDecimal valorLancado) {
        this.valorLancado = valorLancado;
    }

    @Generated
    public void setValorPrevistoReceber(BigDecimal valorPrevistoReceber) {
        this.valorPrevistoReceber = valorPrevistoReceber;
    }

    @Generated
    public void setValorPrevistoRepassar(BigDecimal valorPrevistoRepassar) {
        this.valorPrevistoRepassar = valorPrevistoRepassar;
    }

    @Generated
    public void setValorDevolvido(BigDecimal valorDevolvido) {
        this.valorDevolvido = valorDevolvido;
    }

    @Generated
    public void setValorRecebido(BigDecimal valorRecebido) {
        this.valorRecebido = valorRecebido;
    }

    @Generated
    public void setValorRestanteReceber(BigDecimal valorRestanteReceber) {
        this.valorRestanteReceber = valorRestanteReceber;
    }

    @Generated
    public void setValorRestanteRepassar(BigDecimal valorRestanteRepassar) {
        this.valorRestanteRepassar = valorRestanteRepassar;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setNomeFornecedor(String nomeFornecedor) {
        this.nomeFornecedor = nomeFornecedor;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RepasseDTO)) {
            return false;
        }
        RepasseDTO other = (RepasseDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$idContaCorrente = this.getIdContaCorrente();
        Long other$idContaCorrente = other.getIdContaCorrente();
        if (this$idContaCorrente == null ? other$idContaCorrente != null : !((Object)this$idContaCorrente).equals(other$idContaCorrente)) {
            return false;
        }
        String this$conta = this.getConta();
        String other$conta = other.getConta();
        if (this$conta == null ? other$conta != null : !this$conta.equals(other$conta)) {
            return false;
        }
        BigDecimal this$valorLancado = this.getValorLancado();
        BigDecimal other$valorLancado = other.getValorLancado();
        if (this$valorLancado == null ? other$valorLancado != null : !((Object)this$valorLancado).equals(other$valorLancado)) {
            return false;
        }
        BigDecimal this$valorPrevistoReceber = this.getValorPrevistoReceber();
        BigDecimal other$valorPrevistoReceber = other.getValorPrevistoReceber();
        if (this$valorPrevistoReceber == null ? other$valorPrevistoReceber != null : !((Object)this$valorPrevistoReceber).equals(other$valorPrevistoReceber)) {
            return false;
        }
        BigDecimal this$valorPrevistoRepassar = this.getValorPrevistoRepassar();
        BigDecimal other$valorPrevistoRepassar = other.getValorPrevistoRepassar();
        if (this$valorPrevistoRepassar == null ? other$valorPrevistoRepassar != null : !((Object)this$valorPrevistoRepassar).equals(other$valorPrevistoRepassar)) {
            return false;
        }
        BigDecimal this$valorDevolvido = this.getValorDevolvido();
        BigDecimal other$valorDevolvido = other.getValorDevolvido();
        if (this$valorDevolvido == null ? other$valorDevolvido != null : !((Object)this$valorDevolvido).equals(other$valorDevolvido)) {
            return false;
        }
        BigDecimal this$valorRecebido = this.getValorRecebido();
        BigDecimal other$valorRecebido = other.getValorRecebido();
        if (this$valorRecebido == null ? other$valorRecebido != null : !((Object)this$valorRecebido).equals(other$valorRecebido)) {
            return false;
        }
        BigDecimal this$valorRestanteReceber = this.getValorRestanteReceber();
        BigDecimal other$valorRestanteReceber = other.getValorRestanteReceber();
        if (this$valorRestanteReceber == null ? other$valorRestanteReceber != null : !((Object)this$valorRestanteReceber).equals(other$valorRestanteReceber)) {
            return false;
        }
        BigDecimal this$valorRestanteRepassar = this.getValorRestanteRepassar();
        BigDecimal other$valorRestanteRepassar = other.getValorRestanteRepassar();
        if (this$valorRestanteRepassar == null ? other$valorRestanteRepassar != null : !((Object)this$valorRestanteRepassar).equals(other$valorRestanteRepassar)) {
            return false;
        }
        String this$descricao = this.getDescricao();
        String other$descricao = other.getDescricao();
        if (this$descricao == null ? other$descricao != null : !this$descricao.equals(other$descricao)) {
            return false;
        }
        String this$tipo = this.getTipo();
        String other$tipo = other.getTipo();
        if (this$tipo == null ? other$tipo != null : !this$tipo.equals(other$tipo)) {
            return false;
        }
        String this$nomeFornecedor = this.getNomeFornecedor();
        String other$nomeFornecedor = other.getNomeFornecedor();
        return !(this$nomeFornecedor == null ? other$nomeFornecedor != null : !this$nomeFornecedor.equals(other$nomeFornecedor));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RepasseDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $idContaCorrente = this.getIdContaCorrente();
        result = result * 59 + ($idContaCorrente == null ? 43 : ((Object)$idContaCorrente).hashCode());
        String $conta = this.getConta();
        result = result * 59 + ($conta == null ? 43 : $conta.hashCode());
        BigDecimal $valorLancado = this.getValorLancado();
        result = result * 59 + ($valorLancado == null ? 43 : ((Object)$valorLancado).hashCode());
        BigDecimal $valorPrevistoReceber = this.getValorPrevistoReceber();
        result = result * 59 + ($valorPrevistoReceber == null ? 43 : ((Object)$valorPrevistoReceber).hashCode());
        BigDecimal $valorPrevistoRepassar = this.getValorPrevistoRepassar();
        result = result * 59 + ($valorPrevistoRepassar == null ? 43 : ((Object)$valorPrevistoRepassar).hashCode());
        BigDecimal $valorDevolvido = this.getValorDevolvido();
        result = result * 59 + ($valorDevolvido == null ? 43 : ((Object)$valorDevolvido).hashCode());
        BigDecimal $valorRecebido = this.getValorRecebido();
        result = result * 59 + ($valorRecebido == null ? 43 : ((Object)$valorRecebido).hashCode());
        BigDecimal $valorRestanteReceber = this.getValorRestanteReceber();
        result = result * 59 + ($valorRestanteReceber == null ? 43 : ((Object)$valorRestanteReceber).hashCode());
        BigDecimal $valorRestanteRepassar = this.getValorRestanteRepassar();
        result = result * 59 + ($valorRestanteRepassar == null ? 43 : ((Object)$valorRestanteRepassar).hashCode());
        String $descricao = this.getDescricao();
        result = result * 59 + ($descricao == null ? 43 : $descricao.hashCode());
        String $tipo = this.getTipo();
        result = result * 59 + ($tipo == null ? 43 : $tipo.hashCode());
        String $nomeFornecedor = this.getNomeFornecedor();
        result = result * 59 + ($nomeFornecedor == null ? 43 : $nomeFornecedor.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RepasseDTO(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", conta=" + this.getConta() + ", idContaCorrente=" + this.getIdContaCorrente() + ", valorLancado=" + this.getValorLancado() + ", valorPrevistoReceber=" + this.getValorPrevistoReceber() + ", valorPrevistoRepassar=" + this.getValorPrevistoRepassar() + ", valorDevolvido=" + this.getValorDevolvido() + ", valorRecebido=" + this.getValorRecebido() + ", valorRestanteReceber=" + this.getValorRestanteReceber() + ", valorRestanteRepassar=" + this.getValorRestanteRepassar() + ", descricao=" + this.getDescricao() + ", tipo=" + this.getTipo() + ", nomeFornecedor=" + this.getNomeFornecedor() + ")";
    }

    @Generated
    public RepasseDTO() {
    }

    @Generated
    public RepasseDTO(Long entidade, Long exercicio, String conta, Long idContaCorrente, BigDecimal valorLancado, BigDecimal valorPrevistoReceber, BigDecimal valorPrevistoRepassar, BigDecimal valorDevolvido, BigDecimal valorRecebido, BigDecimal valorRestanteReceber, BigDecimal valorRestanteRepassar, String descricao, String tipo, String nomeFornecedor) {
        this.entidade = entidade;
        this.exercicio = exercicio;
        this.conta = conta;
        this.idContaCorrente = idContaCorrente;
        this.valorLancado = valorLancado;
        this.valorPrevistoReceber = valorPrevistoReceber;
        this.valorPrevistoRepassar = valorPrevistoRepassar;
        this.valorDevolvido = valorDevolvido;
        this.valorRecebido = valorRecebido;
        this.valorRestanteReceber = valorRestanteReceber;
        this.valorRestanteRepassar = valorRestanteRepassar;
        this.descricao = descricao;
        this.tipo = tipo;
        this.nomeFornecedor = nomeFornecedor;
    }
}

