/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.comprasportal.service.impl;

import br.com.elotech.portaltransparencia.arquivoportal.repository.EloArquivoRepository;
import br.com.elotech.portaltransparencia.comprasportal.domain.AutorizacaoArquivo;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.AutorizacaoLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.repository.AutorizacaoArquivoRepository;
import br.com.elotech.portaltransparencia.comprasportal.repository.AutorizacaoRepository;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindAutorizacaoParams;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindLicitacaoParams;
import br.com.elotech.portaltransparencia.comprasportal.service.AutorizacaoService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AutorizacaoServiceImpl
implements AutorizacaoService {
    private final AutorizacaoRepository autorizacaoRepository;
    private final AutorizacaoArquivoRepository autorizacaoArquivoRepository;
    private final EloArquivoRepository eloArquivoRepository;

    @Autowired
    public AutorizacaoServiceImpl(AutorizacaoRepository autorizacaoRepository, AutorizacaoArquivoRepository autorizacaoArquivoRepository, EloArquivoRepository eloArquivoRepository) {
        this.autorizacaoRepository = autorizacaoRepository;
        this.autorizacaoArquivoRepository = autorizacaoArquivoRepository;
        this.eloArquivoRepository = eloArquivoRepository;
    }

    public List<AutorizacaoLicitacaoDTO> findAutorizacoes(FindLicitacaoParams params) {
        return this.autorizacaoRepository.findAutorizacoes(params);
    }

    public AutorizacaoLicitacaoDTO findAutorizacao(FindAutorizacaoParams params) {
        return this.autorizacaoRepository.findAutorizacao(params);
    }

    public List<AutorizacaoArquivo> findArquivos(FindAutorizacaoParams params) {
        List autorizacaoArquivos = this.autorizacaoArquivoRepository.findByEntidadeAndExercicioAndNumeroRequisicao((Long)params.getEntidade().get(), (Long)params.getExercicio().get(), (Long)params.getNumeroRequisicao().get());
        autorizacaoArquivos.stream().filter(AutorizacaoArquivo::possuiEloArquivo).map(AutorizacaoArquivo::getArquivoCompras).forEach(a -> a.setTamanhoArquivo(this.eloArquivoRepository.getTamanhoArquivo(a.getArquivo().getId())));
        return autorizacaoArquivos;
    }
}

