/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.comprasportal.service.impl;

import br.com.elotech.portaltransparencia.arquivoportal.service.ArquivoService;
import br.com.elotech.portaltransparencia.comprasportal.domain.AdjudicacaoArquivo;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.AdjudicacaoLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.repository.AdjudicacaoRepository;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindAdjudicacaoParams;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindLicitacaoParams;
import br.com.elotech.portaltransparencia.comprasportal.service.AdjudicacaoService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdjudicacaoServiceImpl
implements AdjudicacaoService {
    private final AdjudicacaoRepository adjudicacaoRepository;
    private final ArquivoService arquivoService;

    @Autowired
    public AdjudicacaoServiceImpl(AdjudicacaoRepository adjudicacaoRepository, ArquivoService arquivoService) {
        this.adjudicacaoRepository = adjudicacaoRepository;
        this.arquivoService = arquivoService;
    }

    public List<AdjudicacaoLicitacaoDTO> findAdjudicacoes(FindLicitacaoParams params) {
        return this.adjudicacaoRepository.findAdjudicacoes(params, this.arquivoService.getNomeSchemaEloArquivo());
    }

    public AdjudicacaoLicitacaoDTO findAdjudicacao(FindAdjudicacaoParams params) {
        return this.adjudicacaoRepository.findAdjudicacao(params, this.arquivoService.getNomeSchemaEloArquivo());
    }

    public List<AdjudicacaoArquivo> findArquivos(FindAdjudicacaoParams params) {
        if (!params.getTipoLicitacao().isPresent() && !params.getLicitacao().isPresent()) {
            return new ArrayList<AdjudicacaoArquivo>();
        }
        return this.adjudicacaoRepository.findArquivos(params, this.arquivoService.getNomeSchemaEloArquivo());
    }
}

