/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.comprasportal.repository.impl;

import br.com.elotech.core.config.DBConfigProperties;
import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.PessoaAdmDTO;
import br.com.elotech.portaltransparencia.comprasportal.repository.PessoaAdmRepository;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindPessoaAdmParams;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.service.IntegradoComUnicoService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class PessoaAdmRepositoryImpl
implements PessoaAdmRepository {
    private static final String PESSOASADM = "db/sql/compras/pessoaAdm.sql";
    private static final String PESSOASADMUNICO = "db/sql/compras/pessoaAdmUnico.sql";
    private final DatasourceWrapper datasourceWrapper;
    @Autowired
    private final DBConfigProperties dbConfigProperties;

    @Autowired
    public PessoaAdmRepositoryImpl(DatasourceWrapper datasourceWrapper, DBConfigProperties dbConfigProperties) {
        this.datasourceWrapper = datasourceWrapper;
        this.dbConfigProperties = dbConfigProperties;
    }

    public Page<PessoaAdmDTO> findPessoasAdm(FindPessoaAdmParams params, Pageable pageable) {
        IntegradoComUnicoService integradoComUnicoService = new IntegradoComUnicoService(this.dbConfigProperties);
        StringBuilder query = new StringBuilder();
        if (!integradoComUnicoService.isIntegradoComUnico()) {
            query.append(FileUtils.readResourceAsString((String)PESSOASADM));
        } else {
            query.append(String.format(FileUtils.readResourceAsString((String)PESSOASADMUNICO), this.dbConfigProperties.getUnico().getSchema()));
        }
        query.append(params.montaWhere());
        if (integradoComUnicoService.isIntegradoComUnico()) {
            query.append(" AND A.INATIVO = 'N' ");
        }
        Long qtdPessoa = this.countPessoasAdm(query.toString(), params);
        query.append(" ORDER BY A.NOME ");
        List pessoas = this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(PessoaAdmDTO.class));
        return new PageImpl(pessoas, pageable, qtdPessoa.longValue());
    }

    public Long countPessoasAdm(String sql, FindPessoaAdmParams params) {
        String sqlQuery = String.format("SELECT COUNT(1) FROM (%s) QTD", sql);
        return (Long)this.datasourceWrapper.getJdbcTemplate().queryForObject(sqlQuery, (SqlParameterSource)params.toJdbcParameter(), Long.class);
    }
}

