/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.enumerable.common.SimNao;
import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.admportal.domain.Parametros;
import br.com.elotech.portaltransparencia.admportal.repository.PortalParametroRepository;
import br.com.elotech.portaltransparencia.aiseportal.domain.ObraAcompanhamentoImagem;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.MedicaoObraDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ObraDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ObraEmpenhoPortalDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ObraFontesRescursosPortalDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ObraOrdemServicoArquivoDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ObrasResponsavelDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.PlanilhaObraDTO;
import br.com.elotech.portaltransparencia.aiseportal.repository.ObraRepository;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.AiseParams;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.FindObraParams;
import br.com.elotech.portaltransparencia.aiseportal.service.EntidadeAiseService;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.PortalParametroContabil;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.UltimaAtualizacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.mapper.EmpenhoToObraEmpenhoPortalDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.EmpenhoRepository;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class ObraRepositoryImpl
implements ObraRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObraRepositoryImpl.class);
    private static final String OBRAS_ORDEM_SERVICO_ARQUIVO = "db/sql/aise/obras_ordem_servico_arquivo.sql";
    private static final String OBRAS = "db/sql/aise/obras.sql";
    private static final String OBRA = "db/sql/aise/obra.sql";
    private static final String MEDICOES = "db/sql/aise/medicoes.sql";
    private static final String PLANILHAS = "db/sql/aise/planilhas.sql";
    private static final String ULTIMA_ATUALIZACAO = "db/sql/aise/ultimaAtualizacaoObra.sql";
    private static final String DB_AISE_SCHEMA = "${db.aise.schema}";
    private final EntidadeAiseService entidadeAiseService;
    private final DatasourceWrapper datasourceWrapper;
    private final EmpenhoRepository empenhoRepository;
    private final EntityManager em;
    private final PortalParametroRepository portalParametroRepository;

    @Autowired
    public ObraRepositoryImpl(DatasourceWrapper datasourceWrapper, EntidadeAiseService entidadeAiseService, EmpenhoRepository empenhoRepository, EntityManager em, PortalParametroRepository portalParametroRepository) {
        this.datasourceWrapper = datasourceWrapper;
        this.entidadeAiseService = entidadeAiseService;
        this.empenhoRepository = empenhoRepository;
        this.em = em;
        this.portalParametroRepository = portalParametroRepository;
    }

    public Page<ObraDTO> findObras(FindObraParams params, Pageable pageable) {
        this.entidadeAiseService.setCodigoEntidadeAiseObras((AiseParams)params);
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)OBRAS));
        sql.append(this.getSqlComplementar(params));
        PortalParametroContabil parametro = this.portalParametroRepository.findOneByIdEntidadeAndIdExercicioAndIdId(params.getEntidade(), params.getExercicio(), Parametros.PARAM_EXIBE_OBRAS_SEM_VINCULO_TCE);
        if (parametro == null || Boolean.FALSE.equals(SimNao.toBoolean((String)parametro.getValor(), (Boolean)Boolean.FALSE))) {
            sql.append(" AND A.VINCULADOTCE = 'S' ");
        }
        String sqlCount = String.format("SELECT COUNT(*) FROM (%s) QTD", sql);
        String query = SqlUtils.aplicaOrdenacao((Pageable)pageable, (String)sql.toString(), (String)"ORDER BY A.DATAINICIO DESC");
        query = SqlUtils.aplicaPaginacao((Pageable)pageable, (String)query, (String)this.datasourceWrapper.getPlatform());
        MapSqlParameterSource parameter = params.toJdbcParameter();
        List obras = this.datasourceWrapper.getJdbcTemplate().query(query, (SqlParameterSource)parameter, (RowMapper)new ElotechBeanPropertyRowMapper(ObraDTO.class));
        ObraDTO.setFieldsDisplay((List)obras);
        Long total = (Long)this.datasourceWrapper.getJdbcTemplate().queryForObject(sqlCount, (SqlParameterSource)parameter, Long.class);
        return new PageImpl(obras, pageable, Optional.ofNullable(total).orElse(0L).longValue());
    }

    protected String getSqlComplementar(FindObraParams params) {
        StringBuilder sqlComplementar = new StringBuilder();
        this.addWhereDescricaoBem(params, sqlComplementar);
        this.addWhereDescricaoObra(params, sqlComplementar);
        this.addWhereSituacao(params, sqlComplementar);
        this.addWhereEmpresa(params, sqlComplementar);
        this.addWhereNumeroIntervencao(params, sqlComplementar);
        this.addWhereDataParalisacaoInicio(params, sqlComplementar);
        this.addWhereDataReinicioInicio(params, sqlComplementar);
        this.addWhereDataParalisacaoFim(params, sqlComplementar);
        this.addWhereDataReinicioFim(params, sqlComplementar);
        return sqlComplementar.toString();
    }

    private void addWhereDescricaoObra(FindObraParams params, StringBuilder sqlComplementar) {
        params.getDescricaoObra().ifPresent(i -> sqlComplementar.append(SqlUtils.andLike((String)DB_AISE_SCHEMA, (String)"A.DESCRICAO", (String)((String)params.getDescricaoObra().get()))));
    }

    private void addWhereSituacao(FindObraParams params, StringBuilder sqlComplementar) {
        params.getSituacao().ifPresent(item -> sqlComplementar.append(" AND A.IDTIPOACOMPANHAMENTO = :situacao "));
    }

    private void addWhereDescricaoBem(FindObraParams params, StringBuilder sqlComplementar) {
        params.getDescricaoBem().ifPresent(i -> sqlComplementar.append(SqlUtils.andLike((String)DB_AISE_SCHEMA, (String)"A.BEMPROPRIO", (String)((String)params.getDescricaoBem().get()))));
    }

    private void addWhereEmpresa(FindObraParams params, StringBuilder sqlComplementar) {
        params.getEmpresa().ifPresent(i -> sqlComplementar.append(SqlUtils.andLike((String)DB_AISE_SCHEMA, (String)"P.NOME", (String)((String)params.getEmpresa().get()))));
    }

    private void addWhereNumeroIntervencao(FindObraParams params, StringBuilder sqlComplementar) {
        Optional.ofNullable(params.getIdOrdemServico()).ifPresent(i -> sqlComplementar.append(" AND A.ORDEMSERVICO = :idOrdemServico "));
    }

    private void addWhereDataParalisacaoInicio(FindObraParams params, StringBuilder sqlComplementar) {
        params.getDataParalisacaoInicio().ifPresent(item -> sqlComplementar.append(" AND D.DATA >= :acompDataInicio "));
    }

    private void addWhereDataReinicioInicio(FindObraParams params, StringBuilder sqlComplementar) {
        params.getDataReinicioInicio().ifPresent(item -> sqlComplementar.append(" AND D.DATAPREVISTAREINICIO >= :acompDataReinicioInicio "));
    }

    private void addWhereDataParalisacaoFim(FindObraParams params, StringBuilder sqlComplementar) {
        params.getDataParalisacaoFim().ifPresent(item -> sqlComplementar.append(" AND D.DATA <= :acompDataFim "));
    }

    private void addWhereDataReinicioFim(FindObraParams params, StringBuilder sqlComplementar) {
        params.getDataReinicioFim().ifPresent(item -> sqlComplementar.append(" AND D.DATAPREVISTAREINICIO <= :acompDataReinicioFim "));
    }

    public ObraDTO findObra(FindObraParams params) {
        this.entidadeAiseService.setCodigoEntidadeAiseObras((AiseParams)params);
        StringBuilder query = new StringBuilder(FileUtils.readResourceAsString((String)OBRA));
        this.consoleLogger(params, query);
        return (ObraDTO)this.datasourceWrapper.getJdbcTemplate().queryForObject(query.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(ObraDTO.class));
    }

    public List<ObraOrdemServicoArquivoDTO> findObraServicoArquivos(FindObraParams params) {
        String query = FileUtils.readResourceAsString((String)OBRAS_ORDEM_SERVICO_ARQUIVO);
        return this.datasourceWrapper.getJdbcTemplate().query(query, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(ObraOrdemServicoArquivoDTO.class));
    }

    public List<MedicaoObraDTO> findMedicoes(FindObraParams params) {
        StringBuilder query = new StringBuilder(FileUtils.readResourceAsString((String)MEDICOES));
        this.consoleLogger(params, query);
        return this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(MedicaoObraDTO.class));
    }

    public List<PlanilhaObraDTO> findPlanilhas(FindObraParams params) {
        StringBuilder query = new StringBuilder(FileUtils.readResourceAsString((String)PLANILHAS));
        query.append("ORDER BY OSP.SEQUENCIA");
        this.consoleLogger(params, query);
        return this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(PlanilhaObraDTO.class));
    }

    public List<ObraAcompanhamentoImagem> findArquivosMedicao(FindObraParams params) {
        StringBuilder query = new StringBuilder();
        query.append(" select * from ${db.aise.schema}.OBRAACOMPANHAMENTOIMAGEM ");
        query.append(" where entidade = :entidade ");
        query.append("   and exercicio = :exercicioMedicao ");
        query.append("   and idOrdemServico = :idOrdemServico ");
        query.append("   and acompanhamento = :sequencia ");
        this.consoleLogger(params, query);
        return this.datasourceWrapper.getJdbcTemplate().query(query.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(ObraAcompanhamentoImagem.class));
    }

    private void consoleLogger(FindObraParams params, StringBuilder query) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(query.toString());
            LOGGER.debug(params.toString());
        }
    }

    public List<UltimaAtualizacaoDTO> findUltimaAtualizacao() {
        String sql = FileUtils.readResourceAsString((String)ULTIMA_ATUALIZACAO);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (RowMapper)new ElotechBeanPropertyRowMapper(UltimaAtualizacaoDTO.class));
    }

    public List<ObraEmpenhoPortalDTO> findEmpenhos(FindObraParams params) {
        if (params.getEntidade() == null || params.getIdOrdemServico() == null || params.getExercicioObra().isEmpty()) {
            throw new IllegalArgumentException("Par\u00e2metros inv\u00e1lidos da obra.");
        }
        String search = "id.entidade==".concat(params.getEntidade().toString()).concat(" and exercicioObra==").concat(params.getExercicioObra().orElse(0L).toString()).concat(" and idOrdemObra==").concat(params.getIdOrdemServico().toString());
        Specification specification = Specification.where((Specification)Specification.where((Specification)RsqlUtils.createSpecFrom((EntityManager)this.em, (String)search)));
        return this.empenhoRepository.findAll(specification).stream().map(arg_0 -> ((EmpenhoToObraEmpenhoPortalDTO)new EmpenhoToObraEmpenhoPortalDTO()).apply(arg_0)).collect(Collectors.toList());
    }

    public List<ObraFontesRescursosPortalDTO> findFontesRescurso(FindObraParams params) {
        return null;
    }

    public List<ObrasResponsavelDTO> findResponsaveis(FindObraParams params) {
        return null;
    }
}

