/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.admportal.resource;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.portaltransparencia.admportal.service.AcordoSemRecursoService;
import br.com.elotech.portaltransparencia.contabportal.domain.AcordoSemRecurso;
import java.io.IOException;
import java.io.Serializable;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/admin/acordos-sem-recurso"})
public class AcordoSemRecursoAdmResource
extends CrudResource<AcordoSemRecurso, Long> {
    public AcordoSemRecursoService getService() {
        return (AcordoSemRecursoService)super.getService();
    }

    @GetMapping(value={"/entidade"})
    public ResponseEntity<Page<AcordoSemRecurso>> findByEntidadeAndExercicio(Pageable pageable, @RequestParam(value="entidade") Long entidade, @RequestParam(value="exercicio", required=false) Long exercicio) {
        Specification & Serializable specification = (Specification & Serializable)(root, query, criteriaBuilder) -> {
            Predicate predicate = criteriaBuilder.equal((Expression)root.get("entidade"), (Object)entidade);
            if (exercicio != null) {
                predicate = criteriaBuilder.and((Expression)predicate, (Expression)criteriaBuilder.equal((Expression)root.get("exercicio"), (Object)exercicio));
            }
            return predicate;
        };
        return ResponseEntity.ok((Object)this.getService().findAll((Specification)specification, pageable));
    }

    @PutMapping(value={"/fornecedor/{idFornecedor}"})
    public ResponseEntity<AcordoSemRecurso> update(@RequestBody AcordoSemRecurso acordo, @PathVariable(value="idFornecedor") Long idFornecedor) {
        acordo.setFornecedor(this.getService().getFornecedor(idFornecedor));
        AcordoSemRecurso updated = (AcordoSemRecurso)this.getService().save((EloEntity)acordo, null);
        return ResponseEntity.ok((Object)updated);
    }

    @PostMapping(value={"/fornecedor/{idFornecedor}"})
    public ResponseEntity<AcordoSemRecurso> save(@PathVariable(value="idFornecedor") Long idFornecedor, @RequestBody AcordoSemRecurso acordo) {
        acordo.setFornecedor(this.getService().getFornecedor(idFornecedor));
        return ResponseEntity.ok((Object)((AcordoSemRecurso)this.getService().save((EloEntity)acordo, null)));
    }

    @PostMapping(value={"/{id}/arquivo"})
    public ResponseEntity<AcordoSemRecurso> salvarArquivo(@PathVariable(name="id") Long id, @RequestParam(value="files") MultipartFile file) throws IOException {
        return ResponseEntity.ok((Object)this.getService().adicionarArquivo(id, file));
    }

    @DeleteMapping(value={"/{id}/arquivo"})
    public ResponseEntity<AcordoSemRecurso> deletarArquivo(@PathVariable(name="id") Long id) {
        return ResponseEntity.ok((Object)this.getService().removerArquivo(id));
    }

    @GetMapping(value={"/view/{id}"})
    public ResponseEntity<AcordoSemRecurso> getView(@PathVariable(value="id") Long id) {
        AcordoSemRecurso acordo = (AcordoSemRecurso)this.getService().findOne((Serializable)id);
        if (acordo == null) {
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.ok((Object)acordo);
    }
}

