SELECT P.NOME AS FORNECEDOR, 
        CASE
	    	WHEN P.TIPOPESSOA = 'F'
	    	THEN '**' || SUBSTR(P.CNPJ_CPF,3,5) || '****'
	    	ELSE P.CNPJ_CPF
	    END as CNPJCPF,
       D.DESCRICAO AS TIPOCERTIDAO, 
       F.NUMERODOCUMENTO, 
       F.DATAEMISSAODOCUMENTO AS DATAEMISSAO, 
       F.VALIDADEDOCUMENTO AS DATAVALIDADE,
       CASE WHEN F.NOMEARQUIVO IS NULL THEN ELOARQ.NOME ELSE F.NOMEARQUIVO END AS NOMEARQUIVO,
       LENGTH(AC.ARQUIVO) AS TAMANHOARQUIVO,
       A.IDARQUIVO IDARQUIVO,
       A.DATA AS DATAARQUIVO
  FROM ${db.compras.schema}.CLFORNECEDORDOCUMENTACAO F
 INNER JOIN ${db.compras.schema}.CLLICITACAOFORNECEDOR LF
    ON LF.ENTIDADE = F.ENTIDADE
   AND LF.EXERCICIO = F.EXERCICIO
   AND LF.EXERCICIOLICITACAO = F.EXERCICIOLICITACAO
   AND LF.TIPOLICITACAO = F.TIPOLICITACAO
   AND LF.LICITACAO = F.LICITACAO
   AND LF.PESSOA = F.PESSOA
  JOIN ${db.compras.schema}.CLDOCUMENTACAO D
    ON D.DOCUMENTACAO = F.DOCUMENTACAO
  JOIN ${db.compras.schema}.PESSOA P
    ON P.PESSOA = F.PESSOA
  LEFT JOIN ${db.compras.schema}.PESSOADOCUMENTACAO PD
    ON PD.PESSOA = F.PESSOA
   AND PD.DOCUMENTACAO = F.DOCUMENTACAO
   AND (PD.DATAEMISSAODOCUMENTO = F.DATAEMISSAODOCUMENTO OR F.DATAEMISSAODOCUMENTO IS NULL)
   AND (PD.VALIDADEDOCUMENTO = F.VALIDADEDOCUMENTO OR F.VALIDADEDOCUMENTO IS NULL)
   AND PD.NUMERODOCUMENTO = F.NUMERODOCUMENTO
  LEFT JOIN ${db.compras.schema}.ARQUIVO A
    ON A.ID = COALESCE(F.IDARQUIVO, PD.IDARQUIVO)
   AND COALESCE(A.ARQUIVOSIGILOSO,'N') <> 'S'
  LEFT JOIN schema_eloarquivo.ARQUIVO ELOARQ
    ON ELOARQ.ID = A.IDARQUIVO
  LEFT JOIN schema_eloarquivo.ARQUIVO_CONTENT AC
    ON AC.ID = ELOARQ.ID
 WHERE LF.COMPARECEU = 'S'
   AND F.ENTIDADE = :entidade
   AND F.EXERCICIOLICITACAO = :exercicio
   AND F.TIPOLICITACAO = :tipoLicitacao
   AND F.LICITACAO = :licitacao
   AND F.NUMERODOCUMENTO IS NOT NULL AND F.NUMERODOCUMENTO <> ''
 ORDER BY P.NOME, D.DESCRICAO
