/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service;

import br.com.elotech.contabilidade.client.ExercicioFeignClient;
import br.com.elotech.contabilidade.client.dto.ExercicioDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.service.EntidadeContabilidadeService;
import br.com.elotech.portaltransparencia.utils.EntidadeServiceUtils;
import br.com.elotech.unico.client.EntidadeFeignClient;
import br.com.elotech.unico.client.domain.EntidadeDTO;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

public class EntidadeContabilidadeOxyService
implements EntidadeContabilidadeService {
    private final EntidadeFeignClient entidadeFeignClient;
    private final ExercicioFeignClient exercicioFeignClient;
    private final EntidadeServiceUtils entidadeUtils;

    public EntidadeContabilidadeOxyService(EntidadeFeignClient entidadeFeignClient, ExercicioFeignClient exercicioFeignClient, EntidadeServiceUtils entidadeUtils) {
        this.entidadeFeignClient = entidadeFeignClient;
        this.exercicioFeignClient = exercicioFeignClient;
        this.entidadeUtils = entidadeUtils;
    }

    public Optional<Entidade> getEntidadePrincipal() {
        EntidadeDTO entidadePrincipal = this.entidadeFeignClient.findEntidadePrincipal();
        if (Objects.isNull(entidadePrincipal)) {
            return Optional.empty();
        }
        return Optional.of(Entidade.fromEntidadeContabilidade((EntidadeDTO)entidadePrincipal));
    }

    public String resolveWhereSQL(Long entidade) {
        return this.entidadeUtils.resolveWhereSQL(entidade);
    }

    public Entidade getEntidadeSelecionada(Long idEntidade) {
        return this.findOne(idEntidade);
    }

    public Boolean verificaRegistro(Entidade entidade) {
        return true;
    }

    public List<Entidade> getEntidades() {
        return this.findAll();
    }

    public List<Entidade> findByNome(String nome) {
        return this.findAll();
    }

    public Entidade findOne(Long id) {
        return Entidade.fromEntidadeContabilidade((EntidadeDTO)this.entidadeFeignClient.findOne(id));
    }

    public Integer getTamanhoReceita(Long entidade, Long exercicio) {
        return null;
    }

    public String getUf(Long entidade) {
        return null;
    }

    public String getNomeFundo(Long entidade, Long exercicio, String orgao, String unidade) {
        return "";
    }

    public String getCNPJFundo(Long entidade, Long exercicio, String orgao, String unidade) {
        return "";
    }

    public String isHabilitadoAssinaturaPersonalizadaFundo(Long entidade, Long exercicio, String orgao, String unidade) {
        return "";
    }

    public boolean isHabilitadoPortal(Long entidade) {
        return this.entidadeUtils.isHabilitadoPortal(entidade);
    }

    public List<Entidade> findAll() {
        Object search = "";
        List idsNaoHabilitados = this.entidadeUtils.idsEntidadesNaoHabilitadasPortal();
        if (!idsNaoHabilitados.isEmpty()) {
            search = "entidade.id=out=" + idsNaoHabilitados.stream().map(String::valueOf).collect(Collectors.joining(",", "(", ")"));
        }
        return this.exercicioFeignClient.findAll((String)search, (Pageable)PageRequest.of((int)0, (int)9999)).getContent().stream().map(ExercicioDTO::getEntidade).distinct().map(Entidade::fromEntidadeContabilidade).collect(Collectors.toList());
    }

    public Optional<Entidade> getEntidadePrincipalToLog() {
        return Optional.empty();
    }
}

