/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.config;

import java.util.Arrays;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.ResultSetExtractor;

public class CustomJdbcTemplate
extends JdbcTemplate {
    private final Map<String, String> searchAndReplace;

    public CustomJdbcTemplate(DataSource dataSource, Map<String, String> searchAndReplace) {
        super(dataSource);
        this.searchAndReplace = searchAndReplace;
    }

    private String getSql(String sql) {
        return StringUtils.replaceEachRepeatedly((String)sql, (String[])this.searchAndReplace.keySet().toArray(new String[0]), (String[])this.searchAndReplace.values().toArray(new String[0]));
    }

    public void execute(String sql) throws DataAccessException {
        super.execute(this.getSql(sql));
    }

    public <T> T query(String sql, ResultSetExtractor<T> rse) throws DataAccessException {
        return (T)super.query(this.getSql(sql), rse);
    }

    public int update(String sql) throws DataAccessException {
        return super.update(this.getSql(sql));
    }

    public int[] batchUpdate(String ... sql) throws DataAccessException {
        String[] sqlParsed = (String[])Arrays.stream(sql).map(arg_0 -> this.getSql(arg_0)).toArray();
        return super.batchUpdate(sqlParsed);
    }

    public <T> T execute(String sql, PreparedStatementCallback<T> action) throws DataAccessException {
        return (T)super.execute(this.getSql(sql), action);
    }

    public <T> T query(String sql, PreparedStatementSetter pss, ResultSetExtractor<T> rse) throws DataAccessException {
        return (T)super.query(this.getSql(sql), pss, rse);
    }

    public int update(String sql, PreparedStatementSetter pss) throws DataAccessException {
        return super.update(this.getSql(sql), pss);
    }
}

